/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class MimeMap
implements Serializable {
    private static final String MIME_TYPE = "type=";
    private static final String MIME_EXTS = "exts=";
    private String id;
    private HashMap mimeMappings;

    MimeMap(String id) {
        this.id = id;
    }

    String getId() {
        return this.id;
    }

    void load(String file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            while (true) {
                int valueEnd;
                int valueStart;
                int keyEnd;
                int keyStart;
                char firstChar;
                String line;
                if ((line = in.readLine()) == null) {
                    return;
                }
                int len = line.length();
                if (len <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
                for (keyStart = 0; keyStart < len && Character.isSpace(line.charAt(keyStart)); ++keyStart) {
                }
                if (keyStart == len) continue;
                for (keyEnd = keyStart; keyEnd < len && !Character.isSpace(line.charAt(keyEnd)); ++keyEnd) {
                }
                for (valueStart = keyEnd; valueStart < len && Character.isSpace(line.charAt(valueStart)); ++valueStart) {
                }
                if (valueStart == len) continue;
                for (valueEnd = valueStart; valueEnd < len && !Character.isSpace(line.charAt(valueEnd)); ++valueEnd) {
                }
                String key = line.substring(keyStart, keyEnd);
                String value = line.substring(valueStart, valueEnd);
                this.addMappings(key, value);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    Iterator getExtensions() {
        Iterator ret = null;
        if (this.mimeMappings != null) {
            ret = this.mimeMappings.keySet().iterator();
        }
        return ret;
    }

    String getType(String extension) {
        String ret = null;
        if (this.mimeMappings != null) {
            ret = (String)this.mimeMappings.get(extension);
        }
        return ret;
    }

    private void addMappings(String type2, String exts) {
        int index = type2.indexOf(MIME_TYPE);
        if (index == -1) {
            return;
        }
        type2 = type2.substring(index + MIME_TYPE.length());
        index = exts.indexOf(MIME_EXTS);
        if (index == -1) {
            return;
        }
        if (this.mimeMappings == null) {
            this.mimeMappings = new HashMap();
        }
        exts = exts.substring(index + MIME_EXTS.length());
        index = exts.indexOf(44);
        String ext = null;
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                ext = exts.substring(fromIndex, index).trim();
                if (ext.length() > 0) {
                    this.mimeMappings.put(ext, type2);
                }
                fromIndex = index + 1;
                index = exts.indexOf(44, fromIndex);
            }
            ext = exts.substring(fromIndex);
        } else {
            ext = exts;
        }
        if (ext != null && (ext = ext.trim()).length() > 0) {
            this.mimeMappings.put(ext, type2);
        }
    }
}

