/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.component.visit.PartialVisitContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextImpl
extends PartialViewContext {
    private static Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private PartialResponseWriter partialResponseWriter;
    private List<String> executeIds;
    private Collection<String> renderIds;
    private Boolean ajaxRequest;
    private Boolean partialRequest;
    private Boolean renderAll;
    private FacesContext ctx;
    private boolean processingPhases = false;
    private static final String ORIGINAL_WRITER = "com.sun.faces.ORIGINAL_WRITER";

    public PartialViewContextImpl(FacesContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean isAjaxRequest() {
        this.assertNotReleased();
        this.updateFacesContext();
        if (this.ajaxRequest == null) {
            this.ajaxRequest = "partial/ajax".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
        }
        return this.ajaxRequest;
    }

    @Override
    public boolean isPartialRequest() {
        this.assertNotReleased();
        if (this.partialRequest == null) {
            this.partialRequest = this.isAjaxRequest() || "partial/process".equals(this.ctx.getExternalContext().getRequestHeaderMap().get("Faces-Request"));
        }
        return this.partialRequest;
    }

    @Override
    public boolean isExecuteAll() {
        this.assertNotReleased();
        String execute = this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
        return "@all".equals(execute);
    }

    @Override
    public boolean isRenderAll() {
        this.assertNotReleased();
        this.updateFacesContext();
        if (this.renderAll == null) {
            String render = this.ctx.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            this.renderAll = "@all".equals(render);
        }
        return this.renderAll;
    }

    @Override
    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    @Override
    public void setPartialRequest(boolean isPartialRequest) {
        this.partialRequest = isPartialRequest;
    }

    @Override
    public Collection<String> getExecuteIds() {
        UIViewRoot root;
        this.assertNotReleased();
        if (this.executeIds != null) {
            return this.executeIds;
        }
        this.executeIds = this.populatePhaseClientIds("javax.faces.partial.execute");
        if (!this.executeIds.isEmpty() && (root = this.ctx.getViewRoot()).getFacetCount() > 0 && root.getFacet("javax_faces_metadata") != null) {
            this.executeIds.add(0, "javax_faces_metadata");
        }
        return this.executeIds;
    }

    @Override
    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.renderIds != null) {
            return this.renderIds;
        }
        this.renderIds = this.populatePhaseClientIds("javax.faces.partial.render");
        return this.renderIds;
    }

    @Override
    public void processPartial(PhaseId phaseId) {
        this.updateFacesContext();
        PartialViewContext pvc = this.ctx.getPartialViewContext();
        Collection<String> executeIds = pvc.getExecuteIds();
        Collection<String> renderIds = pvc.getRenderIds();
        UIViewRoot viewRoot = this.ctx.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            if (executeIds == null || executeIds.isEmpty()) {
                return;
            }
            try {
                this.processComponents(viewRoot, phaseId, executeIds, this.ctx);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                PartialResponseWriter writer = pvc.getPartialResponseWriter();
                this.ctx.setResponseWriter(writer);
            }
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            try {
                PartialResponseWriter writer = pvc.getPartialResponseWriter();
                ResponseWriter orig = this.ctx.getResponseWriter();
                this.ctx.getAttributes().put(ORIGINAL_WRITER, orig);
                this.ctx.setResponseWriter(writer);
                ExternalContext exContext = this.ctx.getExternalContext();
                exContext.setResponseContentType("text/xml");
                exContext.addResponseHeader("Cache-Control", "no-cache");
                writer.startDocument();
                if (this.isRenderAll()) {
                    this.renderAll(this.ctx, viewRoot);
                    this.renderState(this.ctx);
                    writer.endDocument();
                    return;
                }
                if (renderIds != null && !renderIds.isEmpty()) {
                    this.processComponents(viewRoot, phaseId, renderIds, this.ctx);
                }
                this.renderState(this.ctx);
                writer.endDocument();
            }
            catch (IOException ex) {
                this.cleanupAfterView();
            }
            catch (RuntimeException ex) {
                this.cleanupAfterView();
                throw ex;
            }
        }
    }

    @Override
    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this.partialResponseWriter == null) {
            this.partialResponseWriter = new DelayedInitPartialResponseWriter(this);
        }
        return this.partialResponseWriter;
    }

    @Override
    public void release() {
        this.released = true;
        this.ajaxRequest = null;
        this.renderAll = null;
        this.partialResponseWriter = null;
        this.executeIds = null;
        this.renderIds = null;
        this.ctx = null;
        this.partialRequest = null;
    }

    private List<String> populatePhaseClientIds(String parameterName) {
        Map<String, String> requestParamMap = this.ctx.getExternalContext().getRequestParameterMap();
        String param = requestParamMap.get(parameterName);
        if (param == null) {
            return new ArrayList<String>();
        }
        String[] pcs = Util.split(param, "[ \t]+");
        return pcs != null && pcs.length != 0 ? new ArrayList<String>(Arrays.asList(pcs)) : new ArrayList<String>();
    }

    private void processComponents(UIComponent component, PhaseId phaseId, Collection<String> phaseClientIds, FacesContext context) throws IOException {
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.EXECUTE_LIFECYCLE);
        PartialVisitContext visitContext = new PartialVisitContext(context, phaseClientIds, hints);
        PhaseAwareVisitCallback visitCallback = new PhaseAwareVisitCallback(this.ctx, phaseId);
        component.visitTree(visitContext, visitCallback);
        if (LOGGER.isLoggable(Level.FINER) && !visitContext.getUnvisitedClientIds().isEmpty()) {
            Collection<String> unvisitedClientIds = visitContext.getUnvisitedClientIds();
            StringBuilder builder = new StringBuilder();
            for (String cur : unvisitedClientIds) {
                builder.append(cur).append(" ");
            }
            LOGGER.log(Level.FINER, "jsf.context.partial_visit_context_unvisited_children", new Object[]{builder.toString()});
        }
    }

    private void renderAll(FacesContext context, UIViewRoot viewRoot) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewRoot");
        if (viewRoot.getChildCount() > 0) {
            for (UIComponent uiComponent : viewRoot.getChildren()) {
                uiComponent.encodeAll(context);
            }
        }
        writer.endUpdate();
    }

    private void renderState(FacesContext context) throws IOException {
        if (!context.getViewRoot().isTransient()) {
            PartialViewContext pvc = context.getPartialViewContext();
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            writer.startUpdate("javax.faces.ViewState");
            String state = context.getApplication().getStateManager().getViewState(context);
            writer.write(state);
            writer.endUpdate();
        }
    }

    private PartialResponseWriter createPartialResponseWriter() {
        Writer out;
        ResponseWriter responseWriter;
        String encoding;
        block4: {
            ExternalContext extContext = this.ctx.getExternalContext();
            encoding = extContext.getRequestCharacterEncoding();
            extContext.setResponseCharacterEncoding(encoding);
            responseWriter = null;
            out = null;
            try {
                out = extContext.getResponseOutputWriter();
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
        if (out != null) {
            responseWriter = this.ctx.getRenderKit().createResponseWriter(out, "text/xml", encoding);
        }
        if (responseWriter instanceof PartialResponseWriter) {
            return (PartialResponseWriter)responseWriter;
        }
        return new PartialResponseWriter(responseWriter);
    }

    private void cleanupAfterView() {
        ResponseWriter orig = (ResponseWriter)this.ctx.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        this.ctx.setResponseWriter(orig);
    }

    private final void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private void updateFacesContext() {
        if (!this.processingPhases || this.ctx.isReleased()) {
            this.ctx = FacesContext.getCurrentInstance();
            this.processingPhases = this.ctx.getCurrentPhaseId() != null;
        }
    }

    private static final class DelayedInitPartialResponseWriter
    extends PartialResponseWriter {
        private ResponseWriter writer;
        private PartialViewContextImpl ctx;

        public DelayedInitPartialResponseWriter(PartialViewContextImpl ctx) {
            super(null);
            this.ctx = ctx;
            ExternalContext extCtx = ctx.ctx.getExternalContext();
            extCtx.setResponseContentType("text/xml");
            extCtx.setResponseCharacterEncoding(extCtx.getRequestCharacterEncoding());
        }

        public ResponseWriter getWrapped() {
            if (this.writer == null) {
                this.writer = this.ctx.createPartialResponseWriter();
            }
            return this.writer;
        }
    }

    private static class PhaseAwareVisitCallback
    implements VisitCallback {
        private PhaseId curPhase;
        private FacesContext ctx;

        private PhaseAwareVisitCallback(FacesContext ctx, PhaseId curPhase) {
            this.ctx = ctx;
            this.curPhase = curPhase;
        }

        public VisitResult visit(VisitContext context, UIComponent comp) {
            block9: {
                try {
                    if (this.curPhase == PhaseId.APPLY_REQUEST_VALUES) {
                        comp.processDecodes(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.PROCESS_VALIDATIONS) {
                        comp.processValidators(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.UPDATE_MODEL_VALUES) {
                        comp.processUpdates(this.ctx);
                        break block9;
                    }
                    if (this.curPhase == PhaseId.RENDER_RESPONSE) {
                        PartialResponseWriter writer;
                        block10: {
                            writer = this.ctx.getPartialViewContext().getPartialResponseWriter();
                            writer.startUpdate(comp.getClientId(this.ctx));
                            try {
                                comp.encodeAll(this.ctx);
                            }
                            catch (Exception ce) {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.severe(ce.toString());
                                }
                                if (!LOGGER.isLoggable(Level.FINE)) break block10;
                                LOGGER.log(Level.FINE, ce.toString(), ce);
                            }
                        }
                        writer.endUpdate();
                        break block9;
                    }
                    throw new IllegalStateException("I18N: Unexpected PhaseId passed to  PhaseAwareContextCallback: " + this.curPhase.toString());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return VisitResult.REJECT;
        }
    }
}

