/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.ThreadAttachment;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeepAliveThreadAttachment
extends ThreadAttachment {
    protected static final Logger logger = SelectorThread.logger();
    private int keepAliveCount;
    private KeepAliveStats keepAliveStats;
    private boolean isTimedOut;

    public void setKeepAliveStats(KeepAliveStats keepAliveStats) {
        this.keepAliveStats = keepAliveStats;
    }

    public int increaseKeepAliveCount() {
        if (this.keepAliveCount == 0 && this.keepAliveStats != null && this.keepAliveStats.isEnabled()) {
            this.keepAliveStats.incrementCountConnections();
        }
        ++this.keepAliveCount;
        if (this.keepAliveStats != null && this.keepAliveStats.isEnabled()) {
            this.keepAliveStats.incrementCountHits();
        }
        return this.keepAliveCount;
    }

    public void resetKeepAliveCount() {
        if (this.keepAliveStats != null && this.keepAliveCount > 0 && this.keepAliveStats.isEnabled()) {
            this.keepAliveStats.decrementCountConnections();
            if (!this.isTimedOut) {
                this.keepAliveStats.incrementCountFlushes();
            } else {
                this.isTimedOut = false;
            }
        }
        this.keepAliveCount = 0;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public void release(SelectionKey selectionKey) {
        this.resetKeepAliveCount();
        super.release(selectionKey);
    }

    public boolean timedOut(SelectionKey selectionKey) {
        Thread t;
        if (!super.timedOut(selectionKey)) {
            return false;
        }
        if (this.keepAliveStats != null && this.keepAliveCount > 0 && this.keepAliveStats.isEnabled()) {
            this.isTimedOut = true;
            this.keepAliveStats.incrementCountTimeouts();
        }
        if ((t = this.activeThread()) != null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_IDLE_THREAD_INTERRUPT(t.getName()));
            }
            t.interrupt();
        }
        return true;
    }
}

