/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.AsyncInterceptor;
import com.sun.grizzly.arp.AsyncProtocolFilter;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.Constants;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.FileCacheFactory;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.ProcessorTaskFactory;
import com.sun.grizzly.http.SelectorThreadConfig;
import com.sun.grizzly.http.SelectorThreadHandler;
import com.sun.grizzly.http.SelectorThreadKeyHandler;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.http.Task;
import com.sun.grizzly.http.ThreadPoolStatistic;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUReadFilter;
import com.sun.grizzly.portunif.ProtocolFinder;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.rcm.ResourceAllocationFilter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.RequestGroupInfo;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyListener;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.FutureImpl;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.WorkerThreadImpl;
import com.sun.grizzly.util.res.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThread
implements Runnable,
MBeanRegistration,
GrizzlyListener {
    public static final String SERVER_NAME = System.getProperty("product.name") != null ? System.getProperty("product.name") : "grizzly";
    private final Object lock = new Object();
    protected int serverTimeout = 0;
    protected InetAddress inet;
    protected int port;
    protected boolean initialized = false;
    protected final AtomicBoolean running = new AtomicBoolean();
    protected String domain;
    protected ObjectName oname;
    protected ObjectName globalRequestProcessorName;
    private ObjectName keepAliveMbeanName;
    private ObjectName connectionQueueMbeanName;
    private ObjectName fileCacheMbeanName;
    protected MBeanServer mserver;
    protected ObjectName processorWorkerThreadName;
    protected boolean tcpNoDelay = false;
    protected int linger = -1;
    protected int socketTimeout = -1;
    protected int keepAliveThreadCount = 1;
    protected String compression = "off";
    protected String noCompressionUserAgents = null;
    protected String restrictedUserAgents = null;
    protected String compressableMimeTypes = "text/html,text/xml,text/plain";
    private volatile String[] parsedCompressableMimeTypes = null;
    private volatile int parsedComressableMimeTypesHash = -1;
    protected int compressionMinSize = 2048;
    private boolean reuseAddress = true;
    protected boolean bufferResponse = false;
    protected int maxHttpHeaderSize = 8192;
    protected boolean isAsyncHttpWriteEnabled;
    protected int maxPostSize = 0x200000;
    private int sendBufferSize = 131072;
    protected Selector selector;
    protected TCPSelectorHandler selectorHandler;
    protected Adapter adapter = null;
    protected ExecutorService threadPool;
    protected ThreadPoolStatistic threadPoolStat;
    protected int transactionTimeout = 300000;
    private boolean useChunking = true;
    protected boolean useDirectByteBuffer = false;
    protected RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    protected KeepAliveStats keepAliveStats = this.createKeepAliveStats();
    protected boolean displayConfiguration = false;
    protected boolean isMonitoringEnabled = false;
    protected int requestBufferSize = 8192;
    protected boolean useByteBufferView = false;
    protected int selectorTimeout = 1000;
    protected Class algorithmClass;
    protected String algorithmClassName = DEFAULT_ALGORITHM;
    public static final String DEFAULT_ALGORITHM = NoParsingAlgorithm.class.getName();
    protected int ssBackLog = 4096;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected String rootFolder = "";
    protected Controller controller;
    protected boolean rcmSupport = false;
    protected PUReadFilter portUnificationFilter;
    protected boolean oOBInline = false;
    protected HashMap<String, Object> properties = new HashMap();
    protected final Queue<ProcessorTask> processorTasks = DataStructures.getCLQinstance(ProcessorTask.class);
    protected final Queue<ProcessorTask> activeProcessorTasks = DataStructures.getCLQinstance(ProcessorTask.class);
    protected int readThreadsCount = -1;
    protected static Logger logger = LoggerUtils.getLogger();
    protected static final StringManager sm = StringManager.getManager("com.sun.grizzly.http.res", Constants.class.getClassLoader());
    protected boolean disableUploadTimeout = true;
    protected int uploadTimeout = 300000;
    private int coreThreads = StatsThreadPool.DEFAULT_MIN_THREAD_COUNT;
    private int maxThreads = StatsThreadPool.DEFAULT_MAX_THREAD_COUNT;
    private String threadPoolClassname;
    protected FileCacheFactory fileCacheFactory;
    protected int secondsMaxAge = -1;
    protected int maxCacheEntries = 1024;
    protected long minEntrySize = Long.MIN_VALUE;
    protected long maxEntrySize = Long.MAX_VALUE;
    protected long maxLargeFileCacheSize = Long.MAX_VALUE;
    protected long maxSmallFileCacheSize = 0x100000L;
    protected boolean isFileCacheEnabled = true;
    protected boolean isLargeFileCacheEnabled = true;
    protected boolean asyncExecution = false;
    protected AsyncHandler asyncHandler;
    protected static boolean defaultAlgorithmInstalled = true;
    private Management jmxManagement = null;
    private ClassLoader classLoader;
    protected static boolean enableNioLogging = false;
    protected static final ConcurrentHashMap<Integer, SelectorThread> selectorThreads = new ConcurrentHashMap();
    private SelectorThreadKeyHandler keyHandler;
    protected boolean forceKeepAlive = false;
    private AsyncInterceptor asyncInterceptor;
    protected volatile ProcessorTaskFactory processorTaskFactory;

    @Deprecated
    public static SelectorThread getSelector(int port) {
        return SelectorThread.getSelector(null, port);
    }

    public static SelectorThread getSelector(InetAddress address, int port) {
        SelectorThread thread = selectorThreads.get(SelectorThread.getSelectorThreadLookupKey(address, port));
        if (thread == null) {
            thread = selectorThreads.get(port);
        }
        return thread;
    }

    public static Enumeration<SelectorThread> getSelectors() {
        return selectorThreads.elements();
    }

    public void registerKey(SelectionKey key) {
        this.selectorHandler.register(key.channel(), 1);
    }

    protected void initController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        LoggerUtils.setLogger(logger);
        Controller.setLogger(logger);
        this.selectorHandler = this.createSelectorHandler();
        this.configureSelectorHandler(this.selectorHandler);
        this.controller.setSelectorHandler(this.selectorHandler);
        this.keyHandler = this.createSelectionKeyHandler();
        this.keyHandler.setLogger(logger);
        long timeout = this.keepAliveStats.getKeepAliveTimeoutInSeconds();
        this.keyHandler.setTimeout(timeout == -1L ? Long.MIN_VALUE : timeout * 1000L);
        this.selectorHandler.setSelectionKeyHandler(this.keyHandler);
        this.configureProtocolChain();
        this.controller.setThreadPool(this.threadPool);
        if (this.readThreadsCount > this.controller.getReadThreadsCount()) {
            this.controller.setReadThreadsCount(this.readThreadsCount);
        } else {
            this.readThreadsCount = this.controller.getReadThreadsCount();
        }
    }

    protected TCPSelectorHandler createSelectorHandler() {
        return new SelectorThreadHandler(this);
    }

    protected SelectorThreadKeyHandler createSelectionKeyHandler() {
        return new SelectorThreadKeyHandler(this);
    }

    protected void configureProtocolChain() {
        final HttpProtocolChain protocolChain = new HttpProtocolChain();
        protocolChain.enableRCM(this.rcmSupport);
        this.configureFilters(protocolChain);
        DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return true;
            }
        };
        this.controller.setProtocolChainInstanceHandler(instanceHandler);
    }

    protected void configureSelectorHandler(TCPSelectorHandler selectorHandler) {
        selectorHandler.setSelector(this.selector);
        selectorHandler.setPort(this.port);
        selectorHandler.setInet(this.inet);
        selectorHandler.setLinger(this.linger);
        selectorHandler.setLogger(logger);
        selectorHandler.setReuseAddress(this.reuseAddress);
        selectorHandler.setSelectTimeout(this.selectorTimeout);
        selectorHandler.setServerTimeout(this.serverTimeout);
        selectorHandler.setSocketTimeout(this.keepAliveStats.getKeepAliveTimeoutInSeconds() * 1000);
        selectorHandler.setSsBackLog(this.ssBackLog);
        selectorHandler.setTcpNoDelay(this.tcpNoDelay);
    }

    protected ProtocolFilter createRaFilter() {
        return new ResourceAllocationFilter(){

            protected ExecutorService newThreadPool(int threadCount, ExecutorService p) {
                if (threadCount == 0) {
                    return null;
                }
                StatsThreadPool threadPool = new StatsThreadPool();
                threadPool.setCorePoolSize(1);
                threadPool.setMaximumPoolSize(threadCount);
                threadPool.setName("RCM_" + threadCount);
                threadPool.start();
                return threadPool;
            }
        };
    }

    protected ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            AsyncProtocolFilter f = new AsyncProtocolFilter(this.algorithmClass, this.inet, this.port);
            if (this.asyncInterceptor != null) {
                f.setInterceptor(this.asyncInterceptor);
            }
            return f;
        }
        return new DefaultProtocolFilter(this.algorithmClass, this.inet, this.port);
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            protocolChain.addFilter(this.portUnificationFilter);
        } else if (this.rcmSupport) {
            protocolChain.addFilter(this.createRaFilter());
        } else {
            ReadFilter readFilter = new ReadFilter();
            protocolChain.addFilter(readFilter);
        }
        ProtocolFilter filter = this.createHttpParserFilter();
        protocolChain.addFilter(filter);
    }

    public void configurePortUnification(Properties props) {
        if (props == null) {
            props = System.getProperties();
        }
        this.portUnificationFilter = new PUReadFilter();
        this.portUnificationFilter.configure(props);
    }

    public void configurePortUnification(List<ProtocolFinder> protocolFinders, List<ProtocolHandler> protocolHandlers, List<PUPreProcessor> preProcessors) {
        this.portUnificationFilter = new PUReadFilter();
        this.portUnificationFilter.configure(protocolFinders, protocolHandlers, preProcessors);
    }

    public ProtocolChain getProtocolChain() {
        if (this.controller == null) {
            throw new IllegalStateException("SelectorThread not initialized (initEndpoint not called)");
        }
        return this.getController().getProtocolChainInstanceHandler().poll();
    }

    protected ExecutorService newThreadPool(int maxQueueSize, String name, int port, int priority) {
        ExecutorService newThreadPool = null;
        if (this.threadPoolClassname == null) {
            newThreadPool = new StatsThreadPool("Grizzly-" + port, this.coreThreads, this.maxThreads, maxQueueSize, StatsThreadPool.DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
            ((StatsThreadPool)newThreadPool).setPort(port);
            ((StatsThreadPool)newThreadPool).setPriority(priority);
        } else {
            try {
                Class<?> threadPoolClass = Class.forName(this.threadPoolClassname);
                newThreadPool = (ExecutorService)threadPoolClass.newInstance();
            }
            catch (Exception e) {
                newThreadPool = new StatsThreadPool("Grizzly-" + port, this.coreThreads, this.maxThreads, maxQueueSize, StatsThreadPool.DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
                ((StatsThreadPool)newThreadPool).setPort(port);
                ((StatsThreadPool)newThreadPool).setPriority(priority);
            }
        }
        if (this.threadPool instanceof ExtendedThreadPool) {
            ExtendedThreadPool extThreadPool = (ExtendedThreadPool)this.threadPool;
            extThreadPool.setCorePoolSize(this.coreThreads);
            extThreadPool.setMaximumPoolSize(this.maxThreads);
            extThreadPool.setName(name);
        }
        return newThreadPool;
    }

    protected void initFileCacheFactory() {
        if (this.fileCacheFactory != null) {
            return;
        }
        this.fileCacheFactory = this.createFileCacheFactory();
        this.configureFileCacheFactory();
    }

    protected FileCacheFactory createFileCacheFactory() {
        return FileCacheFactory.getFactory(this.inet, this.port);
    }

    protected void configureFileCacheFactory() {
        this.fileCacheFactory = FileCacheFactory.getFactory(this.inet, this.port);
        this.fileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
        this.fileCacheFactory.setHeaderBBSize(this.requestBufferSize);
    }

    protected void enableThreadPoolStats() {
        if (this.threadPool instanceof StatsThreadPool) {
            this.threadPoolStat.start();
            this.keepAliveStats.enable();
            StatsThreadPool statsThreadPool = (StatsThreadPool)this.threadPool;
            statsThreadPool.setStatistic(this.threadPoolStat);
            this.threadPoolStat.setThreadPool(this.threadPool);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_STATISTICS());
        }
    }

    protected void disableThreadPoolStats() {
        if (this.threadPool instanceof StatsThreadPool) {
            this.threadPoolStat.stop();
            this.keepAliveStats.disable();
            StatsThreadPool statsThreadPool = (StatsThreadPool)this.threadPool;
            statsThreadPool.setStatistic(null);
            this.threadPoolStat.setThreadPool(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAlgorithm() {
        try {
            this.algorithmClass = this.classLoader == null ? Class.forName(this.algorithmClassName) : this.classLoader.loadClass(this.algorithmClassName);
            logger.log(Level.FINE, "Using Algorithm: " + this.algorithmClassName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "Unable to load Algorithm: " + this.algorithmClassName);
        }
        finally {
            if (this.algorithmClass == null) {
                this.algorithmClass = NoParsingAlgorithm.class;
            }
        }
        defaultAlgorithmInstalled = this.algorithmClassName.equals(DEFAULT_ALGORITHM);
    }

    public void initThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = this.newThreadPool(4096, "http", this.port, 10);
        } else {
            if (this.threadPool instanceof StatsThreadPool) {
                StatsThreadPool statsThreadPool = (StatsThreadPool)this.threadPool;
                statsThreadPool.setPort(this.port);
                statsThreadPool.setPriority(10);
            }
            if (this.threadPool instanceof ExtendedThreadPool) {
                ExtendedThreadPool extThreadPool = (ExtendedThreadPool)this.threadPool;
                extThreadPool.setCorePoolSize(this.coreThreads);
                extThreadPool.setMaximumPoolSize(this.maxThreads);
            }
        }
        if (this.isMonitoringEnabled) {
            this.enableThreadPoolStats();
        }
    }

    protected void initProcessorTask(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.offer(this.newProcessorTask(false));
        }
    }

    protected void rampUpProcessorTask() {
        for (ProcessorTask processorTask : this.processorTasks) {
            processorTask.initialize();
        }
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        ProcessorTaskFactory factoryLocal = this.processorTaskFactory;
        ProcessorTask task = factoryLocal != null ? factoryLocal.createProcessorTask(this, initialize) : new ProcessorTask(initialize, this.bufferResponse);
        return this.configureProcessorTask(task);
    }

    protected ProcessorTask configureProcessorTask(ProcessorTask task) {
        task.setAdapter(this.adapter);
        task.setMaxHttpHeaderSize(this.maxHttpHeaderSize);
        task.setBufferSize(this.requestBufferSize);
        task.setSelectorThread(this);
        task.setDefaultResponseType(this.defaultResponseType);
        task.setForcedRequestType(this.forcedRequestType);
        task.setMaxPostSize(this.maxPostSize);
        task.setTimeout(this.uploadTimeout);
        task.setDisableUploadTimeout(this.disableUploadTimeout);
        task.setAsyncHttpWriteEnabled(this.isAsyncHttpWriteEnabled);
        task.setTransactionTimeout(this.transactionTimeout);
        task.setUseChunking(this.useChunking);
        task.setSendBufferSize(this.sendBufferSize);
        if (this.asyncExecution) {
            task.setEnableAsyncExecution(this.asyncExecution);
            task.setAsyncHandler(this.asyncHandler);
        }
        task.setThreadPool(this.threadPool);
        this.configureCompression(task);
        return task;
    }

    protected void reconfigureAsyncExecution() {
        for (ProcessorTask task : this.processorTasks) {
            task.setEnableAsyncExecution(this.asyncExecution);
            task.setAsyncHandler(this.asyncHandler);
        }
    }

    protected void reconfigureAdapter() {
        for (ProcessorTask task : this.processorTasks) {
            task.setAdapter(this.adapter);
        }
    }

    public ProcessorTask getProcessorTask() {
        ProcessorTask processorTask = this.processorTasks.poll();
        if (processorTask == null) {
            processorTask = this.newProcessorTask(false);
        }
        if (this.isMonitoringEnabled()) {
            this.activeProcessorTasks.offer(processorTask);
        }
        return processorTask;
    }

    public void start() {
        if (this.port == 0) {
            selectorThreads.put(SelectorThread.getSelectorThreadLookupKey(this.inet, this.port), this);
        }
        new WorkerThreadImpl("SelectorThread-" + this.port, (Runnable)this).start();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.running.set(true);
                this.rampUpProcessorTask();
                this.registerComponents();
                this.displayConfiguration();
                this.startListener();
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, LogMessages.SEVERE_GRIZZLY_HTTP_SELECTOR_THREAD_HTTP_PROCESSING_ERROR(), ex);
            }
        }
    }

    public void initEndpoint() throws IOException, InstantiationException {
        SelectorThreadConfig.configure(this);
        this.configureProperties();
        this.initAlgorithm();
        this.initThreadPool();
        this.initController();
        this.initFileCacheFactory();
        this.initMonitoringLevel();
        int maxPoolSize = StatsThreadPool.DEFAULT_MAX_THREAD_COUNT;
        if (this.threadPool instanceof ExtendedThreadPool) {
            maxPoolSize = ((ExtendedThreadPool)this.threadPool).getMaximumPoolSize();
        }
        this.initProcessorTask(maxPoolSize);
        if (SelectorFactory.getMaxSelectors() < maxPoolSize) {
            SelectorFactory.setMaxSelectors(maxPoolSize);
        }
        if (this.port != 0) {
            selectorThreads.put(SelectorThread.getSelectorThreadLookupKey(this.inet, this.port), this);
        }
        this.initialized = true;
        if (this.adapter instanceof GrizzlyAdapter) {
            ((GrizzlyAdapter)this.adapter).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpoint() {
        block7: {
            if (!this.running.getAndSet(false)) {
                return;
            }
            try {
                this.controller.stop();
            }
            catch (IOException ex) {
                if (!logger.isLoggable(Level.WARNING)) break block7;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_STOP(), ex);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.clearTasks();
        }
        if (this.adapter instanceof GrizzlyAdapter) {
            ((GrizzlyAdapter)this.adapter).destroy();
        }
    }

    private void configureProperties() {
        for (String name : this.properties.keySet()) {
            String value = this.properties.get(name).toString();
            IntrospectionUtils.setProperty(this, name, value);
        }
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.run();
    }

    @Override
    public void listen() throws IOException, InstantiationException {
        this.initEndpoint();
        final FutureImpl future = new FutureImpl();
        this.controller.addStateListener(new ControllerStateListenerAdapter(){

            public void onReady() {
                future.setResult(Boolean.TRUE);
            }

            public void onException(Throwable e) {
                if (!future.isDone()) {
                    SelectorThread.logger().log(Level.SEVERE, "Exception during starting the controller", e);
                    future.setException(e);
                } else {
                    SelectorThread.logger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        });
        this.start();
        try {
            future.get();
        }
        catch (InterruptedException ignored) {
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.getClass().getName() + ": " + cause.getMessage());
        }
        if (!this.controller.isStarted()) {
            throw new IllegalStateException("Controller is not started!");
        }
    }

    protected void startThreadPool() {
    }

    protected void stopThreadPool() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startListener() {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                try {
                    this.controller.start();
                    this.stopThreadPool();
                    this.unregisterComponents();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.SEVERE)) break block5;
                    logger.log(Level.SEVERE, LogMessages.SEVERE_GRIZZLY_HTTP_SELECTOR_THREAD_CONTROLLER_START_ERROR(), t);
                }
            }
        }
    }

    public void cancelKey(SelectionKey key) {
        this.selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    public void returnTask(Task task) {
        if (task != null && task.getType() == 2) {
            if (this.isMonitoringEnabled()) {
                this.activeProcessorTasks.remove(task);
            }
            this.processorTasks.offer((ProcessorTask)task);
        }
    }

    protected void clearTasks() {
        this.processorTasks.clear();
    }

    public int getPortLowLevel() {
        if (this.selectorHandler != null) {
            return this.selectorHandler.getPort();
        }
        return this.port;
    }

    public int getPort() {
        return this.getPortLowLevel();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int i) {
        this.linger = i;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public InetAddress getInet() {
        return this.inet;
    }

    public void setInet(InetAddress inet) {
        this.inet = inet;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getMaxKeepAliveRequests() {
        return this.keepAliveStats.getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.keepAliveStats.setMaxKeepAliveRequests(maxKeepAliveRequests);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveStats.setKeepAliveTimeoutInSeconds(timeout);
        if (this.keyHandler != null) {
            this.keyHandler.setTimeout(timeout == -1 ? Long.MIN_VALUE : (long)timeout * 1000L);
        }
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveStats.getKeepAliveTimeoutInSeconds();
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
        this.reconfigureAdapter();
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void setSocketOptions(Socket socket) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        try {
                            if (this.linger >= 0) {
                                socket.setSoLinger(true, this.linger);
                            }
                        }
                        catch (SocketException ex) {
                            if (!logger.isLoggable(Level.WARNING)) break block11;
                            logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_SOCKET_OPTION_ERROR("setSoLinger"), ex);
                        }
                    }
                    try {
                        if (this.tcpNoDelay) {
                            socket.setTcpNoDelay(this.tcpNoDelay);
                        }
                    }
                    catch (SocketException ex) {
                        if (!logger.isLoggable(Level.WARNING)) break block12;
                        logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_SOCKET_OPTION_ERROR("setTcpNoDelay"), ex);
                    }
                }
                try {
                    socket.setReuseAddress(this.reuseAddress);
                }
                catch (SocketException ex) {
                    if (!logger.isLoggable(Level.WARNING)) break block13;
                    logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_SOCKET_OPTION_ERROR("setReuseAddress"), ex);
                }
            }
            try {
                if (this.oOBInline) {
                    socket.setOOBInline(this.oOBInline);
                }
            }
            catch (SocketException ex) {
                if (!logger.isLoggable(Level.WARNING)) break block14;
                logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_SOCKET_OPTION_ERROR("setOOBInline"), ex);
            }
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void registerComponents() {
        block3: {
            if (this.domain != null && this.jmxManagement != null) {
                try {
                    this.globalRequestProcessorName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=GrizzlyHttpEngine-" + this.port);
                    this.jmxManagement.registerComponent(this.globalRequestProcessor, this.globalRequestProcessorName, null);
                    this.keepAliveMbeanName = new ObjectName(this.domain + ":type=KeepAlive,name=GrizzlyHttpEngine-" + this.port);
                    this.jmxManagement.registerComponent(this.keepAliveStats, this.keepAliveMbeanName, null);
                    this.connectionQueueMbeanName = new ObjectName(this.domain + ":type=ConnectionQueue,name=GrizzlyHttpEngine-" + this.port);
                    this.jmxManagement.registerComponent(this.threadPoolStat, this.connectionQueueMbeanName, null);
                    this.fileCacheMbeanName = new ObjectName(this.domain + ":type=FileCache,name=GrizzlyHttpEngine-" + this.port);
                    this.jmxManagement.registerComponent(this.fileCacheFactory, this.fileCacheMbeanName, null);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_MBEAN_REGISTRATION_ERROR(this.port), ex);
                }
            }
        }
    }

    protected void unregisterComponents() {
        if (this.domain != null && this.jmxManagement != null) {
            ProcessorTask pt2;
            block9: {
                try {
                    if (this.globalRequestProcessorName != null) {
                        this.jmxManagement.unregisterComponent(this.globalRequestProcessorName);
                    }
                    if (this.keepAliveMbeanName != null) {
                        this.jmxManagement.unregisterComponent(this.keepAliveMbeanName);
                    }
                    if (this.connectionQueueMbeanName != null) {
                        this.jmxManagement.unregisterComponent(this.connectionQueueMbeanName);
                    }
                    if (this.fileCacheMbeanName != null) {
                        this.jmxManagement.unregisterComponent(this.fileCacheMbeanName);
                    }
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.WARNING)) break block9;
                    logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_MBEAN_DEREGISTRATION_ERROR(this.port), ex);
                }
            }
            for (ProcessorTask pt2 : this.activeProcessorTasks) {
                if (!(pt2 instanceof ProcessorTask)) continue;
                pt2.unregisterMonitoring();
            }
            Iterator iterator = this.processorTasks.iterator();
            pt2 = null;
            while (iterator.hasNext()) {
                pt2 = (ProcessorTask)iterator.next();
                if (!(pt2 instanceof ProcessorTask)) continue;
                pt2.unregisterMonitoring();
            }
        }
    }

    public Management getManagement() {
        return this.jmxManagement;
    }

    public void setManagement(Management jmxManagement) {
        this.jmxManagement = jmxManagement;
    }

    public void enableMonitoring() {
        if (this.threadPoolStat == null) {
            this.initThreadPool();
            this.initMonitoringLevel();
            this.initFileCacheFactory();
        }
        this.isMonitoringEnabled = true;
        this.enableThreadPoolStats();
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public void disableMonitoring() {
        this.disableThreadPoolStats();
        this.isMonitoringEnabled = false;
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }

    public boolean isMonitoringEnabled() {
        return this.isMonitoringEnabled;
    }

    public RequestGroupInfo getRequestGroupInfo() {
        return this.globalRequestProcessor;
    }

    public KeepAliveStats getKeepAliveStats() {
        return this.keepAliveStats;
    }

    protected void initMonitoringLevel() {
        if (this.threadPoolStat != null) {
            return;
        }
        this.threadPoolStat = new ThreadPoolStatistic(this.port);
        int maxQueuedTasks = -1;
        if (this.threadPool instanceof ExtendedThreadPool) {
            maxQueuedTasks = ((ExtendedThreadPool)this.threadPool).getMaxQueuedTasksCount();
        }
        this.threadPoolStat.setQueueSizeInBytes(maxQueuedTasks);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public boolean isAsyncHttpWriteEnabled() {
        return this.isAsyncHttpWriteEnabled;
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.isAsyncHttpWriteEnabled = isAsyncHttpWriteEnabled;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    public Selector getSelector() {
        if (this.selector != null) {
            return this.selector;
        }
        return this.selectorHandler.getSelector();
    }

    public TCPSelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void removeCacheEntry(String contextPath) {
        Map<String, FileCache.FileCacheEntry> cachedEntries = this.fileCacheFactory.getCache();
        if (cachedEntries == null) {
            return;
        }
        for (String cachedPath : cachedEntries.keySet()) {
            if (!cachedPath.startsWith(contextPath)) continue;
            cachedEntries.remove(cachedPath).run();
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.isFileCacheEnabled;
    }

    public void setFileCacheIsEnabled(boolean isFileCacheEnabled) {
        this.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setEnableAsyncExecution(boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        if (this.running.get()) {
            this.reconfigureAsyncExecution();
        }
    }

    public boolean getEnableAsyncExecution() {
        return this.asyncExecution;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public static void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public static Logger logger() {
        return logger;
    }

    public void setWebAppRootPath(String rf) {
        this.rootFolder = rf;
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    private void displayConfiguration() {
        if (this.displayConfiguration) {
            logger.log(Level.INFO, LogMessages.INFO_GRIZZLY_HTTP_SELECTOR_THREAD_CONFIG(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("java.version"), System.getProperty("java.vendor"), Integer.toString(this.getPort()), this.threadPool, Integer.toString(this.readThreadsCount), Integer.toString(this.requestBufferSize), Integer.toString(this.requestBufferSize), Integer.toString(this.sendBufferSize), this.keepAliveStats.getMaxKeepAliveRequests(), this.keepAliveStats.getKeepAliveTimeoutInSeconds(), Boolean.toString(this.isFileCacheEnabled), new File(this.rootFolder).getAbsolutePath(), this.adapter == null ? null : this.adapter.getClass().getName(), Boolean.toString(this.asyncExecution)));
        }
    }

    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    public void setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
    }

    public void enableRcmSupport(boolean rcmSupport) {
        this.rcmSupport = rcmSupport;
    }

    public boolean isRcmSupported() {
        return this.rcmSupport;
    }

    protected void configureCompression(ProcessorTask processorTask) {
        processorTask.addNoCompressionUserAgent(this.noCompressionUserAgents);
        this.parseComressableMimeTypes();
        processorTask.setCompressableMimeTypes(this.parsedCompressableMimeTypes);
        processorTask.setCompressionMinSize(this.compressionMinSize);
        processorTask.setCompression(this.compression);
        processorTask.addRestrictedUserAgent(this.restrictedUserAgents);
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public String getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    private static int getSelectorThreadLookupKey(InetAddress address, int port) {
        int addressHash = address != null ? address.hashCode() : 0;
        return addressHash + port;
    }

    private void parseComressableMimeTypes() {
        if (this.compressableMimeTypes == null) {
            this.parsedCompressableMimeTypes = new String[0];
            return;
        }
        int hash = -1;
        hash = this.compressableMimeTypes.hashCode();
        if (hash == this.parsedComressableMimeTypesHash) {
            return;
        }
        ArrayList<String> compressableMimeTypeList = new ArrayList<String>(4);
        StringTokenizer st = new StringTokenizer(this.compressableMimeTypes, ",");
        while (st.hasMoreTokens()) {
            compressableMimeTypeList.add(st.nextToken().trim());
        }
        String[] tmpParsedCompressableMimeTypes = new String[compressableMimeTypeList.size()];
        compressableMimeTypeList.toArray(tmpParsedCompressableMimeTypes);
        this.parsedCompressableMimeTypes = tmpParsedCompressableMimeTypes;
        this.parsedComressableMimeTypesHash = hash;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public int getSelectorReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setSelectorReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        if (threadPool == null) {
            throw new IllegalStateException("Cannot be null");
        }
        ThreadFactory threadFactory = this.getThreadFactory(threadPool);
        if (threadFactory != null) {
            if (!(threadFactory.newThread(new Runnable(){

                public void run() {
                }
            }) instanceof HttpWorkerThread)) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe(LogMessages.SEVERE_GRIZZLY_HTTP_SELECTOR_THREAD_INVALID_THREAD_FACTORY_ERROR(HttpWorkerThread.class.getName()));
                }
                throw new RuntimeException("Invalid ThreadFactory. Threads must be instance of " + HttpWorkerThread.class.getName());
            }
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning(LogMessages.WARNING_GRIZZLY_HTTP_SELECTOR_THREAD_UNKNOWN_THREAD_FACTORY_ERROR(HttpWorkerThread.class.getName()));
        }
        this.threadPool = threadPool;
    }

    private ThreadFactory getThreadFactory(ExecutorService threadPool) {
        if (threadPool instanceof ExtendedThreadPool) {
            return ((ExtendedThreadPool)threadPool).getThreadFactory();
        }
        if (threadPool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)threadPool).getThreadFactory();
        }
        return null;
    }

    public boolean isUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    public boolean isUseByteBufferView() {
        return this.useByteBufferView;
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.useByteBufferView = useByteBufferView;
    }

    public int getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public void setSelectorTimeout(int aSelectorTimeout) {
        this.selectorTimeout = aSelectorTimeout;
    }

    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }

    public void setAlgorithmClassName(String algorithmClassName) {
        this.algorithmClassName = algorithmClassName;
    }

    public int getSsBackLog() {
        return this.ssBackLog;
    }

    public void setSsBackLog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void setForcedRequestType(String forcedRequestType) {
        this.forcedRequestType = forcedRequestType;
    }

    public Queue<ProcessorTask> getActiveProcessorTasks() {
        return this.activeProcessorTasks;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static boolean isEnableNioLogging() {
        return enableNioLogging;
    }

    public static void setEnableNioLogging(boolean enl) {
        enableNioLogging = enl;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public SelectorThreadKeyHandler getSelectorThreadKeyHandler() {
        return this.keyHandler;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setUploadTimeout(int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
    }

    public int getUploadTimeout() {
        return this.uploadTimeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public String getThreadPoolClassname() {
        return this.threadPoolClassname;
    }

    public void setThreadPoolClassname(String threadPoolClassname) {
        this.threadPoolClassname = threadPoolClassname;
    }

    @Override
    public String protocol() {
        return "HTTP";
    }

    public void setForceKeepAlive(boolean forceKeepAlive) {
        this.forceKeepAlive = forceKeepAlive;
    }

    public boolean getForceKeepAlive() {
        return this.forceKeepAlive;
    }

    public void addAsyncEnabledContextPath(String s) {
        if (this.asyncInterceptor == null) {
            this.asyncInterceptor = new AsyncInterceptor();
        }
        this.asyncInterceptor.addContextPath(s);
    }

    protected KeepAliveStats createKeepAliveStats() {
        return new KeepAliveStats();
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public ProcessorTaskFactory getProcessorTaskFactory() {
        return this.processorTaskFactory;
    }

    public void setProcessorTaskFactory(ProcessorTaskFactory processorTaskFactory) {
        this.processorTaskFactory = processorTaskFactory;
        this.clearTasks();
    }
}

