/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.Constants;
import com.sun.grizzly.tcp.http11.GrizzlyInputBuffer;
import com.sun.grizzly.tcp.http11.GrizzlyInputStream;
import com.sun.grizzly.tcp.http11.GrizzlyReader;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.GrizzlySession;
import com.sun.grizzly.util.buf.B2CConverter;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.Cookie;
import com.sun.grizzly.util.http.Cookies;
import com.sun.grizzly.util.http.Enumerator;
import com.sun.grizzly.util.http.FastHttpDateFormat;
import com.sun.grizzly.util.http.ParameterMap;
import com.sun.grizzly.util.http.Parameters;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.grizzly.util.http.StringParser;
import com.sun.grizzly.util.res.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyRequest {
    private static final Random random = new Random();
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    private GrizzlySession session;
    private static Map<String, GrizzlySession> sessions = new ConcurrentHashMap<String, GrizzlySession>();
    private static final ScheduledThreadPoolExecutor sessionExpirer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new SchedulerThread(r, "Grizzly");
        }
    });
    protected Request request;
    protected static StringManager sm;
    protected Cookie[] cookies = null;
    private static ThreadLocal staticDateFormats;
    protected SimpleDateFormat[] formats;
    protected static Locale defaultLocale;
    protected HashMap<String, Object> attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected String authType = null;
    protected Object dispatcherType = null;
    protected GrizzlyInputBuffer inputBuffer = new GrizzlyInputBuffer();
    protected GrizzlyInputStream inputStream = new GrizzlyInputStream(this.inputBuffer);
    protected GrizzlyReader reader = new GrizzlyReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static int CACHED_POST_LEN;
    protected byte[] postData = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localName = null;
    protected String localAddr = null;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth;
    private String jrouteId;
    protected GrizzlyResponse response = null;
    protected B2CConverter URIConverter = null;

    public GrizzlyRequest() {
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setRequest(Request request) {
        this.request = request;
        this.inputBuffer.setRequest(request);
    }

    public Request getRequest() {
        return this.request;
    }

    public GrizzlyResponse getResponse() {
        return this.response;
    }

    public void setResponse(GrizzlyResponse response) {
        this.response = response;
    }

    public void recycle() {
        this.dispatcherType = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.requestParametersParsed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.cookies = null;
        this.requestedSessionId = null;
        this.session = null;
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        if (System.getSecurityManager() != null) {
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
    }

    public String getAuthorization() {
        return this.request.getHeader("authorization");
    }

    public void setAuthorization(String authorization) {
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void setStream(InputStream stream) {
    }

    public B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    public void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public GrizzlyInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String type2) {
    }

    public void setProtocol(String protocol) {
    }

    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    public void setScheme(String scheme) {
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.request.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.request.setServerPort(port);
    }

    public Object getAttribute(String name) {
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.request.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            this.request.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        } else if (GrizzlyRequest.isSSLAttribute(name)) {
            this.request.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, this.request);
            attr = this.request.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", attr);
            }
            if ((attr = this.request.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", attr);
            }
            if ((attr = this.request.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", attr);
            }
            attr = this.attributes.get(name);
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public GrizzlyInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("request.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new GrizzlyInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.request.getParameters().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.request.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.request.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.request.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("request.getReader.ise"));
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new GrizzlyReader(this.inputBuffer);
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.request.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, this.request);
                this.remoteAddr = this.request.remoteAddr().toString();
            }
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.request.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, this.request);
                this.remoteHost = this.request.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            if (this.socket != null) {
                this.remotePort = this.socket.getPort();
            } else {
                this.request.action(ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE, this.request);
                this.remotePort = this.request.getRemotePort();
            }
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.request.action(ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE, this.request);
                this.localName = this.request.localName().toString();
            }
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.request.action(ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE, this.request);
                this.localAddr = this.request.localAddr().toString();
            }
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            if (this.socket != null) {
                this.localPort = this.socket.getLocalPort();
            } else {
                this.request.action(ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE, this.request);
                this.localPort = this.request.getLocalPort();
            }
        }
        return this.localPort;
    }

    public String getScheme() {
        String scheme = this.request.scheme().toString();
        if (scheme == null) {
            scheme = "http";
        }
        return scheme;
    }

    public String getServerName() {
        return this.request.serverName().toString();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        GrizzlySession localSession = sessions.put(this.requestedSessionId, this.session);
        return localSession != null && localSession.isValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        found = this.attributes.containsKey(name);
        if (found) {
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("request.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("grizzly.")) {
            this.request.setAttribute(name, value);
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.requestParametersParsed || this.usingReader) {
            return;
        }
        byte[] buffer = new byte[]{97};
        final byte[] finalBuffer = buffer;
        final String finalEnc = enc;
        String dummy = null;
        if (System.getSecurityManager() != null) {
            try {
                dummy = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnsupportedEncodingException {
                        return new String(finalBuffer, finalEnc);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (UnsupportedEncodingException)pae.getCause();
            }
        } else {
            dummy = new String(buffer, enc);
        }
        this.request.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (cookie != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        System.arraycopy(this.cookies, 0, newCookies, 0, size);
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addHeader(String name, String value) {
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.request.getParameters().addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type2) {
        this.authType = type2;
    }

    public void setMethod(String method) {
    }

    public void setQueryString(String query) {
    }

    public void setRequestURI(String uri) {
    }

    public void setDecodedRequestURI(String uri) {
    }

    public String getDecodedRequestURI() {
        return this.request.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.request.decodedURI();
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getMimeHeaders().values(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.request.method().toString();
    }

    public String getQueryString() {
        String queryString = this.request.queryString().toString();
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        return queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.request.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuilder url = new StringBuilder();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return new StringBuffer(url);
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null && this.getRequest().scheme().equals("https")) {
            X509Certificate[] certs = (X509Certificate[])this.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length < 1) {
                certs = (X509Certificate[])this.getAttribute("org.apache.coyote.request.X509Certificate");
            }
            this.userPrincipal = certs == null || certs.length < 1 ? null : certs[0].getSubjectX500Principal();
        }
        return this.userPrincipal;
    }

    protected String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s.length()) {
                throw new IllegalArgumentException();
            }
            c = s.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.request.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), null);
                int version = scookie.getVersion();
                cookie.setVersion(version);
                cookie.setValue(this.unescape(scookie.getValue().toString()));
                cookie.setPath(this.unescape(scookie.getPath().toString()));
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(this.unescape(domain));
                }
                String comment = scookie.getComment().toString();
                cookie.setComment(version == 1 ? this.unescape(comment) : null);
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    protected void parseRequestParameters() {
        int semicolon;
        Parameters parameters = this.request.getParameters();
        String enc = this.getCharacterEncoding();
        this.requestParametersParsed = true;
        if (enc != null) {
            parameters.setEncoding(enc);
            parameters.setQueryStringEncoding(enc);
        } else {
            parameters.setEncoding("ISO-8859-1");
            parameters.setQueryStringEncoding("ISO-8859-1");
        }
        parameters.handleQueryParameters();
        if (this.inputBuffer.state != this.inputBuffer.INITIAL_STATE) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            try {
                byte[] formData = this.getPostBody();
                if (formData != null) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < CACHED_POST_LEN) {
            if (this.postData == null) {
                this.postData = new byte[CACHED_POST_LEN];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (Object o : locales.keySet()) {
            Double key = (Double)o;
            ArrayList list = (ArrayList)locales.get(key);
            for (Object aList : list) {
                Locale locale = (Locale)aList;
                this.addLocale(locale);
            }
        }
    }

    void parseJrouteCookie() {
        Cookies serverCookies = this.request.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (!scookie.getName().equals("JROUTE")) continue;
            this.setJrouteId(scookie.getValue().toString());
            break;
        }
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    public String getJrouteId() {
        return this.jrouteId;
    }

    public GrizzlySession getSession() {
        return this.doGetSession(true);
    }

    public GrizzlySession getSession(boolean create) {
        return this.doGetSession(create);
    }

    protected GrizzlySession doGetSession(boolean create) {
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        if (this.requestedSessionId != null) {
            this.session = sessions.get(this.requestedSessionId);
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
                sessions.remove(this.requestedSessionId);
            }
            if (this.session != null) {
                return this.session;
            }
            this.requestedSessionId = null;
        }
        if (!create) {
            return null;
        }
        if (this.requestedSessionId != null) {
            this.session = new GrizzlySession(this.requestedSessionId);
        } else {
            this.requestedSessionId = String.valueOf(Math.abs(random.nextLong()));
            this.session = new GrizzlySession(this.requestedSessionId);
        }
        sessions.put(this.requestedSessionId, this.session);
        if (this.session != null) {
            Cookie cookie = new Cookie("JSESSIONID", this.session.getIdInternal());
            this.configureSessionCookie(cookie);
            this.response.addCookie(cookie);
        }
        if (this.session != null) {
            return this.session;
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setMaxAge(-1);
        Object contextPath = null;
        cookie.setPath("/");
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
    }

    protected Cookie makeCookie(ServerCookie scookie) {
        return this.makeCookie(scookie, false);
    }

    protected Cookie makeCookie(ServerCookie scookie, boolean decode) {
        String name = scookie.getName().toString();
        String value = scookie.getValue().toString();
        if (decode) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name = URLDecoder.decode(name);
                value = URLDecoder.decode(value);
            }
        }
        return new Cookie(name, value);
    }

    protected void parseSessionId() {
        ByteChunk uriBC = this.request.requestURI().getByteChunk();
        int semicolon = uriBC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            int start = uriBC.getStart();
            int end = uriBC.getEnd();
            int sessionIdStart = start + semicolon + match.length();
            int semicolon2 = uriBC.indexOf(';', sessionIdStart);
            String sessionId = null;
            sessionId = semicolon2 >= 0 ? new String(uriBC.getBuffer(), sessionIdStart, semicolon2 - semicolon - match.length()) : new String(uriBC.getBuffer(), sessionIdStart, end - sessionIdStart);
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            if (!this.request.requestURI().getByteChunk().isNull()) {
                this.parseSessionIdFromRequestURI();
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
    }

    protected void parseSessionIdFromRequestURI() {
        MessageBytes requestURI = this.request.requestURI();
        ByteChunk uriBC = requestURI.getByteChunk();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        int semicolon = uriBC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            int sessionIdStart = start + semicolon;
            int semicolon2 = uriBC.indexOf(';', semicolon + match.length());
            byte[] buf = uriBC.getBuffer();
            if (semicolon2 >= 0) {
                System.arraycopy(buf, start + semicolon2, buf, sessionIdStart, end - start - semicolon2);
                requestURI.setBytes(buf, start, semicolon + (end - start - semicolon2));
            } else {
                requestURI.setBytes(buf, start, semicolon);
            }
        }
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    static {
        sessionExpirer.scheduleAtFixedRate(new Runnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                Iterator iterator = sessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((GrizzlySession)entry.getValue()).getSessionTimeout() == -1L || currentTime - ((GrizzlySession)entry.getValue()).getTimestamp() <= ((GrizzlySession)entry.getValue()).getSessionTimeout()) continue;
                    ((GrizzlySession)entry.getValue()).setIsValid(false);
                    iterator.remove();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        sm = StringManager.getManager("com.sun.grizzly.tcp.http11", Constants.class.getClassLoader());
        staticDateFormats = new ThreadLocal(){

            protected Object initialValue() {
                SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
                return f;
            }
        };
        defaultLocale = Locale.getDefault();
        CACHED_POST_LEN = 8192;
        maxDispatchDepth = 20;
    }

    private static class SchedulerThread
    extends Thread {
        public SchedulerThread(Runnable r, String name) {
            super(r, name);
            this.setDaemon(true);
        }
    }
}

