/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantFileBasedParser;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.KeyValuePairParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jvnet.hk2.annotations.CagedBy;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Index;
import org.jvnet.hk2.annotations.InhabitantAnnotation;
import org.jvnet.hk2.annotations.InhabitantMetadata;
import org.jvnet.hk2.component.CageBuilder;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

@Contract
@InhabitantAnnotation(value="default")
@CagedBy(value=Registerer.class)
public @interface CompanionSeed {
    @Index
    @InhabitantMetadata(value="lead")
    public Class<?> lead();

    @InhabitantMetadata(value="companionClass")
    public Class<?> companion();

    public static final class Registerer<T>
    implements CageBuilder<T> {
        private final Habitat habitat;

        public Registerer(Habitat habitat) {
            this.habitat = habitat;
        }

        @Override
        public void onEntered(Inhabitant<T> i) {
            assert (i.metadata() != null);
            for (Inhabitant<?> lead : this.habitat.getInhabitantsByType(i.metadata().getOne("lead"))) {
                lead.setCompanions(this.cons(lead.companions(), Registerer.createCompanion(this.habitat, lead, i)));
            }
        }

        private <T> List<T> cons(Collection<T> list, T oneMore) {
            int sz = list.size();
            Object[] a = list.toArray(new Object[sz + 1]);
            a[sz] = oneMore;
            return Arrays.asList(a);
        }

        public static Inhabitant<?> createCompanion(Habitat habitat, Inhabitant<?> lead, final Inhabitant<?> seed) {
            Holder<ClassLoader> cl = new Holder<ClassLoader>(){

                @Override
                public ClassLoader get() {
                    return seed.type().getClassLoader();
                }
            };
            String fqcn = seed.metadata().getOne("companionClass");
            String metadataLine = seed.metadata().getOne("companionClassMetadata");
            MultiMap<Object, Object> metadata = metadataLine == null ? MultiMap.emptyMap() : InhabitantFileBasedParser.buildMetadata(new KeyValuePairParser(metadataLine));
            Inhabitant<?> ci = Inhabitants.createInhabitant(habitat, cl, fqcn, metadata, lead, null);
            habitat.add(ci);
            return ci;
        }
    }
}

