/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.Inhabitants;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

public class InhabitantsParser {
    private final Logger logger = Logger.getLogger(InhabitantsParser.class.getCanonicalName());
    public final Habitat habitat;
    private final Map<String, Class<?>> replacements = new HashMap();

    public InhabitantsParser(Habitat habitat) {
        this.habitat = habitat;
    }

    public void drop(Class<?> component) {
        this.drop(component.getName());
    }

    public void drop(String fullyQualifiedClassName) {
        this.replace(fullyQualifiedClassName, null);
    }

    public void replace(Class<?> oldComponent, Class<?> newComponent) {
        this.replace(oldComponent.getName(), newComponent);
    }

    public void replace(String oldComponentFullyQualifiedClassName, Class<?> newComponent) {
        this.replacements.put(oldComponentFullyQualifiedClassName, newComponent);
    }

    public void parse(Iterable<InhabitantParser> scanner, Holder<ClassLoader> classLoader) throws IOException {
        if (scanner == null) {
            return;
        }
        for (InhabitantParser inhabitantParser : scanner) {
            String typeName;
            if (this.isFilteredInhabitant(inhabitantParser) || this.isFilteredInhabitant(typeName = inhabitantParser.getImplName())) continue;
            if (this.replacements.containsKey(typeName)) {
                Class<?> target = this.replacements.get(typeName);
                if (target == null) continue;
                inhabitantParser.setImplName(target.getName());
                Inhabitant<?> i = null;
                try {
                    i = Inhabitants.create(target, this.habitat, inhabitantParser.getMetaData());
                }
                catch (Exception e) {
                    this.log(typeName, e);
                }
                if (null == i) continue;
                this.add(i, inhabitantParser);
                this.addIndex(i, typeName, null);
                continue;
            }
            HashSet<String> indicies = new HashSet<String>();
            Iterator<String> iter = inhabitantParser.getIndexes().iterator();
            while (iter.hasNext()) {
                indicies.add(iter.next());
            }
            Inhabitant<?> i = null;
            try {
                i = Inhabitants.createInhabitant(this.habitat, classLoader, typeName, inhabitantParser.getMetaData(), null, Collections.unmodifiableSet(indicies));
            }
            catch (Exception e) {
                this.log(typeName, e);
            }
            if (null == i) continue;
            this.add(i, inhabitantParser);
        }
    }

    private void log(String typeName, Exception e) {
        this.logger.log(Level.FINE, "Warning: unable to create inhabitant for {0} - and therefore ignoring it; check classpath; re: {1}", new Object[]{typeName, e.getMessage()});
        this.logger.log(Level.FINER, "", e);
    }

    protected boolean isFilteredInhabitant(InhabitantParser inhabitantParser) {
        return false;
    }

    protected boolean isFilteredInhabitant(String typeName) {
        return false;
    }

    protected void add(Inhabitant<?> i, InhabitantParser parser) {
        this.add(i);
        for (String v : parser.getIndexes()) {
            int idx = v.indexOf(58);
            if (idx == -1) {
                this.addIndex(i, v, null);
                continue;
            }
            String contract = v.substring(0, idx);
            String name = v.substring(idx + 1);
            this.addIndex(i, contract, name);
        }
    }

    protected void add(Inhabitant<?> i) {
        this.logger.log(Level.FINE, "adding inhabitant: {0} to habitat {1}", new Object[]{i, this.habitat});
        this.habitat.add(i);
    }

    protected void addIndex(Inhabitant<?> i, String typeName, String name) {
        this.logger.log(Level.FINE, "adding index for inhabitant: {0} with typeName {1} and name {2} to habitat {3}", new Object[]{i, typeName, name, this.habitat});
        this.habitat.addIndex(i, typeName, name);
    }
}

