/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.servlet;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.AuthContextHelper;
import com.sun.jaspic.config.jaas.JAASAuthConfigProvider;
import java.util.Map;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JAASServletAuthConfigProvider
extends JAASAuthConfigProvider {
    private static final String HTTP_SERVLET_LAYER = "HttpServlet";
    private static final String MANDATORY_KEY = "javax.security.auth.message.MessagePolicy.isMandatory";
    private static final String MANDATORY_AUTH_CONTEXT_ID = "mandatory";
    private static final String OPTIONAL_AUTH_CONTEXT_ID = "optional";
    private static final Class[] moduleTypes = new Class[]{ServerAuthModule.class};
    private static final Class[] messageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    static final MessagePolicy mandatoryPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, new MessagePolicy.ProtectionPolicy(){

        public String getID() {
            return "#authenticateSender";
        }
    })}, true);
    static final MessagePolicy optionalPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, new MessagePolicy.ProtectionPolicy(){

        public String getID() {
            return "#authenticateSender";
        }
    })}, false);

    public JAASServletAuthConfigProvider(Map properties, AuthConfigFactory factory) {
        super(properties, factory);
    }

    public MessagePolicyDelegate getMessagePolicyDelegate(String appContext) throws AuthException {
        return new MessagePolicyDelegate(){

            public MessagePolicy getRequestPolicy(String authContextID, Map properties) {
                MessagePolicy rvalue = JAASServletAuthConfigProvider.MANDATORY_AUTH_CONTEXT_ID.equals(authContextID) ? mandatoryPolicy : optionalPolicy;
                return rvalue;
            }

            public MessagePolicy getResponsePolicy(String authContextID, Map properties) {
                return null;
            }

            public Class[] getMessageTypes() {
                return messageTypes;
            }

            public String getAuthContextID(MessageInfo messageInfo) {
                String rvalue = messageInfo.getMap().containsKey(JAASServletAuthConfigProvider.MANDATORY_KEY) ? JAASServletAuthConfigProvider.MANDATORY_AUTH_CONTEXT_ID : JAASServletAuthConfigProvider.OPTIONAL_AUTH_CONTEXT_ID;
                return rvalue;
            }

            public boolean isProtected() {
                return true;
            }
        };
    }

    protected Class[] getModuleTypes() {
        return moduleTypes;
    }

    protected String getLayer() {
        return HTTP_SERVLET_LAYER;
    }

    public AuthContextHelper getAuthContextHelper(String appContext, boolean returnNullContexts) throws AuthException {
        return super.getAuthContextHelper(appContext, false);
    }
}

