/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider.jaxb;

import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import com.sun.jersey.core.util.FeaturesAndProperties;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public abstract class AbstractJAXBProvider<T>
extends AbstractMessageReaderWriterProvider<T> {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final Providers ps;
    private final boolean fixedMediaType;
    private final ContextResolver<JAXBContext> mtContext;
    private final ContextResolver<Unmarshaller> mtUnmarshaller;
    private final ContextResolver<Marshaller> mtMarshaller;
    private boolean formattedOutput = false;
    private boolean xmlRootElementProcessing = false;

    public AbstractJAXBProvider(Providers ps) {
        this(ps, null);
    }

    public AbstractJAXBProvider(Providers ps, MediaType mt) {
        this.ps = ps;
        boolean bl = this.fixedMediaType = mt != null;
        if (this.fixedMediaType) {
            this.mtContext = ps.getContextResolver(JAXBContext.class, mt);
            this.mtUnmarshaller = ps.getContextResolver(Unmarshaller.class, mt);
            this.mtMarshaller = ps.getContextResolver(Marshaller.class, mt);
        } else {
            this.mtContext = null;
            this.mtUnmarshaller = null;
            this.mtMarshaller = null;
        }
    }

    @Context
    public void setConfiguration(FeaturesAndProperties fp) {
        this.formattedOutput = fp.getFeature("com.sun.jersey.config.feature.Formatted");
        this.xmlRootElementProcessing = fp.getFeature("com.sun.jersey.config.feature.XmlRootElementProcessing");
    }

    protected boolean isSupported(MediaType m) {
        return true;
    }

    protected final Unmarshaller getUnmarshaller(Class type2, MediaType mt) throws JAXBException {
        Unmarshaller u;
        if (this.fixedMediaType) {
            return this.getUnmarshaller(type2);
        }
        ContextResolver<Unmarshaller> uncr = this.ps.getContextResolver(Unmarshaller.class, mt);
        if (uncr != null && (u = uncr.getContext(type2)) != null) {
            return u;
        }
        return this.getJAXBContext(type2, mt).createUnmarshaller();
    }

    private final Unmarshaller getUnmarshaller(Class type2) throws JAXBException {
        Unmarshaller u;
        if (this.mtUnmarshaller != null && (u = this.mtUnmarshaller.getContext(type2)) != null) {
            return u;
        }
        return this.getJAXBContext(type2).createUnmarshaller();
    }

    protected final Marshaller getMarshaller(Class type2, MediaType mt) throws JAXBException {
        Marshaller m;
        if (this.fixedMediaType) {
            return this.getMarshaller(type2);
        }
        ContextResolver<Marshaller> mcr = this.ps.getContextResolver(Marshaller.class, mt);
        if (mcr != null && (m = mcr.getContext(type2)) != null) {
            return m;
        }
        m = this.getJAXBContext(type2, mt).createMarshaller();
        if (this.formattedOutput) {
            m.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
        }
        return m;
    }

    private final Marshaller getMarshaller(Class type2) throws JAXBException {
        Marshaller u;
        if (this.mtMarshaller != null && (u = this.mtMarshaller.getContext(type2)) != null) {
            return u;
        }
        Marshaller m = this.getJAXBContext(type2).createMarshaller();
        if (this.formattedOutput) {
            m.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
        }
        return m;
    }

    private final JAXBContext getJAXBContext(Class type2, MediaType mt) throws JAXBException {
        JAXBContext c;
        ContextResolver<JAXBContext> cr = this.ps.getContextResolver(JAXBContext.class, mt);
        if (cr != null && (c = cr.getContext(type2)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type2);
    }

    private final JAXBContext getJAXBContext(Class type2) throws JAXBException {
        JAXBContext c;
        if (this.mtContext != null && (c = this.mtContext.getContext(type2)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type2) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type2);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type2});
                jaxbContexts.put(type2, c);
            }
            return c;
        }
    }

    protected static SAXSource getSAXSource(SAXParserFactory spf, InputStream entityStream) throws JAXBException {
        try {
            return new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(entityStream));
        }
        catch (Exception ex) {
            throw new JAXBException("Error creating SAXSource", (Throwable)ex);
        }
    }

    protected boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    protected boolean isXmlRootElementProcessing() {
        return this.xmlRootElementProcessing;
    }
}

