/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import com.sun.jersey.server.spi.monitoring.glassfish.ResourceStatsProvider;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.annotations.Reset;

public class ApplicationStatsProvider {
    private final Map<String, ResourceStatsProvider> resourceStatsProviders = new HashMap<String, ResourceStatsProvider>();
    private final String applicationName;

    @Reset
    public void reset() {
    }

    public ApplicationStatsProvider(String applicationName) {
        this.applicationName = applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceStatsProvider getResourceStatsProvider(String resourceName) {
        Map<String, ResourceStatsProvider> map = this.resourceStatsProviders;
        synchronized (map) {
            if (this.resourceStatsProviders.containsKey(resourceName)) {
                return this.resourceStatsProviders.get(resourceName);
            }
            ResourceStatsProvider rsp = new ResourceStatsProvider(resourceName);
            StatsProviderManager.register("jersey", PluginPoint.SERVER, "applications/" + this.applicationName + "/jersey/resources/resource-" + this.resourceStatsProviders.size(), rsp);
            this.resourceStatsProviders.put(resourceName, rsp);
            return rsp;
        }
    }

    public void rootResourceClassHit(String resourceClassName) {
        ResourceStatsProvider rsp = this.getResourceStatsProvider(resourceClassName);
        rsp.rootResourceHit();
    }

    public void resourceClassHit(String resourceClassName) {
        ResourceStatsProvider rsp = this.getResourceStatsProvider(resourceClassName);
        rsp.resourceHit();
    }
}

