/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.gmbal.ManagedAttribute;

public class ResourceStatisticImpl
extends StatisticImpl
implements CountStatistic,
InvocationHandler {
    private long count = 0L;
    private final long initCount;
    private final CountStatistic cs = (CountStatistic)Proxy.newProxyInstance(CountStatistic.class.getClassLoader(), new Class[]{CountStatistic.class}, (InvocationHandler)this);
    private String resourceClassName;

    public ResourceStatisticImpl(long countVal, String name, String unit, String desc, long sampleTime, long startTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.count = countVal;
        this.initCount = countVal;
    }

    public ResourceStatisticImpl(String name, String unit, String desc) {
        this(0L, name, unit, desc, -1L, System.currentTimeMillis());
    }

    public ResourceStatisticImpl(String name, String unit, String desc, String resourceClassName) {
        this(0L, name, unit, desc, -1L, System.currentTimeMillis());
        this.resourceClassName = resourceClassName;
    }

    public synchronized CountStatistic getStatistic() {
        return this.cs;
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("count", this.getCount());
        m.put("classname", this.resourceClassName);
        return m;
    }

    @Override
    public synchronized String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount();
    }

    @Override
    @ManagedAttribute(id="count")
    public synchronized long getCount() {
        return this.count;
    }

    public synchronized void setCount(long countVal) {
        this.count = countVal;
        this.sampleTime = System.currentTimeMillis();
    }

    @ManagedAttribute(id="classname")
    public synchronized String getClassName() {
        return this.resourceClassName;
    }

    public synchronized void increment() {
        ++this.count;
        this.sampleTime = System.currentTimeMillis();
    }

    public synchronized void increment(long delta) {
        this.count += delta;
        this.sampleTime = System.currentTimeMillis();
    }

    public synchronized void decrement() {
        --this.count;
        this.sampleTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.count = this.initCount;
        this.sampleTime = -1L;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

