/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;

class Log {
    private LogControl logControl = null;
    private String logPath = null;
    static Logger _logger = LogDomains.getLogger(Log.class, "javax.enterprise.system.core.transaction");

    Log() {
        if (this.logPath == null) {
            int[] result = new int[1];
            this.logPath = Configuration.getDirectory("com.sun.jts.logDirectory", "jts", result);
            if (result[0] == 1 || result[0] == 2) {
                if (this.logPath.length() > 0) {
                    _logger.log(Level.WARNING, "jts.invalid_log_path", this.logPath);
                }
                if (result[0] == 2) {
                    _logger.log(Level.WARNING, "jts.invalid_default_log_path");
                    this.logPath = ".";
                }
            }
        }
    }

    Log(String logPath) {
        this.logPath = logPath;
    }

    boolean initialise() {
        boolean result = true;
        this.logControl = new LogControl();
        this.logControl.initLog(false, false, this.logPath);
        return result;
    }

    LogFile open(String serverName, LogUpcallTarget upcall) {
        LogFile logFile = null;
        boolean[] newLog = new boolean[]{true};
        try {
            LogHandle handle = this.logControl.openFile(serverName, upcall, null, newLog);
            logFile = new LogFile(handle);
        }
        catch (LogException le) {
            _logger.log(Level.SEVERE, "jts.log_error", le);
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.log_error", new Object[]{le.toString()});
            throw (INTERNAL)new INTERNAL(msg).initCause(le);
        }
        return logFile;
    }

    boolean terminate() {
        boolean result = true;
        return result;
    }

    static boolean checkFileExists(String serverName) {
        boolean exists = false;
        if (serverName != null) {
            String logPath = null;
            int[] result = new int[1];
            logPath = Configuration.getDirectory("com.sun.jts.logDirectory", "jts", result);
            if (result[0] == 1 || result[0] == 2) {
                if (logPath.length() > 0) {
                    _logger.log(Level.WARNING, "jts.invalid_log_path", logPath);
                }
                if (result[0] == 2) {
                    _logger.log(Level.WARNING, "jts.invalid_default_log_path");
                    logPath = ".";
                }
            }
            exists = LogControl.checkFileExists(serverName, logPath);
        }
        return exists;
    }

    void dump() {
        this.logControl.dump();
    }
}

