/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardServer
implements Lifecycle,
Server,
MBeanRegistration {
    private static Logger log = Logger.getLogger(StandardServer.class.getName());
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardEngine", "domain"}, {"org.apache.catalina.core.StandardHost", "domain"}, {"org.apache.catalina.core.StandardContext", "available"}, {"org.apache.catalina.core.StandardContext", "configFile"}, {"org.apache.catalina.core.StandardContext", "configured"}, {"org.apache.catalina.core.StandardContext", "distributable"}, {"org.apache.catalina.core.StandardContext", "domain"}, {"org.apache.catalina.core.StandardContext", "engineName"}, {"org.apache.catalina.core.StandardContext", "name"}, {"org.apache.catalina.core.StandardContext", "override"}, {"org.apache.catalina.core.StandardContext", "publicId"}, {"org.apache.catalina.core.StandardContext", "replaceWelcomeFiles"}, {"org.apache.catalina.core.StandardContext", "sessionTimeout"}, {"org.apache.catalina.core.StandardContext", "startupTime"}, {"org.apache.catalina.core.StandardContext", "tldScanTime"}, {"org.apache.catalina.core.StandardContext", "workDir"}, {"org.apache.catalina.session.StandardManager", "distributable"}, {"org.apache.catalina.session.StandardManager", "entropy"}};
    private static Class[] persistables = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};
    private static String[] skippables = new String[]{"org.apache.catalina.authenticator.BasicAuthenticator", "org.apache.catalina.authenticator.DigestAuthenticator", "org.apache.catalina.authenticator.FormAuthenticator", "org.apache.catalina.authenticator.NonLoginAuthenticator", "org.apache.catalina.authenticator.SSLAuthenticator", "org.apache.catalina.core.NamingContextListener", "org.apache.catalina.core.StandardContextValve", "org.apache.catalina.core.StandardDefaultContext", "org.apache.catalina.core.StandardEngineValve", "org.apache.catalina.core.StandardHostValve", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.startup.EngineConfig", "org.apache.catalina.startup.HostConfig", "org.apache.catalina.valves.CertificatesValve", "org.apache.catalina.valves.ErrorReportValve", "org.apache.catalina.valves.RequestListenerValve"};
    private static String[] standardImplementations = new String[]{"org.apache.catalina.core.StandardServer", "org.apache.catalina.core.StandardService", "org.apache.catalina.connector.CoyoteConnector", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.core.StandardHost", "org.apache.catalina.core.StandardContext"};
    private int debug = 0;
    private Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, e.toString());
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "StandardServer.await: create[" + this.port + "]: ", e);
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                log.log(Level.WARNING, "StandardServer.accept security exception: " + ace.getMessage(), ace);
                continue;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "StandardServer.await: accept: ", e);
                System.exit(1);
            }
            StringBuilder command = new StringBuilder();
            for (expected = 1024; expected < this.shutdown.length(); expected += this.random.nextInt(1024)) {
                if (this.random != null) continue;
                this.random = new Random(System.currentTimeMillis());
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "StandardServer.await: read: ", e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            log.warning("StandardServer.await: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!name.equals(this.services[i].getName())) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.services[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i = 0; i < this.services.length; ++i) {
            onames[i] = ((StandardService)this.services[i]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int j = -1;
            for (int i = 0; i < this.services.length; ++i) {
                if (service != this.services[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i = 0; i < this.services.length; ++i) {
                if (i == j) continue;
                results[k++] = this.services[i];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            log.fine(sm.getString("standardServer.start.started"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            for (int i = 0; i < this.services.length; ++i) {
                if (!(this.services[i] instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)this.services[i])).start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.lifecycle.fireLifecycleEvent("after_start", null);
            return;
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (!(this.services[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.services[i])).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        this.initialize();
    }

    @Override
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.info(sm.getString("standardServer.initialize.initialized"));
            return;
        }
        this.lifecycle.fireLifecycleEvent("init", null);
        this.initialized = true;
        if (this.oname == null) {
            try {
                this.oname = new ObjectName("Catalina:type=Server");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error registering ", e);
            }
        }
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i].initialize();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

