/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.LogicalDatabaseMetaData;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection
implements java.sql.Connection {
    protected Connection physicalConnection_ = null;
    private ClientPooledConnection pooledConnection_ = null;
    private LogicalDatabaseMetaData logicalDatabaseMetaData = null;

    public LogicalConnection(Connection connection, ClientPooledConnection clientPooledConnection) throws SqlException {
        this.physicalConnection_ = connection;
        this.pooledConnection_ = clientPooledConnection;
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void nullPhysicalConnection() {
        this.physicalConnection_ = null;
    }

    public synchronized void close() throws SQLException {
        try {
            if (this.physicalConnection_ == null) {
                return;
            }
            if (this.physicalConnection_.agent_.loggingEnabled()) {
                this.physicalConnection_.agent_.logWriter_.traceEntry(this, "close");
            }
            if (this.physicalConnection_.isClosed()) {
                this.pooledConnection_.informListeners(new SqlException(null, new ClientMessageId("08003.C.3")));
            } else {
                this.physicalConnection_.checkForTransactionInProgress();
                this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
                if (!this.physicalConnection_.isGlobalPending_()) {
                    this.pooledConnection_.recycleConnection();
                }
            }
            this.physicalConnection_ = null;
            this.pooledConnection_.nullLogicalConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeWithoutRecyclingToPool() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        this.physicalConnection_.checkForTransactionInProgress();
        try {
            if (this.physicalConnection_.isClosed()) {
                throw new SqlException(null, new ClientMessageId("08003"));
            }
        }
        finally {
            this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
            this.physicalConnection_ = null;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.physicalConnection_ == null) {
            return true;
        }
        return this.physicalConnection_.isClosed();
    }

    protected void checkForNullPhysicalConnection() throws SQLException {
        if (this.physicalConnection_ == null) {
            SqlException sqlException = new SqlException(null, new ClientMessageId("08003"));
            throw sqlException.getSQLException();
        }
    }

    final void notifyException(SQLException sQLException) {
        if (this.physicalConnection_ != null) {
            this.pooledConnection_.informListeners(new SqlException(sQLException));
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String string, Section section) throws SqlException {
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        return this.physicalConnection_.preparePositionedUpdateStatement(string, section);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.commit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            if (this.logicalDatabaseMetaData == null) {
                this.logicalDatabaseMetaData = this.newLogicalDatabaseMetaData();
            }
            return this.logicalDatabaseMetaData;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    protected LogicalDatabaseMetaData newLogicalDatabaseMetaData() throws SQLException {
        return new LogicalDatabaseMetaData(this, this.physicalConnection_.agent_.logWriter_);
    }

    final synchronized DatabaseMetaData getRealMetaDataObject() throws SQLException {
        if (this.isClosed()) {
            throw new SqlException(this.physicalConnection_ == null ? null : this.physicalConnection_.agent_.logWriter_, new ClientMessageId("08003")).getSQLException();
        }
        return this.physicalConnection_.getMetaData();
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public void setHoldability(int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public int getServerVersion() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getServerVersion();
    }
}

