/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID uUID, int n) {
        this.tableUUID = uUID;
        this.privType = n;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            StatementTablePermission statementTablePermission = (StatementTablePermission)object;
            return this.privType == statementTablePermission.privType && this.tableUUID.equals(statementTablePermission.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl, Activation activation) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        if (!this.hasPermissionOnTable(languageConnectionContext, activation, string, bl, execPreparedStatement)) {
            TableDescriptor tableDescriptor = this.getTableDescriptor(dataDictionary);
            throw StandardException.newException(bl ? "42501" : "42500", string, (Object)this.getPrivName(), (Object)tableDescriptor.getSchemaName(), (Object)tableDescriptor.getName());
        }
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dataDictionary) throws StandardException {
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableUUID);
        if (tableDescriptor == null) {
            throw StandardException.newException("4250E", "table");
        }
        return tableDescriptor;
    }

    protected boolean hasPermissionOnTable(LanguageConnectionContext languageConnectionContext, Activation activation, String string, boolean bl, ExecPreparedStatement execPreparedStatement) throws StandardException {
        String string2;
        boolean bl2;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        boolean bl3 = bl2 = this.oneAuthHasPermissionOnTable(dataDictionary, "PUBLIC", bl) || this.oneAuthHasPermissionOnTable(dataDictionary, string, bl);
        if (!bl2 && (string2 = languageConnectionContext.getCurrentRoleId(activation)) != null) {
            String string3 = dataDictionary.getAuthorizationDatabaseOwner();
            RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, string, string3);
            if (roleGrantDescriptor == null) {
                roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string2, "PUBLIC", string3);
            }
            if (roleGrantDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                String string4;
                RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, true);
                while (!bl2 && (string4 = roleClosureIterator.next()) != null) {
                    bl2 = this.oneAuthHasPermissionOnTable(dataDictionary, string4, bl);
                }
                if (bl2) {
                    DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                    RoleGrantDescriptor roleGrantDescriptor2 = dataDictionary.getRoleDefinitionDescriptor(string2);
                    ContextManager contextManager = languageConnectionContext.getContextManager();
                    dependencyManager.addDependency(execPreparedStatement, roleGrantDescriptor2, contextManager);
                    dependencyManager.addDependency(activation, roleGrantDescriptor2, contextManager);
                }
            }
        }
        return bl2;
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dataDictionary, String string, boolean bl) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = dataDictionary.getTablePermissions(this.tableUUID, string);
        if (tablePermsDescriptor == null) {
            return false;
        }
        String string2 = null;
        switch (this.privType) {
            case 0: 
            case 8: {
                string2 = tablePermsDescriptor.getSelectPriv();
                break;
            }
            case 1: {
                string2 = tablePermsDescriptor.getUpdatePriv();
                break;
            }
            case 2: {
                string2 = tablePermsDescriptor.getReferencesPriv();
                break;
            }
            case 3: {
                string2 = tablePermsDescriptor.getInsertPriv();
                break;
            }
            case 4: {
                string2 = tablePermsDescriptor.getDeletePriv();
                break;
            }
            case 5: {
                string2 = tablePermsDescriptor.getTriggerPriv();
            }
        }
        return "Y".equals(string2) || !bl && "y".equals(string2);
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dataDictionary, string, false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, string);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: 
            case 8: {
                return "SELECT";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "REFERENCES";
            }
            case 3: {
                return "INSERT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "TRIGGER";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementTablePermission: " + this.getPrivName() + " " + this.tableUUID;
    }
}

