/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.impl.store.raw.xact.ContainerLocking2;
import org.apache.derby.impl.store.raw.xact.ContainerLocking3;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.InternalXact;
import org.apache.derby.impl.store.raw.xact.NoLocking;
import org.apache.derby.impl.store.raw.xact.RowLocking1;
import org.apache.derby.impl.store.raw.xact.RowLocking2;
import org.apache.derby.impl.store.raw.xact.RowLocking2nohold;
import org.apache.derby.impl.store.raw.xact.RowLocking3;
import org.apache.derby.impl.store.raw.xact.RowLockingRR;
import org.apache.derby.impl.store.raw.xact.TransactionMapFactory;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactContext;
import org.apache.derby.impl.store.raw.xact.XactId;
import org.apache.derby.impl.store.raw.xact.XactXAResourceManager;

public class XactFactory
implements TransactionFactory,
ModuleControl,
ModuleSupportable {
    protected static final String USER_CONTEXT_ID = "UserTransaction";
    protected static final String NESTED_READONLY_USER_CONTEXT_ID = "NestedRawReadOnlyUserTransaction";
    protected static final String NESTED_UPDATE_USER_CONTEXT_ID = "NestedRawUpdateUserTransaction";
    protected static final String INTERNAL_CONTEXT_ID = "InternalTransaction";
    protected static final String NTT_CONTEXT_ID = "NestedTransaction";
    protected DaemonService rawStoreDaemon;
    private UUIDFactory uuidFactory;
    protected ContextService contextFactory;
    protected LockFactory lockFactory;
    protected LogFactory logFactory;
    protected DataFactory dataFactory;
    protected DataValueFactory dataValueFactory;
    protected RawStoreFactory rawStoreFactory;
    public TransactionTable ttab;
    private long tranId;
    private LockingPolicy[][] lockingPolicies = new LockingPolicy[3][6];
    private boolean inCreateNoLog = false;
    private XAResourceManager xa_resource;
    private Object backupSemaphore = new Object();
    private long backupBlockingOperations = 0L;
    private boolean inBackup = false;
    private static TransactionMapFactory mapFactory;

    public XactFactory() {
        this.setMapFactory();
    }

    TransactionMapFactory createMapFactory() {
        return new TransactionMapFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMapFactory() {
        Class clazz = XactFactory.class;
        synchronized (clazz) {
            if (mapFactory == null) {
                mapFactory = this.createMapFactory();
            }
        }
    }

    static synchronized TransactionMapFactory getMapFactory() {
        return mapFactory;
    }

    public boolean canSupport(Properties properties) {
        return true;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.dataValueFactory = (DataValueFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.contextFactory = ContextService.getFactory();
        this.lockFactory = (LockFactory)Monitor.bootServiceModule(false, this, "org.apache.derby.iapi.services.locks.LockFactory", properties);
        this.lockingPolicies[0][0] = new NoLocking();
        this.lockingPolicies[1][0] = new NoLocking();
        this.lockingPolicies[1][1] = new RowLocking1(this.lockFactory);
        this.lockingPolicies[1][2] = new RowLocking2(this.lockFactory);
        this.lockingPolicies[1][3] = new RowLocking2nohold(this.lockFactory);
        this.lockingPolicies[1][4] = new RowLockingRR(this.lockFactory);
        this.lockingPolicies[1][5] = new RowLocking3(this.lockFactory);
        this.lockingPolicies[2][0] = new NoLocking();
        this.lockingPolicies[2][1] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][2] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][3] = new ContainerLocking2(this.lockFactory);
        this.lockingPolicies[2][4] = new ContainerLocking3(this.lockFactory);
        this.lockingPolicies[2][5] = new ContainerLocking3(this.lockFactory);
        if (bl) {
            this.ttab = new TransactionTable();
            String string = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = string != null && Boolean.valueOf(string) != false;
        }
    }

    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSTB5.M");
        }
        if (this.ttab.hasActiveUpdateTransaction()) {
            throw StandardException.newException("XSTB5.M");
        }
        this.inCreateNoLog = false;
    }

    private RawTransaction startCommonTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, boolean bl, CompatibilitySpace compatibilitySpace, String string, String string2, boolean bl2) throws StandardException {
        Xact xact = new Xact(this, this.logFactory, this.dataFactory, this.dataValueFactory, bl, compatibilitySpace);
        xact.setTransName(string2);
        this.pushTransactionContext(contextManager, string, xact, false, rawStoreFactory, bl2);
        return xact;
    }

    public RawTransaction startTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, String string) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, contextManager, false, null, USER_CONTEXT_ID, string, true);
    }

    public RawTransaction startNestedReadOnlyUserTransaction(RawStoreFactory rawStoreFactory, CompatibilitySpace compatibilitySpace, ContextManager contextManager, String string) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, contextManager, true, compatibilitySpace, NESTED_READONLY_USER_CONTEXT_ID, string, false);
    }

    public RawTransaction startNestedUpdateUserTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, String string) throws StandardException {
        return this.startCommonTransaction(rawStoreFactory, contextManager, false, null, NESTED_UPDATE_USER_CONTEXT_ID, string, true);
    }

    public RawTransaction startGlobalTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        GlobalXactId globalXactId = new GlobalXactId(n, byArray, byArray2);
        if (this.ttab.findTransactionContextByGlobalId(globalXactId) != null) {
            throw StandardException.newException("XSAX1.S");
        }
        RawTransaction rawTransaction = this.startCommonTransaction(rawStoreFactory, contextManager, false, null, USER_CONTEXT_ID, USER_CONTEXT_ID, true);
        rawTransaction.setTransactionId(globalXactId, rawTransaction.getId());
        return rawTransaction;
    }

    public RawTransaction findUserTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager, String string) throws StandardException {
        XactContext xactContext = (XactContext)contextManager.getContext(USER_CONTEXT_ID);
        if (xactContext == null) {
            return this.startTransaction(rawStoreFactory, contextManager, string);
        }
        return xactContext.getTransaction();
    }

    public RawTransaction startNestedTopTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager) throws StandardException {
        Xact xact = new Xact(this, this.logFactory, this.dataFactory, this.dataValueFactory, false, null);
        xact.setPostComplete();
        this.pushTransactionContext(contextManager, NTT_CONTEXT_ID, xact, true, rawStoreFactory, true);
        return xact;
    }

    public RawTransaction startInternalTransaction(RawStoreFactory rawStoreFactory, ContextManager contextManager) throws StandardException {
        InternalXact internalXact = new InternalXact(this, this.logFactory, this.dataFactory, this.dataValueFactory);
        this.pushTransactionContext(contextManager, INTERNAL_CONTEXT_ID, internalXact, true, rawStoreFactory, true);
        return internalXact;
    }

    public boolean findTransaction(TransactionId transactionId, RawTransaction rawTransaction) {
        return this.ttab.findAndAssumeTransaction(transactionId, rawTransaction);
    }

    public void rollbackAllTransactions(RawTransaction rawTransaction, RawStoreFactory rawStoreFactory) throws StandardException {
        int n = 0;
        if (this.ttab.hasRollbackFirstTransaction()) {
            RawTransaction rawTransaction2 = this.startInternalTransaction(rawStoreFactory, rawTransaction.getContextManager());
            rawTransaction2.recoveryTransaction();
            while (this.ttab.getMostRecentRollbackFirstTransaction(rawTransaction2)) {
                ++n;
                rawTransaction2.abort();
            }
            rawTransaction2.close();
        }
        int n2 = 0;
        while (this.ttab.getMostRecentTransactionForRollback(rawTransaction)) {
            ++n2;
            rawTransaction.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePreparedXacts(RawStoreFactory rawStoreFactory) throws StandardException {
        boolean bl = false;
        if (this.ttab.hasPreparedRecoveredXact()) {
            while (true) {
                Object var6_5;
                ContextManager contextManager = this.contextFactory.newContextManager();
                this.contextFactory.setCurrentContextManager(contextManager);
                try {
                    RawTransaction rawTransaction = this.startTransaction(this.rawStoreFactory, contextManager, USER_CONTEXT_ID);
                    if (!this.ttab.getMostRecentPreparedRecoveredXact(rawTransaction)) {
                        rawTransaction.destroy();
                        var6_5 = null;
                        this.contextFactory.resetCurrentContextManager(contextManager);
                        break;
                    }
                    rawTransaction.reprepare();
                    var6_5 = null;
                    this.contextFactory.resetCurrentContextManager(contextManager);
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    this.contextFactory.resetCurrentContextManager(contextManager);
                    throw throwable;
                }
            }
        }
    }

    public LogInstant firstUpdateInstant() {
        return this.ttab.getFirstLogInstant();
    }

    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        return standardException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewTransactionId(TransactionId transactionId, Xact xact) {
        XactId xactId;
        boolean bl = true;
        if (transactionId != null) {
            bl = this.remove(transactionId);
        }
        XactFactory xactFactory = this;
        synchronized (xactFactory) {
            xactId = new XactId(this.tranId++);
        }
        xact.setTransactionId(xact.getGlobalId(), (TransactionId)xactId);
        if (transactionId != null) {
            this.add(xact, bl);
        }
    }

    public void resetTranId() {
        XactId xactId = (XactId)this.ttab.largestUpdateXactId();
        this.tranId = xactId != null ? xactId.getId() + 1L : 1L;
    }

    protected void pushTransactionContext(ContextManager contextManager, String string, Xact xact, boolean bl, RawStoreFactory rawStoreFactory, boolean bl2) throws StandardException {
        if (contextManager.getContext(string) != null) {
            throw StandardException.newException("XSTA2.S");
        }
        XactContext xactContext = new XactContext(contextManager, string, xact, bl, rawStoreFactory);
        this.add(xact, bl2);
    }

    protected void addUpdateTransaction(TransactionId transactionId, RawTransaction rawTransaction, int n) {
        this.ttab.addUpdateTransaction(transactionId, rawTransaction, n);
    }

    protected void removeUpdateTransaction(TransactionId transactionId) {
        this.ttab.removeUpdateTransaction(transactionId);
    }

    protected void prepareTransaction(TransactionId transactionId) {
        this.ttab.prepareTransaction(transactionId);
    }

    public boolean submitPostCommitWork(Serviceable serviceable) {
        if (this.rawStoreDaemon != null) {
            return this.rawStoreDaemon.enqueue(serviceable, serviceable.serviceASAP());
        }
        return false;
    }

    public void setRawStoreFactory(RawStoreFactory rawStoreFactory) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        this.rawStoreDaemon = rawStoreFactory.getDaemon();
        this.logFactory = (LogFactory)Monitor.findServiceModule(this, rawStoreFactory.getLogFactoryModule());
        this.dataFactory = (DataFactory)Monitor.findServiceModule(this, rawStoreFactory.getDataFactoryModule());
    }

    public boolean noActiveUpdateTransaction() {
        return !this.ttab.hasActiveUpdateTransaction();
    }

    public boolean hasPreparedXact() {
        return this.ttab.hasPreparedXact();
    }

    protected boolean remove(TransactionId transactionId) {
        return this.ttab.remove(transactionId);
    }

    protected void add(Xact xact, boolean bl) {
        this.ttab.add(xact, bl);
    }

    public UUID makeNewUUID() {
        return this.uuidFactory.createUUID();
    }

    public boolean flushLogOnCommit(String string) {
        return string == USER_CONTEXT_ID || string.equals(USER_CONTEXT_ID);
    }

    final LockingPolicy getLockingPolicy(int n, int n2, boolean bl) {
        LockingPolicy lockingPolicy;
        if (n == 0) {
            n2 = 0;
        }
        if ((lockingPolicy = this.lockingPolicies[n][n2]) != null || !bl) {
            return lockingPolicy;
        }
        ++n;
        while (n <= 2) {
            for (int i = n2; i <= 5; ++i) {
                lockingPolicy = this.lockingPolicies[n][i];
                if (lockingPolicy == null) continue;
                return lockingPolicy;
            }
            ++n;
        }
        return null;
    }

    public Formatable getTransactionTable() {
        return this.ttab;
    }

    public void useTransactionTable(Formatable formatable) throws StandardException {
        if (this.ttab != null && formatable != null) {
            throw StandardException.newException("XSTB6.M");
        }
        if (this.ttab == null) {
            this.ttab = formatable == null ? new TransactionTable() : (TransactionTable)formatable;
        }
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.ttab.getTransactionInfo();
    }

    public boolean inDatabaseCreation() {
        return this.inCreateNoLog;
    }

    public Object getXAResourceManager() throws StandardException {
        if (this.xa_resource == null) {
            this.xa_resource = new XactXAResourceManager(this.rawStoreFactory, this.ttab);
        }
        return this.xa_resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean blockBackup(boolean bl) throws StandardException {
        Object object = this.backupSemaphore;
        synchronized (object) {
            if (this.inBackup) {
                if (bl) {
                    while (this.inBackup) {
                        try {
                            this.backupSemaphore.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    }
                } else {
                    return false;
                }
            }
            ++this.backupBlockingOperations;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblockBackup() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            --this.backupBlockingOperations;
            if (this.inBackup) {
                this.backupSemaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean blockBackupBlockingOperations(boolean var1_1) throws StandardException {
        block8: {
            var2_2 = this.backupSemaphore;
            // MONITORENTER : var2_2
            if (!var1_1) break block8;
            this.inBackup = true;
            try {}
            catch (RuntimeException var3_4) {
                this.inBackup = false;
                this.backupSemaphore.notifyAll();
                throw var3_4;
            }
            ** GOTO lbl-1000
        }
        if (this.backupBlockingOperations == 0L) {
            this.inBackup = true;
        }
        // MONITOREXIT : var2_2
        return this.inBackup;
lbl-1000:
        // 2 sources

        {
            while (this.backupBlockingOperations > 0L) {
                try {
                    this.backupSemaphore.wait();
                }
                catch (InterruptedException var3_3) {
                    this.inBackup = false;
                    this.backupSemaphore.notifyAll();
                    throw StandardException.interrupt(var3_3);
                }
            }
            return this.inBackup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockBackupBlockingOperations() {
        Object object = this.backupSemaphore;
        synchronized (object) {
            this.inBackup = false;
            this.backupSemaphore.notifyAll();
        }
    }
}

