/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.runtime.ELContextImpl;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspUtil {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags/";
    private static final String META_INF_TAGS = "/META-INF/tags/";
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_XML = "%=";
    private static final String CLOSE_EXPR_XML = "%";
    private static int tempSequenceNumber = 0;
    private static ExpressionFactory expFactory;
    private static final String[] javaKeywords;
    public static final int CHUNKSIZE = 1024;
    static Map<String, Manifest> manifestMap;
    static Manifest nullManifest;

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '>') {
                caw.write(37);
                caw.write(62);
                i += 2;
                continue;
            }
            caw.write(chars[i]);
        }
        return caw.toCharArray();
    }

    public static char[] escapeQuotes(char[] chars) {
        int n;
        String s = new String(chars);
        while ((n = s.indexOf("%\\>")) >= 0) {
            StringBuilder sb = new StringBuilder(s.substring(0, n));
            sb.append(CLOSE_EXPR);
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        chars = s.toCharArray();
        return chars;
    }

    public static boolean isExpression(String token, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        return token.startsWith(openExpr) && token.endsWith(closeExpr);
    }

    public static String getExpr(String expression, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        int length = expression.length();
        String returnString = expression.startsWith(openExpr) && expression.endsWith(closeExpr) ? expression.substring(openExpr.length(), length - closeExpr.length()) : "";
        return returnString;
    }

    public static String getExprInXml(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(1, length - 1) : expression;
        return JspUtil.escapeXml(returnString);
    }

    public static void checkScope(String scope, Node n, ErrorDispatcher err) throws JasperException {
        if (!(scope == null || scope.equals("page") || scope.equals("request") || scope.equals("session") || scope.equals("application"))) {
            err.jspError(n, "jsp.error.invalid.scope", scope);
        }
    }

    public static void checkAttributes(String typeOfTag, Node n, ValidAttribute[] validAttributes, ErrorDispatcher err) throws JasperException {
        int attrLeftLength;
        int i;
        Attributes attrs = n.getAttributes();
        Mark start = n.getStart();
        boolean valid = true;
        int tempLength = attrs == null ? 0 : attrs.getLength();
        ArrayList<String> temp = new ArrayList<String>(tempLength);
        for (int i2 = 0; i2 < tempLength; ++i2) {
            String qName = attrs.getQName(i2);
            if (qName.equals("xmlns") || qName.startsWith("xmlns:")) continue;
            temp.add(qName);
        }
        Node.Nodes tagBody = n.getBody();
        if (tagBody != null) {
            Node node;
            int numSubElements = tagBody.size();
            for (i = 0; i < numSubElements && (node = tagBody.getNode(i)) instanceof Node.NamedAttribute; ++i) {
                String attrName = node.getAttributeValue("name");
                temp.add(attrName);
                if (n.getAttributeValue(attrName) == null) continue;
                err.jspError(n, "jsp.error.duplicate.name.jspattribute", attrName);
            }
        }
        String missingAttribute = null;
        for (i = 0; i < validAttributes.length; ++i) {
            if (!validAttributes[i].mandatory) continue;
            int attrPos = temp.indexOf(validAttributes[i].name);
            if (attrPos != -1) {
                temp.remove(attrPos);
                valid = true;
                continue;
            }
            valid = false;
            missingAttribute = validAttributes[i].name;
            break;
        }
        if (!valid) {
            err.jspError(start, "jsp.error.mandatory.attribute", typeOfTag, missingAttribute);
        }
        if ((attrLeftLength = temp.size()) == 0) {
            return;
        }
        String attribute = null;
        for (int j = 0; j < attrLeftLength; ++j) {
            valid = false;
            attribute = (String)temp.get(j);
            for (int i3 = 0; i3 < validAttributes.length; ++i3) {
                if (!attribute.equals(validAttributes[i3].name)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            err.jspError(start, "jsp.error.invalid.attribute", typeOfTag, attribute);
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "\\\"";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
        }
        return escString;
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replace(String name, char replace, String with) {
        StringBuilder buf = new StringBuilder();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(replace, begin)) < 0) {
                end = last;
            }
            buf.append(name.substring(begin, end));
            if (end == last) break;
            buf.append(with);
            begin = end + 1;
        }
        return buf.toString();
    }

    public static boolean booleanValue(String s) {
        boolean b = false;
        if (s != null) {
            b = s.equalsIgnoreCase("yes") ? true : Boolean.valueOf(s);
        }
        return b;
    }

    public static Class<?> toClass(String type2, ClassLoader loader) throws ClassNotFoundException {
        Class<Comparable<Boolean>> c = null;
        int i0 = type2.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type2.length(); ++i) {
                if (type2.charAt(i) != '[') continue;
                ++dims;
            }
            type2 = type2.substring(0, i0);
        }
        if ("boolean".equals(type2)) {
            c = Boolean.TYPE;
        } else if ("char".equals(type2)) {
            c = Character.TYPE;
        } else if ("byte".equals(type2)) {
            c = Byte.TYPE;
        } else if ("short".equals(type2)) {
            c = Short.TYPE;
        } else if ("int".equals(type2)) {
            c = Integer.TYPE;
        } else if ("long".equals(type2)) {
            c = Long.TYPE;
        } else if ("float".equals(type2)) {
            c = Float.TYPE;
        } else if ("double".equals(type2)) {
            c = Double.TYPE;
        } else if (type2.indexOf(91) < 0) {
            c = loader.loadClass(type2);
        }
        if (dims == 0) {
            return c;
        }
        if (dims == 1) {
            return Array.newInstance(c, 1).getClass();
        }
        return Array.newInstance(c, new int[dims]).getClass();
    }

    public static String interpreterCall(boolean isTagFile, String expression, Class expectedType, String fnmapvar, String expectedDeferredType, String expectedReturnType, String[] expectedParamTypes) {
        String jspCtxt = null;
        jspCtxt = isTagFile ? "this.getJspContext()" : "_jspx_page_context";
        if (expectedType == ValueExpression.class) {
            if (expectedDeferredType == null) {
                expectedDeferredType = "java.lang.Object";
            }
            return "org.apache.jasper.runtime.PageContextImpl.getValueExpression(" + Generator.quote(expression) + ", " + "(PageContext)" + jspCtxt + ", " + expectedDeferredType + ".class, " + fnmapvar + ")";
        }
        if (expectedType == MethodExpression.class) {
            if (expectedReturnType == null) {
                expectedReturnType = "Void";
            }
            StringBuilder params = new StringBuilder();
            if (expectedParamTypes != null) {
                for (int i = 0; i < expectedParamTypes.length; ++i) {
                    if (i > 0) {
                        params.append(", ");
                    }
                    params.append(expectedParamTypes[i] + ".class");
                }
            }
            return "org.apache.jasper.runtime.PageContextImpl.getMethodExpression(" + Generator.quote(expression) + ", " + "(PageContext)" + jspCtxt + ", " + fnmapvar + ", " + expectedReturnType + ".class, " + "new Class[] {" + params.toString() + "})";
        }
        String targetType = expectedType.getName();
        String primitiveConverterMethod = null;
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                targetType = Boolean.class.getName();
                primitiveConverterMethod = "booleanValue";
            } else if (expectedType.equals(Byte.TYPE)) {
                targetType = Byte.class.getName();
                primitiveConverterMethod = "byteValue";
            } else if (expectedType.equals(Character.TYPE)) {
                targetType = Character.class.getName();
                primitiveConverterMethod = "charValue";
            } else if (expectedType.equals(Short.TYPE)) {
                targetType = Short.class.getName();
                primitiveConverterMethod = "shortValue";
            } else if (expectedType.equals(Integer.TYPE)) {
                targetType = Integer.class.getName();
                primitiveConverterMethod = "intValue";
            } else if (expectedType.equals(Long.TYPE)) {
                targetType = Long.class.getName();
                primitiveConverterMethod = "longValue";
            } else if (expectedType.equals(Float.TYPE)) {
                targetType = Float.class.getName();
                primitiveConverterMethod = "floatValue";
            } else if (expectedType.equals(Double.TYPE)) {
                targetType = Double.class.getName();
                primitiveConverterMethod = "doubleValue";
            }
        }
        targetType = JspUtil.toJavaSourceType(targetType);
        StringBuilder call = new StringBuilder("(" + targetType + ") " + "org.apache.jasper.runtime.PageContextImpl.evaluateExpression" + "(" + Generator.quote(expression) + ", " + targetType + ".class, " + "(PageContext)" + jspCtxt + ", " + fnmapvar + ")");
        if (primitiveConverterMethod != null) {
            call.insert(0, "(");
            call.append(")." + primitiveConverterMethod + "()");
        }
        return call.toString();
    }

    public static void validateExpressions(Mark where, String expressions, FunctionMapper functionMapper, ErrorDispatcher err) throws JasperException {
        try {
            ELContextImpl elContext = new ELContextImpl(null);
            elContext.setFunctionMapper(functionMapper);
            JspUtil.getExpressionFactory().createValueExpression(elContext, expressions, Object.class);
        }
        catch (ELException e) {
            err.jspError(where, "jsp.error.invalid.expression", expressions, e.toString());
        }
    }

    public static Object coerce(Class targetType, String value) throws ELException {
        return JspUtil.getExpressionFactory().coerceToType(value, targetType);
    }

    public static void resetTemporaryVariableName() {
        tempSequenceNumber = 0;
    }

    public static String nextTemporaryVariableName() {
        return "_jspx_temp" + tempSequenceNumber++;
    }

    public static String coerceToPrimitiveBoolean(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "false";
        }
        return Boolean.valueOf(s).toString();
    }

    public static String coerceToBoolean(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Boolean.class)";
        }
        if (s == null || s.length() == 0) {
            return "Boolean.FALSE";
        }
        return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveByte(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(byte) 0";
        }
        return "((byte)" + Byte.valueOf(s).toString() + ")";
    }

    public static String coerceToByte(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Byte.class)";
        }
        if (s == null || s.length() == 0) {
            return "Byte.valueOf((byte) 0)";
        }
        return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
    }

    public static String coerceToChar(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(char) 0";
        }
        char ch = s.charAt(0);
        return "((char) " + ch + ")";
    }

    public static String coerceToCharacter(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Character.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Character((char) 0)";
        }
        char ch = s.charAt(0);
        return "new Character((char) " + ch + ")";
    }

    public static String coerceToPrimitiveDouble(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(double) 0";
        }
        return Double.valueOf(s).toString();
    }

    public static String coerceToDouble(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Double.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Double(0)";
        }
        return "new Double(" + Double.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveFloat(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(float) 0";
        }
        return Float.valueOf(s).toString() + "f";
    }

    public static String coerceToFloat(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Float.class)";
        }
        if (s == null || s.length() == 0) {
            return "Float.valueOf(0)";
        }
        return "new Float(" + Float.valueOf(s).toString() + "f)";
    }

    public static String coerceToInt(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "0";
        }
        return Integer.valueOf(s).toString();
    }

    public static String coerceToInteger(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Integer.class)";
        }
        if (s == null || s.length() == 0) {
            return "Integer.valueOf(0)";
        }
        return "new Integer(" + Integer.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveShort(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(short) 0";
        }
        return "((short) " + Short.valueOf(s).toString() + ")";
    }

    public static String coerceToShort(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Short.class)";
        }
        if (s == null || s.length() == 0) {
            return "Short.valueOf((short) 0)";
        }
        return "new Short(\"" + Short.valueOf(s).toString() + "\")";
    }

    public static String coerceToPrimitiveLong(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(long) 0";
        }
        return Long.valueOf(s).toString() + "l";
    }

    public static String coerceToLong(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Long.class)";
        }
        if (s == null || s.length() == 0) {
            return "Long.valueOf(0)";
        }
        return "new Long(" + Long.valueOf(s).toString() + "l)";
    }

    public static String coerceToEnum(String s, String enumClass, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + "," + enumClass + ".class)";
        }
        if (s == null || s.length() == 0) {
            return "null";
        }
        return "Enum.valueOf(" + enumClass + ".class, \"" + s + "\")";
    }

    public static InputStream getInputStream(String fname, JarFile jarFile, JspCompilationContext ctxt, ErrorDispatcher err) throws JasperException, IOException {
        InputStream in = null;
        if (jarFile != null) {
            String jarEntryName = fname.substring(1, fname.length());
            ZipEntry jarEntry = jarFile.getEntry(jarEntryName);
            if (jarEntry == null) {
                err.jspError("jsp.error.file.not.found", fname);
            }
            in = jarFile.getInputStream(jarEntry);
        } else {
            in = ctxt.getResourceAsStream(fname);
        }
        if (in == null) {
            err.jspError("jsp.error.file.not.found", fname);
        }
        return in;
    }

    public static String getTagHandlerClassName(String path, ErrorDispatcher err) throws JasperException {
        String className = null;
        int begin = 0;
        int index = path.lastIndexOf(".tag");
        if (index == -1) {
            err.jspError("jsp.error.tagfile.badSuffix", path);
        }
        if ((index = path.indexOf(WEB_INF_TAGS)) != -1) {
            className = "org.apache.jsp.tag.web.";
            begin = index + WEB_INF_TAGS.length();
        } else {
            index = path.indexOf(META_INF_TAGS);
            if (index != -1) {
                className = "org.apache.jsp.tag.meta.";
                begin = index + META_INF_TAGS.length();
            } else {
                err.jspError("jsp.error.tagfile.illegalPath", path);
            }
        }
        className = className + JspUtil.makeJavaPackage(path.substring(begin));
        return className;
    }

    public static final String makeJavaPackage(String path) {
        String[] classNameComponents = JspUtil.split(path, "/");
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JspUtil.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static final String[] split(String path, String pat) {
        ArrayList<String> comps = new ArrayList<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.get(i);
        }
        return result;
    }

    public static final String makeJavaIdentifier(String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JspUtil.mangleChar(ch));
        }
        if (JspUtil.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    public static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    public static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    public static final String makeXmlJavaIdentifier(String name) {
        if (name.indexOf(45) >= 0) {
            name = JspUtil.replace(name, '-', "$1");
        }
        if (name.indexOf(46) >= 0) {
            name = JspUtil.replace(name, '.', "$2");
        }
        if (name.indexOf(58) >= 0) {
            name = JspUtil.replace(name, ':', "$3");
        }
        return name;
    }

    static InputStreamReader getReader(String fname, String encoding, JarFile jarFile, JspCompilationContext ctxt, ErrorDispatcher err) throws JasperException, IOException {
        InputStreamReader reader = null;
        InputStream in = JspUtil.getInputStream(fname, jarFile, ctxt, err);
        try {
            reader = new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            err.jspError("jsp.error.unsupported.encoding", encoding);
        }
        return reader;
    }

    public static String toJavaSourceType(String type2) {
        if (type2.charAt(0) != '[') {
            return type2;
        }
        int dims = 1;
        String t = null;
        for (int i = 1; i < type2.length(); ++i) {
            if (type2.charAt(i) == '[') {
                ++dims;
                continue;
            }
            switch (type2.charAt(i)) {
                case 'Z': {
                    t = "boolean";
                    break;
                }
                case 'B': {
                    t = "byte";
                    break;
                }
                case 'C': {
                    t = "char";
                    break;
                }
                case 'D': {
                    t = "double";
                    break;
                }
                case 'F': {
                    t = "float";
                    break;
                }
                case 'I': {
                    t = "int";
                    break;
                }
                case 'J': {
                    t = "long";
                    break;
                }
                case 'S': {
                    t = "short";
                    break;
                }
                case 'L': {
                    t = type2.substring(i + 1, type2.indexOf(59));
                }
            }
            break;
        }
        StringBuilder resultType = new StringBuilder(t);
        while (dims > 0) {
            resultType.append("[]");
            --dims;
        }
        return resultType.toString();
    }

    public static String getCanonicalName(Class c) {
        String binaryName = c.getName();
        if ((c = c.getDeclaringClass()) == null) {
            return binaryName;
        }
        StringBuilder buf = new StringBuilder(binaryName);
        do {
            buf.setCharAt(c.getName().length(), '.');
        } while ((c = c.getDeclaringClass()) != null);
        return buf.toString();
    }

    private static ExpressionFactory getExpressionFactory() {
        if (expFactory == null) {
            expFactory = ExpressionFactory.newInstance();
        }
        return expFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> expandClassPath(List<String> files) {
        i = 0;
        while (i < files.size()) {
            block24: {
                block26: {
                    block25: {
                        block23: {
                            block22: {
                                file = files.get(i);
                                if (!file.endsWith(".jar")) break block24;
                                manifest = JspUtil.manifestMap.get(file);
                                jarfile = null;
                                if (manifest != null) break block25;
                                try {
                                    try {
                                        jarfile = new JarFile(file, false);
                                        manifest = jarfile.getManifest();
                                        if (manifest == null) {
                                            JspUtil.manifestMap.put(file, JspUtil.nullManifest);
                                            var7_9 = null;
                                            break block22;
                                        }
                                        if (file.contains("/WEB-INF")) break block23;
                                        JspUtil.manifestMap.put(file, manifest);
                                        break block23;
                                    }
                                    catch (IOException ex) {
                                        var7_9 = null;
                                        try {
                                            if (jarfile != null) {
                                                jarfile.close();
                                            }
                                            break block24;
                                        }
                                        catch (IOException ex) {}
                                        break block24;
                                    }
                                }
                                catch (Throwable var6_8) {
                                    var7_9 = null;
                                    ** try [egrp 2[TRYBLOCK] [6 : 141->154)] { 
lbl36:
                                    // 1 sources

                                    if (jarfile == null) throw var6_8;
                                    jarfile.close();
                                    throw var6_8;
lbl39:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                    throw var6_8;
                                }
                            }
                            try {}
                            catch (IOException ex) {}
                            if (jarfile != null) {
                                jarfile.close();
                            }
                            break block24;
                        }
                        var7_9 = null;
                        try {}
                        catch (IOException ex) {}
                        if (jarfile != null) {
                            jarfile.close();
                        }
                        break block26;
                    }
                    if (manifest == JspUtil.nullManifest) break block24;
                }
                if ((cp = (attrs = manifest.getMainAttributes()).getValue("Class-Path")) != null) {
                    paths = cp.split(" ");
                    lastIndex = file.lastIndexOf(File.separatorChar);
                    baseDir = "";
                    if (lastIndex > 0) {
                        baseDir = file.substring(0, lastIndex + 1);
                    }
                    for (String path : paths) {
                        p = path.startsWith(File.separator) != false ? path : baseDir + path;
                        if (files.contains(p)) continue;
                        files.add(p);
                    }
                }
            }
            ++i;
        }
        return files;
    }

    static {
        javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
        manifestMap = new ConcurrentHashMap<String, Manifest>();
        nullManifest = new Manifest();
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public ValidAttribute(String name) {
            this(name, false);
        }
    }
}

