/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import com.sun.grizzly.util.IntrospectionUtils;
import java.util.logging.Level;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertyRule
extends Rule {
    protected String name = null;
    protected String value = null;

    public SetPropertyRule(Digester digester, String name, String value) {
        this(name, value);
    }

    public SetPropertyRule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void begin(Attributes attributes) throws Exception {
        String actualName = null;
        String actualValue = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            if ("".equals(name)) {
                name = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            if (name.equals(this.name)) {
                actualName = value;
                continue;
            }
            if (!name.equals(this.value)) continue;
            actualValue = value;
        }
        Object top = this.digester.peek();
        if (this.digester.log.isLoggable(Level.FINE)) {
            this.digester.log.fine("[SetPropertyRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " property " + actualName + " to " + actualValue);
        }
        if (!this.digester.isFakeAttribute(top, actualName) && !IntrospectionUtils.setProperty(top, actualName, actualValue) && this.digester.getRulesValidation()) {
            this.digester.log.warning("[SetPropertyRule]{" + this.digester.match + "} Setting property '" + this.name + "' to '" + this.value + "' did not find a matching property.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetPropertyRule[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

