/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbeansDescriptorsSerSource
extends ModelerSource {
    private static Logger log = Logger.getLogger(MbeansDescriptorsSerSource.class.getName());
    Registry registry;
    String type;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String location, String type2, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type2);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        long t1 = System.currentTimeMillis();
        try {
            InputStream stream = null;
            if (this.source instanceof URL) {
                stream = ((URL)this.source).openStream();
            }
            if (this.source instanceof InputStream) {
                stream = (InputStream)this.source;
            }
            if (stream == null) {
                throw new Exception("Can't process " + this.source);
            }
            ObjectInputStream ois = new ObjectInputStream(stream);
            Thread.currentThread().setContextClassLoader(ManagedBean.class.getClassLoader());
            Object obj = ois.readObject();
            ManagedBean[] beans = (ManagedBean[])obj;
            for (int i = 0; i < beans.length; ++i) {
                this.registry.addManagedBean(beans[i]);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error reading descriptors " + this.source + " " + ex.toString(), ex);
            throw ex;
        }
        long t2 = System.currentTimeMillis();
        log.log(Level.INFO, "Reading descriptors ( ser ) " + (t2 - t1));
    }
}

