/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.io.Serializable;
import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitioningPolicy
implements Serializable {
    protected String name;

    public abstract List<Accessor> getConnectionsForQuery(AbstractSession var1, DatabaseQuery var2, AbstractRecord var3);

    public void initialize(AbstractSession session) {
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Accessor acquireAccessor(String poolName, ServerSession session, DatabaseQuery query) {
        ConnectionPool pool = session.getConnectionPool(poolName);
        if (pool == null) {
            throw QueryException.missingConnectionPool(poolName, query);
        }
        return pool.acquireConnection();
    }

    public Accessor getAccessor(String poolName, AbstractSession session, DatabaseQuery query) {
        Accessor accessor = null;
        if (session.isClientSession()) {
            ClientSession client = (ClientSession)session;
            if (client.isExclusiveIsolatedClientSession() && client.hasWriteConnection()) {
                accessor = client.getWriteConnection();
            } else {
                accessor = client.getWriteConnections().get(poolName);
                if (accessor == null) {
                    accessor = this.acquireAccessor(poolName, client.getParent(), query);
                    if (client.isExclusiveIsolatedClientSession() || session.isInTransaction()) {
                        client.addWriteConnection(poolName, accessor);
                    }
                }
            }
        } else if (session.isServerSession()) {
            accessor = this.acquireAccessor(poolName, (ServerSession)session, query);
        } else {
            throw QueryException.partitioningNotSupported(session, query);
        }
        return accessor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

