/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public abstract class DirectAccessor
extends MappingAccessor {
    private Boolean m_optional;
    private EnumeratedMetadata m_enumerated;
    private LobMetadata m_lob;
    private String m_fetch;
    private String m_convert;
    private TemporalMetadata m_temporal;

    protected DirectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected DirectAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        if (this.isAnnotationPresent(Lob.class)) {
            this.m_lob = new LobMetadata(this.getAnnotation(Lob.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Enumerated.class)) {
            this.m_enumerated = new EnumeratedMetadata(this.getAnnotation(Enumerated.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Temporal.class)) {
            this.m_temporal = new TemporalMetadata(this.getAnnotation(Temporal.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Convert.class)) {
            this.m_convert = (String)this.getAnnotation(Convert.class).getAttribute("value");
        }
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectAccessor) {
            DirectAccessor directAccessor = (DirectAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_optional, directAccessor.getOptional())) {
                return false;
            }
            if (!this.valuesMatch(this.m_enumerated, directAccessor.getEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_lob, directAccessor.getLob())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fetch, directAccessor.getFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_convert, directAccessor.getConvert())) {
                return false;
            }
            return this.valuesMatch(this.m_temporal, directAccessor.getTemporal());
        }
        return false;
    }

    public String getConvert() {
        return this.m_convert;
    }

    public abstract String getDefaultFetchType();

    public EnumeratedMetadata getEnumerated() {
        return this.m_enumerated;
    }

    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return this.getEnumerated();
    }

    public String getFetch() {
        return this.m_fetch;
    }

    protected Class getFieldClassification(Enum type2) {
        if (type2.name().equals(TemporalType.DATE.name())) {
            return Date.class;
        }
        if (type2.name().equals(TemporalType.TIME.name())) {
            return Time.class;
        }
        if (type2.name().equals(TemporalType.TIMESTAMP.name())) {
            return Timestamp.class;
        }
        return null;
    }

    public LobMetadata getLob() {
        return this.m_lob;
    }

    public LobMetadata getLob(boolean isForMapKey) {
        if (isForMapKey) {
            return super.getLob(isForMapKey);
        }
        return this.getLob();
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public TemporalMetadata getTemporal() {
        return this.m_temporal;
    }

    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return this.getTemporal();
    }

    protected boolean hasConvert(boolean isForMapKey) {
        return this.m_convert != null;
    }

    public boolean hasEnumerated(boolean isForMapKey) {
        return this.m_enumerated != null;
    }

    public boolean hasLob(boolean isForMapKey) {
        return this.m_lob != null;
    }

    public boolean hasTemporal(boolean isForMapKey) {
        return this.m_temporal != null;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_enumerated, accessibleObject);
        this.initXMLObject(this.m_lob, accessibleObject);
        this.initXMLObject(this.m_temporal, accessibleObject);
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    public void setConvert(String convert) {
        this.m_convert = convert;
    }

    public void setEnumerated(EnumeratedMetadata enumerated) {
        this.m_enumerated = enumerated;
    }

    public void setFetch(String fetch) {
        this.m_fetch = fetch;
    }

    public void setLob(LobMetadata lob) {
        this.m_lob = lob;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setTemporal(TemporalMetadata temporalType) {
        this.m_temporal = temporalType;
    }

    protected boolean usesIndirection() {
        String fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY.name());
    }
}

