/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.annotations.OrderCorrection;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OrderColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCollectionAccessor
extends DirectCollectionAccessor
implements MappedKeyMapAccessor {
    private ColumnMetadata m_column;
    private ColumnMetadata m_mapKeyColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides;
    private List<JoinColumnMetadata> m_mapKeyJoinColumns;
    private MapKeyMetadata m_mapKey;
    private MetadataClass m_targetClass;
    private MetadataClass m_mapKeyClass;
    private MetadataClass m_referenceClass;
    private OrderColumnMetadata m_orderColumn;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private String m_targetClassName;
    private String m_orderBy;
    private TemporalMetadata m_mapKeyTemporal;

    public ElementCollectionAccessor() {
        super("<element-collection>");
    }

    public ElementCollectionAccessor(MetadataAnnotation elementCollection, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(elementCollection, accessibleObject, classAccessor);
        this.m_targetClass = this.getMetadataClass((String)elementCollection.getAttribute("targetClass"));
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        this.m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Object attributeOverride : (Object[])this.getAnnotation(AttributeOverrides.class).getAttributeArray("value")) {
                this.addAttributeOverride(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.addAttributeOverride(new AttributeOverrideMetadata(this.getAnnotation(AttributeOverride.class), accessibleObject));
        }
        this.m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
        this.m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (MetadataAnnotation associationOverride : (MetadataAnnotation[])this.getAnnotation(AssociationOverrides.class).getAttribute("value")) {
                this.addAssociationOverride(new AssociationOverrideMetadata(associationOverride, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.addAssociationOverride(new AssociationOverrideMetadata(this.getAnnotation(AssociationOverride.class), accessibleObject));
        }
        if (this.isAnnotationPresent(Column.class)) {
            this.m_column = new ColumnMetadata(this.getAnnotation(Column.class), accessibleObject);
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.setCollectionTable(new CollectionTableMetadata(this.getAnnotation(CollectionTable.class), accessibleObject, true));
        }
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = (String)this.getAnnotation(OrderBy.class).getAttribute("value");
            if (this.m_orderBy == null) {
                this.m_orderBy = "";
            }
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = new MapKeyMetadata(this.getAnnotation(MapKey.class), accessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = this.getMetadataClass((String)this.getAnnotation(MapKeyClass.class).getAttribute("value"));
        }
        if (this.isAnnotationPresent(MapKeyEnumerated.class)) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata(this.getAnnotation(MapKeyEnumerated.class), accessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyTemporal.class)) {
            this.m_mapKeyTemporal = new TemporalMetadata(this.getAnnotation(MapKeyTemporal.class), accessibleObject);
        }
        this.m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
        if (this.isAnnotationPresent(MapKeyJoinColumns.class)) {
            for (Object jColumn : (Object[])this.getAnnotation(MapKeyJoinColumns.class).getAttributeArray("value")) {
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)jColumn, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(MapKeyJoinColumn.class)) {
            this.m_mapKeyJoinColumns.add(new JoinColumnMetadata(this.getAnnotation(MapKeyJoinColumn.class), accessibleObject));
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata(this.getAnnotation(MapKeyColumn.class), accessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = (String)this.getAnnotation(MapKeyConvert.class).getAttribute("value");
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            String correctionType = null;
            if (this.isAnnotationPresent(OrderCorrection.class)) {
                correctionType = this.getAnnotation(OrderCorrection.class).getAttribute("value").toString();
            }
            this.m_orderColumn = new OrderColumnMetadata(this.getAnnotation(OrderColumn.class), accessibleObject, correctionType);
        }
    }

    protected void addAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.getName().startsWith("key.")) {
            attributeOverride.setName(attributeOverride.getName().substring("key.".length()));
            this.m_mapKeyAttributeOverrides.add(attributeOverride);
        } else {
            if (attributeOverride.getName().startsWith("value.")) {
                attributeOverride.setName(attributeOverride.getName().substring("value.".length()));
            }
            this.m_attributeOverrides.add(attributeOverride);
        }
    }

    protected void addAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.getName().startsWith("key.")) {
            associationOverride.setName(associationOverride.getName().substring("key.".length()));
            this.m_mapKeyAssociationOverrides.add(associationOverride);
        } else {
            if (associationOverride.getName().startsWith("value.")) {
                associationOverride.setName(associationOverride.getName().substring("value.".length()));
            }
            this.m_associationOverrides.add(associationOverride);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ElementCollectionAccessor) {
            ElementCollectionAccessor elementCollectionAccessor = (ElementCollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_column, elementCollectionAccessor.getColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyColumn, elementCollectionAccessor.getMapKeyColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyEnumerated, elementCollectionAccessor.getMapKeyEnumerated())) {
                return false;
            }
            if (!this.valuesMatch(this.m_associationOverrides, elementCollectionAccessor.getAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAssociationOverrides, elementCollectionAccessor.getMapKeyAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeOverrides, elementCollectionAccessor.getAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyAttributeOverrides, elementCollectionAccessor.getMapKeyAttributeOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyJoinColumns, elementCollectionAccessor.getMapKeyJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKey, elementCollectionAccessor.getMapKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderColumn, elementCollectionAccessor.getOrderColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyConvert, elementCollectionAccessor.getMapKeyConvert())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mapKeyClassName, elementCollectionAccessor.getMapKeyClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_targetClassName, elementCollectionAccessor.getTargetClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_orderBy, elementCollectionAccessor.getOrderBy())) {
                return false;
            }
            return this.valuesMatch(this.m_mapKeyTemporal, elementCollectionAccessor.getMapKeyTemporal());
        }
        return false;
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return this.m_column == null ? super.getColumn(loggingCtx) : this.m_column;
        }
        return this.m_mapKeyColumn == null ? super.getColumn(loggingCtx) : this.m_mapKeyColumn;
    }

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getCollectionTable().getDatabaseTable();
    }

    public EmbeddableAccessor getEmbeddableAccessor() {
        return this.getProject().getEmbeddableAccessor(this.getReferenceClass());
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        if (isForMapKey) {
            return this.getMapKeyEnumerated();
        }
        return super.getEnumerated(isForMapKey);
    }

    @Override
    protected String getKeyConverter() {
        return this.m_mapKeyConvert;
    }

    @Override
    public MapKeyMetadata getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public MetadataClass getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    public OrderColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetClass();
            if (this.m_referenceClass == null || this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    if (this.getClassAccessor().isMappedSuperclass()) {
                        return this.getMetadataClass(Void.class);
                    }
                    throw ValidationException.unableToDetermineTargetClass(this.getAttributeName(), this.getJavaClass());
                }
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_default_element_collection_reference_class", this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        if (this.isDirectEmbeddableCollection()) {
            return this.getEmbeddableAccessor().getDescriptor();
        }
        return super.getReferenceDescriptor();
    }

    protected MetadataClass getTargetClass() {
        return this.m_targetClass;
    }

    protected String getTargetClassName() {
        return this.m_targetClassName;
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        if (isForMapKey) {
            return this.getMapKeyTemporal();
        }
        return super.getTemporal(isForMapKey);
    }

    @Override
    protected boolean hasConvert(boolean isForMapKey) {
        if (isForMapKey) {
            return this.m_mapKeyConvert != null;
        }
        return super.hasConvert(isForMapKey);
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        if (isForMapKey) {
            return this.m_mapKeyEnumerated != null;
        }
        return super.hasEnumerated(isForMapKey);
    }

    @Override
    public boolean hasLob(boolean isForMapKey) {
        if (isForMapKey) {
            return false;
        }
        return super.hasLob(isForMapKey);
    }

    @Override
    public boolean hasMapKey() {
        return this.m_mapKey != null;
    }

    @Override
    protected boolean hasMapKeyClass() {
        return this.m_mapKeyClass != null && !this.m_mapKeyClass.equals(Void.TYPE);
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        if (isForMapKey) {
            return this.m_mapKeyTemporal != null;
        }
        return super.hasTemporal(isForMapKey);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, accessibleObject);
        this.initXMLObject(this.m_column, accessibleObject);
        this.initXMLObject(this.m_mapKey, accessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, accessibleObject);
        this.initXMLObject(this.m_orderColumn, accessibleObject);
        this.m_targetClass = this.initXMLClassName(this.m_targetClassName);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public boolean isDirectEmbeddableCollection() {
        return this.getEmbeddableAccessor() != null;
    }

    @Override
    public void process() {
        if (this.isDirectEmbeddableCollection()) {
            this.processDirectEmbeddableCollectionMapping(this.getReferenceDescriptor());
        } else if (this.isValidDirectCollectionType()) {
            this.processDirectCollectionMapping();
        } else if (this.isValidDirectMapType()) {
            this.processDirectMapMapping();
        } else {
            throw ValidationException.invalidTargetClass(this.getAttributeName(), this.getJavaClass());
        }
        if (this.m_orderColumn != null) {
            this.m_orderColumn.process((CollectionMapping)this.getMapping(), this.getDescriptor());
        }
    }

    @Override
    protected void processCollectionTable(CollectionMapping mapping) {
        super.processCollectionTable(mapping);
        for (JoinColumnMetadata joinColumn : this.getJoinColumns(this.getCollectionTable().getJoinColumns(), this.getOwningDescriptor())) {
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), this.getOwningDescriptor(), "metadata_default_pk_column", mapping.isAggregateCollectionMapping());
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, this.getOwningDescriptor().getAlias() + "_" + this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column");
            fkField.setTable(this.getReferenceDatabaseTable());
            if (mapping.isDirectCollectionMapping()) {
                ((DirectCollectionMapping)mapping).addReferenceKeyField(fkField, pkField);
                continue;
            }
            ((AggregateCollectionMapping)mapping).addTargetForeignKeyField(fkField, pkField);
        }
    }

    protected void processDirectEmbeddableCollectionMapping(MetadataDescriptor referenceDescriptor) {
        AggregateCollectionMapping mapping = new AggregateCollectionMapping();
        this.process(mapping);
        this.processContainerPolicyAndIndirection(mapping);
        referenceDescriptor.setIsEmbeddableCollection();
        this.processMappingsFromEmbeddable(referenceDescriptor, null, mapping, this.getAttributeOverrides(this.m_attributeOverrides), this.getAssociationOverrides(this.m_associationOverrides), "");
    }

    protected void processMappingsFromEmbeddable(MetadataDescriptor embeddableDescriptor, AggregateObjectMapping nestedAggregateObjectMapping, EmbeddableMapping embeddableMapping, Map<String, AttributeOverrideMetadata> attributeOverrides, Map<String, AssociationOverrideMetadata> associationOverrides, String dotNotationName) {
        for (MappingAccessor mappingAccessor : embeddableDescriptor.getMappingAccessors()) {
            String overrideName;
            if (!mappingAccessor.isProcessed()) {
                mappingAccessor.process();
            }
            DatabaseMapping mapping = mappingAccessor.getMapping();
            String string = overrideName = dotNotationName.equals("") ? mapping.getAttributeName() : dotNotationName + "." + mapping.getAttributeName();
            if (mapping.isDirectToFieldMapping()) {
                DatabaseField overrideField;
                DirectToFieldMapping directMapping = (DirectToFieldMapping)mapping;
                if (attributeOverrides.containsKey(overrideName)) {
                    overrideField = attributeOverrides.get(overrideName).getOverrideField();
                } else {
                    overrideField = directMapping.getField().clone();
                    if (nestedAggregateObjectMapping != null && nestedAggregateObjectMapping.getAggregateToSourceFields().containsKey(overrideField.getName())) {
                        overrideField = nestedAggregateObjectMapping.getAggregateToSourceFields().get(overrideField.getName());
                    }
                }
                if (!overrideField.hasTableName()) {
                    overrideField.setTable(this.getReferenceDatabaseTable());
                }
                this.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, mappingAccessor);
                continue;
            }
            if (mapping.isOneToOneMapping()) {
                OneToOneMapping oneToOneMapping = (OneToOneMapping)mapping;
                if (oneToOneMapping.isForeignKeyRelationship()) {
                    AssociationOverrideMetadata associationOverride = associationOverrides.get(overrideName);
                    if (associationOverride == null) {
                        for (DatabaseField fkField : oneToOneMapping.getForeignKeyFields()) {
                            DatabaseField collectionTableField = fkField.clone();
                            collectionTableField.setTable(this.getReferenceDatabaseTable());
                            embeddableMapping.addFieldTranslation(collectionTableField, fkField.getName());
                        }
                        continue;
                    }
                    ((ObjectAccessor)mappingAccessor).processAssociationOverride(associationOverride, embeddableMapping, this.getReferenceDatabaseTable(), this.getDescriptor());
                    continue;
                }
                throw ValidationException.invalidEmbeddableClassForElementCollection(embeddableDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), mapping.getAttributeName());
            }
            if (mapping.isAggregateObjectMapping()) {
                MappingAccessor accessor = embeddableDescriptor.getMappingAccessor(mapping.getAttributeName());
                this.processMappingsFromEmbeddable(accessor.getReferenceDescriptor(), (AggregateObjectMapping)mapping, embeddableMapping, attributeOverrides, associationOverrides, overrideName);
                continue;
            }
            throw ValidationException.invalidEmbeddableClassForElementCollection(embeddableDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), mapping.getAttributeName());
        }
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setMapKey(MapKeyMetadata mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> mapKeyAssociationOverrides) {
        this.m_mapKeyAssociationOverrides = mapKeyAssociationOverrides;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> mapKeyAttributeOverrides) {
        this.m_mapKeyAttributeOverrides = mapKeyAttributeOverrides;
    }

    @Override
    public void setMapKeyClass(MetadataClass mapKeyClass) {
        this.m_mapKeyClass = mapKeyClass;
    }

    public void setMapKeyClassName(String mapKeyClassName) {
        this.m_mapKeyClassName = mapKeyClassName;
    }

    public void setMapKeyColumn(ColumnMetadata mapKeyColumn) {
        this.m_mapKeyColumn = mapKeyColumn;
    }

    public void setMapKeyConvert(String mapKeyConvert) {
        this.m_mapKeyConvert = mapKeyConvert;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata mapKeyEnumerated) {
        this.m_mapKeyEnumerated = mapKeyEnumerated;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> mapKeyJoinColumns) {
        this.m_mapKeyJoinColumns = mapKeyJoinColumns;
    }

    public void setMapKeyTemporal(TemporalMetadata mapKeyTemporal) {
        this.m_mapKeyTemporal = mapKeyTemporal;
    }

    public void setOrderBy(String orderBy) {
        this.m_orderBy = orderBy;
    }

    public void setOrderColumn(OrderColumnMetadata orderColumn) {
        this.m_orderColumn = orderColumn;
    }

    public void setTargetClassName(String targetClassName) {
        this.m_targetClassName = targetClassName;
    }
}

