/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeMetadata
extends ORMetadata {
    private boolean m_cascadeAll;
    private boolean m_cascadePersist;
    private boolean m_cascadeMerge;
    private boolean m_cascadeRemove;
    private boolean m_cascadeRefresh;
    private List<String> m_types;

    public CascadeMetadata() {
        super("<cascade>");
    }

    public CascadeMetadata(Object[] cascadeTypes, MetadataAccessibleObject accessibleObject) {
        super(null, accessibleObject);
        this.m_types = new ArrayList<String>();
        for (Object cascadeType : cascadeTypes) {
            this.m_types.add((String)cascadeType);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CascadeMetadata) {
            CascadeMetadata accessMethods = (CascadeMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_cascadeAll, accessMethods.isCascadeAll())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadePersist, accessMethods.isCascadePersist())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeMerge, accessMethods.isCascadeMerge())) {
                return false;
            }
            if (!this.valuesMatch(this.m_cascadeRemove, accessMethods.isCascadeRemove())) {
                return false;
            }
            return this.valuesMatch(this.m_cascadeRefresh, accessMethods.isCascadeRefresh());
        }
        return false;
    }

    public String getCascadeAll() {
        return null;
    }

    public String getCascadeMerge() {
        return null;
    }

    public String getCascadePersist() {
        return null;
    }

    public String getCascadeRefresh() {
        return null;
    }

    public String getCascadeRemove() {
        return null;
    }

    public List<String> getTypes() {
        if (this.m_types == null) {
            this.m_types = new ArrayList<String>();
            if (this.isCascadeAll()) {
                this.m_types.add(CascadeType.ALL.name());
            }
            if (this.isCascadePersist()) {
                this.m_types.add(CascadeType.PERSIST.name());
            }
            if (this.isCascadeMerge()) {
                this.m_types.add(CascadeType.MERGE.name());
            }
            if (this.isCascadeRemove()) {
                this.m_types.add(CascadeType.REMOVE.name());
            }
            if (this.isCascadeRefresh()) {
                this.m_types.add(CascadeType.REFRESH.name());
            }
        }
        return this.m_types;
    }

    public boolean isCascadeAll() {
        return this.m_cascadeAll;
    }

    public boolean isCascadeMerge() {
        return this.m_cascadeMerge;
    }

    public boolean isCascadePersist() {
        return this.m_cascadePersist;
    }

    public boolean isCascadeRefresh() {
        return this.m_cascadeRefresh;
    }

    public boolean isCascadeRemove() {
        return this.m_cascadeRemove;
    }

    public void setCascadeAll(String ignore) {
        this.m_cascadeAll = true;
    }

    public void setCascadeMerge(String ignore) {
        this.m_cascadeMerge = true;
    }

    public void setCascadePersist(String ignore) {
        this.m_cascadePersist = true;
    }

    public void setCascadeRefresh(String ignore) {
        this.m_cascadeRefresh = true;
    }

    public void setCascadeRemove(String ignore) {
        this.m_cascadeRemove = true;
    }
}

