/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMetadata
extends ORMetadata {
    private String name;
    private String schema;
    private String catalog;
    private String table;
    private Boolean unique;
    private List<String> columnNames = new ArrayList<String>();

    public IndexMetadata() {
        super("<index>");
    }

    protected IndexMetadata(String xmlElement) {
        super(xmlElement);
    }

    public IndexMetadata(MetadataAnnotation index, MetadataAccessibleObject accessibleObject) {
        super(index, accessibleObject);
        if (index != null) {
            this.name = (String)index.getAttribute("name");
            this.schema = (String)index.getAttribute("schema");
            this.catalog = (String)index.getAttribute("catalog");
            this.table = (String)index.getAttribute("table");
            this.unique = (Boolean)index.getAttribute("unique");
            for (Object uniqueConstraint : (Object[])index.getAttributeArray("columnNames")) {
                this.columnNames.add((String)uniqueConstraint);
            }
        }
    }

    @Override
    protected String getIdentifier() {
        return this.getName();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof IndexMetadata) {
            IndexMetadata table = (IndexMetadata)objectToCompare;
            if (!this.valuesMatch(this.name, table.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.schema, table.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.catalog, table.getCatalog())) {
                return false;
            }
            return ((Object)this.columnNames).equals(table.getColumnNames());
        }
        return false;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }
}

