/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.xml.sax.SAXParseException;

public class XMLPlatformException
extends EclipseLinkException {
    public static final int XML_PLATFORM_CLASS_NOT_FOUND = 27001;
    public static final int XML_PLATFORM_COULD_NOT_INSTANTIATE = 27002;
    public static final int XML_PLATFORM_COULD_NOT_CREATE_DOCUMENT = 27003;
    public static final int XML_PLATFORM_INVALID_XPATH = 27004;
    public static final int XML_PLATFORM_VALIDATION_EXCEPTION = 27005;
    public static final int XML_PLATFORM_PARSER_ERROR_RESOLVING_XML_SCHEMA = 27006;
    public static final int XML_PLATFORM_PARSE_EXCEPTION = 27101;
    public static final int XML_PLATFORM_PARSER_FILE_NOT_FOUND_EXCEPTION = 27102;
    public static final int XML_PLATFORM_PARSER_SAX_PARSE_EXCEPTION = 27103;
    public static final int XML_PLATFORM_TRANSFORM_EXCEPTION = 27201;
    public static final int XML_PLATFORM_INVALID_TYPE = 27202;

    protected XMLPlatformException(String message) {
        super(message);
    }

    public static XMLPlatformException xmlPlatformClassNotFound(String xmlPlatformClassName, Exception nestedException) {
        Object[] args = new Object[]{xmlPlatformClassName};
        int errorCode = 27001;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformCouldNotInstantiate(String xmlPlatformClassName, Exception nestedException) {
        Object[] args = new Object[]{xmlPlatformClassName};
        int errorCode = 27002;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformCouldNotCreateDocument(Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27003;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        return exception;
    }

    public static XMLPlatformException xmlPlatformInvalidXPath(Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27004;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformValidationException(Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27005;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformValidationException(String errorMessage) {
        int errorCode = 27005;
        XMLPlatformException exception = new XMLPlatformException(errorMessage);
        exception.setErrorCode(errorCode);
        return exception;
    }

    public static XMLPlatformException xmlPlatformInvalidTypeException(int type2) {
        Object[] args = new Object[]{type2};
        int errorCode = 27202;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        return exception;
    }

    public static XMLPlatformException xmlPlatformParseException(Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27101;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformFileNotFoundException(File file, IOException nestedException) {
        Object[] args = new Object[]{file.getAbsolutePath()};
        int errorCode = 27102;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformSAXParseException(SAXParseException nestedException) {
        Object[] args = new Object[]{nestedException.getLineNumber(), nestedException.getSystemId(), nestedException.getMessage()};
        int errorCode = 27103;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformErrorResolvingXMLSchema(URL url, Exception nestedException) {
        Object[] args = new Object[]{url};
        int errorCode = 27006;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformErrorResolvingXMLSchemas(Object[] schemas, Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27006;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }

    public static XMLPlatformException xmlPlatformTransformException(Exception nestedException) {
        Object[] args = new Object[]{};
        int errorCode = 27201;
        XMLPlatformException exception = new XMLPlatformException(ExceptionMessageGenerator.buildMessage(XMLPlatformException.class, errorCode, args));
        exception.setErrorCode(errorCode);
        exception.setInternalException(nestedException);
        return exception;
    }
}

