/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class CursorPolicy
extends ContainerPolicy {
    protected int pageSize;
    protected ReadQuery query;

    public CursorPolicy() {
        this.setPageSize(10);
    }

    public CursorPolicy(ReadQuery query, int pageSize) {
        this.setQuery(query);
        this.setPageSize(pageSize);
    }

    public ContainerPolicy clone(ReadQuery query) {
        CursorPolicy clone = (CursorPolicy)super.clone(query);
        clone.setQuery(query);
        return clone;
    }

    public CollectionChangeEvent createChangeEvent(Object collectionOwner, String propertyName, Object collectionChanged, Object elementChanged, int changeType, Integer index) {
        throw ValidationException.operationNotSupported("createChangeEvent");
    }

    public abstract Object execute();

    public int getPageSize() {
        return this.pageSize;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    public boolean hasNext(Object iterator) {
        return ((Enumeration)iterator).hasMoreElements();
    }

    public boolean isCursorPolicy() {
        return true;
    }

    public Object iteratorFor(Object container) {
        return container;
    }

    protected Object next(Object iterator) {
        return ((Enumeration)iterator).nextElement();
    }

    public boolean overridesRead() {
        return true;
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        super.prepare(query, session);
        this.setQuery((ReadQuery)query);
        ClassDescriptor descriptor = query.getDescriptor();
        if (descriptor != null) {
            if (descriptor.isDescriptorForInterface()) {
                throw QueryException.noCursorSupport(query);
            }
            if (query.isObjectLevelReadQuery() && descriptor.hasInheritance()) {
                ((ObjectLevelReadQuery)query).setShouldOuterJoinSubclasses(true);
            }
        }
        query.getQueryMechanism().prepareCursorSelectAllRows();
    }

    public abstract Object remoteExecute();

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setQuery(ReadQuery query) {
        this.query = query;
    }

    public int sizeFor(Object container) {
        return ((Cursor)container).size();
    }

    protected Object toStringInfo() {
        return "page size = " + this.getPageSize();
    }
}

