/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;

public class SequenceObjectDefinition
extends SequenceDefinition {
    public SequenceObjectDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            int startWith = this.sequence.getInitialValue() + this.sequence.getPreallocationSize() - 1;
            session.getPlatform().buildSequenceObjectCreationWriter(writer, this.getFullName(), this.sequence.getPreallocationSize(), startWith);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) {
        try {
            session.getPlatform().buildSequenceObjectDeletionWriter(writer, this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildAlterIncrementWriter(AbstractSession session, Writer writer) {
        try {
            session.getPlatform().buildSequenceObjectAlterIncrementWriter(writer, this.getFullName(), this.sequence.getPreallocationSize());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        boolean isConnected = this.sequence.isConnected();
        if (!isConnected) {
            this.sequence.onConnect(session.getPlatform());
        }
        try {
            boolean bl;
            try {
                if (this.sequence.shouldUsePreallocation()) {
                    this.sequence.getGeneratedVector(null, session);
                } else {
                    this.sequence.getGeneratedValue(null, session);
                }
                bl = true;
                Object var6_6 = null;
                if (isConnected) return bl;
            }
            catch (DatabaseException databaseException) {
                boolean bl2 = false;
                Object var6_7 = null;
                if (isConnected) return bl2;
                this.sequence.onDisconnect(session.getPlatform());
                return bl2;
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() != 7027) throw validationException;
                boolean bl3 = true;
                Object var6_8 = null;
                if (isConnected) return bl3;
                this.sequence.onDisconnect(session.getPlatform());
                return bl3;
            }
            this.sequence.onDisconnect(session.getPlatform());
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (isConnected) throw throwable;
            this.sequence.onDisconnect(session.getPlatform());
            throw throwable;
        }
    }

    public boolean isAlterSupported(AbstractSession session) {
        return session.getPlatform().isAlterSequenceObjectSupported();
    }

    public void alterOnDatabase(AbstractSession session) throws EclipseLinkException {
        session.executeNonSelectingCall(new SQLCall(this.buildAlterIncrementWriter(session, new StringWriter()).toString()));
    }

    public void alterIncrement(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.alterOnDatabase(session);
        } else {
            this.buildAlterIncrementWriter(session, schemaWriter);
        }
    }

    public String getFullName() {
        return this.sequence.getQualified(this.getName());
    }
}

