/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Util.class);

    private Util() {
    }

    public static String getResourceName(UriInfo uriInfo) {
        return Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uriInfo.getPath(), '/')));
    }

    public static String getParentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getParentName(uriInfo.getPath());
    }

    public static String getGrandparentName(UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        return Util.getGrandparentName(uriInfo.getPath());
    }

    public static String getName(String typeName) {
        return Util.getName(typeName, '.');
    }

    public static String getName(String typeName, char delimiter) {
        int index;
        if (typeName == null || "".equals(typeName)) {
            return typeName;
        }
        if (typeName.length() - 1 == typeName.lastIndexOf(delimiter)) {
            typeName = typeName.substring(0, typeName.length() - 1);
        }
        if (typeName != null && typeName.length() > 0 && (index = typeName.lastIndexOf(delimiter)) != -1) {
            return typeName.substring(index + 1);
        }
        return typeName;
    }

    public static String getParentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getName(url, '/');
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static String getGrandparentName(String url) {
        if (url == null || "".equals(url)) {
            return url;
        }
        String name = Util.getParentName(url);
        int nameIndex = url.indexOf(name, url.indexOf(":") + 1);
        return Util.getName(url.substring(0, nameIndex - 1), '/');
    }

    public static void main(String ... args) {
        String url = "http://localhost:4848/management/domain/configs/config/server-config/java-config/generate-jvm-report";
        String gp = Util.getGrandparentName(url);
        System.out.println("gp = " + gp);
    }

    public static String eleminateHypen(String string) {
        if (string != null && string.length() > 0) {
            int index = string.indexOf(45);
            while (index != -1) {
                string = index == 0 ? string.substring(1) : (index == string.length() - 1 ? string.substring(0, string.length() - 1) : string.substring(0, index) + Util.upperCaseFirstLetter(string.substring(index + 1)));
                index = string.indexOf(45);
            }
        }
        return string;
    }

    public static String decode(String string) {
        String ret = string;
        try {
            ret = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
    }

    protected static String getHtml(String message, UriInfo uriInfo, boolean delete) {
        String result = ProviderUtil.getHtmlHeader(uriInfo.getBaseUri().toASCIIString());
        String uri = uriInfo.getAbsolutePath().toString();
        if (delete) {
            uri = uri + "/..";
        }
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String parentName = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getParentName(uri)));
        result = result + "<h1>" + name + "</h1>";
        result = result + message;
        result = result + "<a href=\"" + uri + "\">Back</a>";
        result = result + "</body></html>";
        return result;
    }

    public static String methodNameFromDtdName(String elementName, String prefix) {
        return Util.methodNameFromBeanName(Util.eleminateHypen(elementName), prefix);
    }

    public static String methodNameFromBeanName(String elementName, String prefix) {
        if (null == elementName || null == prefix || prefix.length() <= 0) {
            return elementName;
        }
        String methodName = Util.upperCaseFirstLetter(elementName);
        methodName = prefix + methodName;
        return methodName;
    }

    public static ActionReporter applyChanges(Map<String, String> data, UriInfo uriInfo, Habitat habitat) {
        List<PathSegment> pathSegments = uriInfo.getPathSegments();
        PathSegment lastSegment = pathSegments.get(pathSegments.size() - 1);
        if (lastSegment.getPath().isEmpty()) {
            pathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        }
        List<PathSegment> candidatePathSegment = null;
        candidatePathSegment = pathSegments.size() != 1 ? pathSegments.subList(1, pathSegments.size()) : pathSegments;
        StringBuilder sb = new StringBuilder();
        for (PathSegment pathSegment : candidatePathSegment) {
            sb.append(pathSegment.getPath());
            sb.append('.');
        }
        String setBasePath = sb.toString();
        ParameterMap parameters = new ParameterMap();
        Map<String, String> currentValues = Util.getCurrentValues(setBasePath.toString(), habitat);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String currentValue = currentValues.get(setBasePath + entry.getKey());
            if (currentValue != null && currentValue.equals(entry.getValue())) continue;
            parameters.add("DEFAULT", setBasePath + entry.getKey() + "=" + entry.getValue());
        }
        if (!parameters.entrySet().isEmpty()) {
            return ResourceUtil.runCommand("set", parameters, habitat, "");
        }
        return new RestActionReporter();
    }

    private static Map<String, String> getCurrentValues(String basePath, Habitat habitat) {
        HashMap<String, String> values = new HashMap<String, String>();
        final String path = basePath.endsWith(".") ? basePath.substring(0, basePath.length() - 1) : basePath;
        RestActionReporter gr = ResourceUtil.runCommand("get", new ParameterMap(){
            {
                this.add("DEFAULT", path);
            }
        }, habitat, "");
        ActionReport.MessagePart top = gr.getTopMessagePart();
        for (ActionReport.MessagePart child : top.getChildren()) {
            String message = child.getMessage();
            if (!message.contains("=")) continue;
            String[] parts = message.split("=");
            values.put(parts[0], parts.length > 1 ? parts[1] : "");
        }
        return values;
    }
}

