/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.config.support.GlassFishConfigBean;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishDocument
extends DomDocument<GlassFishConfigBean> {
    Logger logger = LogDomains.getLogger(GlassFishDocument.class, "javax.enterprise.system.core");

    public GlassFishDocument(final Habitat habitat, ExecutorService executor) {
        super(habitat);
        ExistingSingletonInhabitant<ExecutorService> executorInhab = new ExistingSingletonInhabitant<ExecutorService>(executor);
        habitat.addIndex(executorInhab, ExecutorService.class.getName(), "transactions-executor");
        habitat.addIndex(new ExistingSingletonInhabitant<GlassFishDocument>(this), DomDocument.class.getName(), null);
        final GlassFishDocument doc = this;
        habitat.getComponent(Transactions.class).addTransactionsListener(new TransactionListener(){

            @Override
            public void transactionCommited(List<PropertyChangeEvent> changes) {
                for (ConfigurationPersistence pers : habitat.getAllByContract(ConfigurationPersistence.class)) {
                    try {
                        if (doc.getRoot().getProxyType().equals(Domain.class)) {
                            Dom domainRoot = doc.getRoot();
                            domainRoot.attribute("version", Version.getBuildVersion());
                        }
                        pers.save(doc);
                    }
                    catch (IOException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "GlassFishDocument.IOException", new String[]{e.getMessage()});
                        GlassFishDocument.this.logger.log(Level.FINE, e.getMessage(), e);
                    }
                    catch (XMLStreamException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "GlassFishDocument.XMLException", new String[]{e.getMessage()});
                        GlassFishDocument.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }

            @Override
            public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
            }
        });
    }

    public GlassFishConfigBean make(Habitat habitat, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
        return new GlassFishConfigBean(habitat, (DomDocument)this, dom, configModel, xmlStreamReader);
    }
}

