/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.connectors.admin.cli.ConnectorSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-connector-security-map")
@Scoped(value=PerLookup.class)
@I18n(value="delete.connector.security.map")
public class DeleteConnectorSecurityMap
extends ConnectorSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorSecurityMap.class);
    @Param(name="poolname")
    private String poolName;
    @Param(name="mapname", primary=true)
    private String mapName;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Inject
    private Domain domain;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Collection<ConnectorConnectionPool> ccPools = this.domain.getResources().getResources(ConnectorConnectionPool.class);
        if (!this.isResourceExists(ccPools)) {
            report.setMessage(localStrings.getLocalString("delete.connector.security.map.notFound", "A security map named {0} for connector connection pool {1} does not exist.", this.mapName, this.poolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConnectorConnectionPool pool = this.getPool(this.poolName, ccPools);
            ConfigSupport.apply(new SingleConfigCode<ConnectorConnectionPool>(){

                @Override
                public Object run(ConnectorConnectionPool param) throws PropertyVetoException, TransactionFailure {
                    List<SecurityMap> securityMaps = param.getSecurityMap();
                    if (securityMaps != null) {
                        for (SecurityMap map : securityMaps) {
                            if (!map.getName().equals(DeleteConnectorSecurityMap.this.mapName)) continue;
                            param.getSecurityMap().remove(map);
                            break;
                        }
                    }
                    return param;
                }
            }, pool);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(DeleteConnectorSecurityMap.class.getName()).log(Level.SEVERE, "delete-connector-security-map failed", tfe);
            report.setMessage(localStrings.getLocalString("delete.connector.security.map.fail", "Unable to delete security map {0} for connector connection pool {1}", this.mapName, this.poolName) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists(Collection<ConnectorConnectionPool> ccPools) {
        for (ConnectorConnectionPool resource : ccPools) {
            if (!resource.getName().equals(this.poolName)) continue;
            for (SecurityMap sm : resource.getSecurityMap()) {
                if (!sm.getName().equals(this.mapName)) continue;
                return true;
            }
        }
        return false;
    }
}

