/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_validateRemoteDirDeployment")
@Supplemental(value="deploy", on=Supplemental.Timing.Before, ifFailure=FailurePolicy.Error)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class ValidateRemoteDirDeploymentCommand
extends DeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ValidateRemoteDirDeploymentCommand.class);
    @Inject
    private ArchiveFactory archiveFactory;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ReadableArchive archive = this.archive(logger, report);
        if (archive == null) {
            this.reportSuccess(report);
            return;
        }
        File source = new File(archive.getURI().getSchemeSpecificPart());
        try {
            archive.close();
        }
        catch (IOException ex) {
            report.failure(logger, ex.getLocalizedMessage(), ex);
        }
        if (!source.isDirectory()) {
            this.reportSuccess(report);
            return;
        }
        TargetInfo targetInfo = new TargetInfo(this.target);
        if (!targetInfo.containsNonDAS()) {
            this.reportSuccess(report);
            return;
        }
        long checksum = DeploymentUtils.checksum(source);
        ParameterMap paramMap = new ParameterMap();
        paramMap.add("checksum", Long.toString(checksum));
        paramMap.add("DEFAULT", this.path.toURI().getSchemeSpecificPart());
        ActionReport.ExitCode replicateResult = ClusterOperationUtil.replicateCommand("_instanceValidateRemoteDirDeployment", FailurePolicy.Error, FailurePolicy.Ignore, targetInfo.targetNames(), context, paramMap, this.habitat);
        report.setActionExitCode(replicateResult);
    }

    private ReadableArchive archive(Logger logger, ActionReport report) {
        try {
            return this.archiveFactory.openArchive(this.path, this);
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", this.path.getAbsolutePath());
            if (this.logReportedErrors.booleanValue()) {
                report.failure(logger, msg, e);
            } else {
                report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            return null;
        }
    }

    private void reportSuccess(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TargetInfo {
        private boolean containsNonDAS = false;
        private final List<String> targetNames = new ArrayList<String>();

        private TargetInfo(String targetExpr) {
            for (String targetName : targetExpr.split(",")) {
                this.targetNames.add(targetName);
                this.containsNonDAS |= !DeploymentUtils.isDASTarget(targetName);
            }
        }

        private boolean containsNonDAS() {
            return this.containsNonDAS;
        }

        private List<String> targetNames() {
            return this.targetNames;
        }
    }
}

