/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security;

import com.sun.ejb.EjbInvocation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.glassfish.ejb.security.application.EJBSecurityManager;

public class EJBSecurityUtil {
    public static Object invoke(Method beanClassMethod, EjbInvocation inv, Object o, Object[] oa, EJBSecurityManager ejbSecMgr) throws Throwable {
        final Method meth = beanClassMethod;
        final Object obj = o;
        final Object[] objArr = oa;
        Object ret = null;
        if (inv.isLocal && ejbSecMgr.getUsesCallerIdentity() || System.getSecurityManager() == null) {
            ret = ejbSecMgr.runMethod(meth, obj, objArr);
        } else {
            PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return meth.invoke(obj, objArr);
                }
            };
            try {
                ret = ejbSecMgr.doAsPrivileged(pea);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                throw cause;
            }
        }
        return ret;
    }

    public static Object runMethod(Method beanClassMethod, EjbInvocation inv, Object o, Object[] oa, EJBSecurityManager mgr) throws Throwable {
        Object ret;
        final Method meth = beanClassMethod;
        final Object obj = o;
        final Object[] objArr = oa;
        if (mgr == null) {
            throw new SecurityException("SecurityManager not set");
        }
        if (inv.isLocal && mgr.getUsesCallerIdentity() || System.getSecurityManager() == null) {
            ret = mgr.runMethod(meth, obj, objArr);
        } else {
            try {
                PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return meth.invoke(obj, objArr);
                    }
                };
                ret = mgr.doAsPrivileged(pea);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof InvocationTargetException) {
                    cause = ((InvocationTargetException)cause).getCause();
                }
                throw cause;
            }
        }
        return ret;
    }
}

