/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridPersistenceProviderResolver
implements PersistenceProviderResolver {
    private final Map<ClassLoader, List<String>> cl2ProviderNames = Collections.synchronizedMap(new WeakHashMap());
    private final boolean cachingEnabled;
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public HybridPersistenceProviderResolver(boolean cachingEnabled) {
        this.logger.logp(Level.FINE, "HybridPersistenceProviderResolver", "HybridPersistenceProviderResolver", "cachingEnabled = {0}", new Object[]{cachingEnabled});
        this.cachingEnabled = cachingEnabled;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.getPersistenceProviders(cl);
    }

    private List<PersistenceProvider> getPersistenceProviders(ClassLoader cl) {
        List<PersistenceProvider> providers;
        if (this.isCachingEnabled()) {
            providers = this.readCache(cl);
            if (providers == null) {
                providers = this.discoverPersistenceProviders(cl);
                this.populateCache(cl, providers);
            }
        } else {
            providers = this.discoverPersistenceProviders(cl);
        }
        return providers;
    }

    private void populateCache(ClassLoader cl, List<PersistenceProvider> providers) {
        ArrayList<String> providerNames = new ArrayList<String>(providers.size());
        providerNames.addAll(this.convert(providers));
        this.cl2ProviderNames.put(cl, providerNames);
    }

    private List<PersistenceProvider> readCache(ClassLoader cl) {
        List<String> providerNames = this.cl2ProviderNames.get(cl);
        return providerNames != null ? this.convert(providerNames, cl) : null;
    }

    private List<String> convert(Iterable<PersistenceProvider> providers) {
        ArrayList<String> result = new ArrayList<String>();
        for (PersistenceProvider p : providers) {
            result.add(p.getClass().getName());
        }
        return result;
    }

    private List<PersistenceProvider> convert(Iterable<String> providerNames, ClassLoader cl) {
        ArrayList<PersistenceProvider> result = new ArrayList<PersistenceProvider>();
        for (String name : providerNames) {
            try {
                result.add((PersistenceProvider)cl.loadClass(name).newInstance());
            }
            catch (Exception e) {
                this.logger.logp(Level.WARNING, "HybridPersistenceProviderResolver", "convert", "Exception trying to instantiate cached provider by name " + name, e);
            }
        }
        return result;
    }

    private List<PersistenceProvider> discoverPersistenceProviders(ClassLoader cl) {
        ArrayList<PersistenceProvider> result = new ArrayList<PersistenceProvider>();
        if (cl != null) {
            Iterator<PersistenceProvider> services = ServiceLoader.load(PersistenceProvider.class, cl).iterator();
            while (services.hasNext()) {
                try {
                    PersistenceProvider p = services.next();
                    result.add(p);
                }
                catch (ServiceConfigurationError e) {
                    this.logger.logp(Level.FINE, "HybridPersistenceProviderResolver", "getPersistenceProviders", "Exception while discovering providers for class loader " + cl, e);
                }
            }
        }
        if (result.isEmpty()) {
            result.addAll(this.discoverOSGiProviders());
        }
        return result;
    }

    private List<PersistenceProvider> discoverOSGiProviders() {
        ArrayList<PersistenceProvider> result = new ArrayList<PersistenceProvider>();
        for (PersistenceProvider p : org.glassfish.hk2.osgiresourcelocator.ServiceLoader.lookupProviderInstances(PersistenceProvider.class)) {
            result.add(p);
        }
        return result;
    }

    @Override
    public synchronized void clearCachedProviders() {
        if (this.isCachingEnabled()) {
            this.cl2ProviderNames.clear();
        }
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public String toString() {
        return super.toString() + "[CachingEnabled = " + this.isCachingEnabled() + "]";
    }
}

