/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijta;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.glassfish.osgijavaeebase.Extender;
import org.osgi.framework.BundleContext;

public class JTAExtender
implements Extender {
    private final BundleContext ctx;

    public JTAExtender(BundleContext ctx) {
        this.ctx = ctx;
    }

    public void start() {
        Class[] classes = new Class[]{UserTransaction.class, TransactionManager.class, TransactionSynchronizationRegistry.class};
        String[] jndiNames = new String[]{"UserTransaction", "java:appserver/TransactionManager", "java:appserver/TransactionSynchronizationRegistry"};
        for (int i = 0; i < 3; ++i) {
            this.registerProxy(classes[i], jndiNames[i]);
        }
    }

    private void registerProxy(Class clazz, String jndiName) {
        MyInvocationHandler ih = new MyInvocationHandler(clazz, jndiName);
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)ih);
        this.ctx.registerService(clazz.getName(), proxy, null);
    }

    public void stop() {
    }

    private InitialContext getInitialContext() throws NamingException {
        return new InitialContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyInvocationHandler
    implements InvocationHandler {
        private Class<?> clazz;
        private String jndiName;

        private MyInvocationHandler(Class<?> clazz, String jndiName) {
            this.clazz = clazz;
            this.jndiName = jndiName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                InitialContext ic = JTAExtender.this.getInitialContext();
                Object target = ic.lookup(this.jndiName);
                try {
                    return method.invoke(target, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("JTA Service is not available.", e);
            }
        }
    }
}

