/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.common.database;

import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.persistence.common.I18NHelper;

public class PropertyHelper {
    private static final Logger logger = LogDomains.getLogger(PropertyHelper.class, "javax.enterprise.resource.jdo");
    private static final ResourceBundle messages = I18NHelper.loadBundle("org.glassfish.persistence.common.LogStrings", PropertyHelper.class.getClassLoader());

    public static void loadFromResource(Properties properties, String resourceName, ClassLoader classLoader) throws IOException {
        PropertyHelper.load(properties, resourceName, false, classLoader);
    }

    public static void loadFromFile(Properties properties, String fileName) throws IOException {
        PropertyHelper.load(properties, fileName, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties properties, String resourceName, boolean loadFromFile, ClassLoader classLoader) throws IOException {
        BufferedInputStream bin = null;
        InputStream in = null;
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            Object[] items = new Object[]{resourceName, loadFromFile};
            logger.log(Level.FINE, I18NHelper.getMessage(messages, "database.PropertyHelper.load", items));
        }
        InputStream inputStream = in = loadFromFile ? PropertyHelper.openFileInputStream(resourceName) : PropertyHelper.openResourceInputStream(resourceName, classLoader);
        if (in == null) {
            throw new IOException(I18NHelper.getMessage(messages, "database.PropertyHelper.failedToLoadResource", resourceName));
        }
        bin = new BufferedInputStream(in);
        try {
            properties.load(bin);
        }
        finally {
            try {
                ((InputStream)bin).close();
            }
            catch (Exception e) {}
        }
    }

    private static InputStream openFileInputStream(final String fileName) throws FileNotFoundException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(fileName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static InputStream openResourceInputStream(final String resourceName, final ClassLoader classLoader) throws FileNotFoundException {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(resourceName);
                }
                return ClassLoader.getSystemResourceAsStream(resourceName);
            }
        });
    }
}

