/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resource.common;

import org.glassfish.resource.common.GenericResourceInfo;

public class PoolInfo
implements GenericResourceInfo {
    private String name;
    private String applicationName = null;
    private String moduleName = null;

    public PoolInfo(String name) {
        this.name = name;
    }

    public PoolInfo(String name, String applicationName) {
        this.name = name;
        this.applicationName = applicationName;
    }

    public PoolInfo(String name, String applicationName, String moduleName) {
        this.name = name;
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String toString() {
        if (this.applicationName != null && this.moduleName != null) {
            return "{ PoolInfo : (name=" + this.name + "), (applicationName=" + this.applicationName + "), (moduleName=" + this.moduleName + ")}";
        }
        if (this.applicationName != null) {
            return "{ PoolInfo : (name=" + this.name + "), (applicationName=" + this.applicationName + ") }";
        }
        return this.name;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o == this) {
            result = true;
        } else if (o instanceof PoolInfo) {
            PoolInfo poolInfo = (PoolInfo)o;
            boolean poolNameEqual = poolInfo.getName().equals(this.name);
            boolean appNameEqual = false;
            if (this.applicationName == null && poolInfo.getApplicationName() == null) {
                appNameEqual = true;
            } else if (this.applicationName != null && poolInfo.getApplicationName() != null && this.applicationName.equals(poolInfo.getApplicationName())) {
                appNameEqual = true;
            }
            boolean moduleNameEqual = false;
            if (this.moduleName == null && poolInfo.getModuleName() == null) {
                moduleNameEqual = true;
            } else if (this.moduleName != null && poolInfo.getModuleName() != null && this.moduleName.equals(poolInfo.getModuleName())) {
                moduleNameEqual = true;
            }
            result = poolNameEqual && appNameEqual && moduleNameEqual;
        }
        return result;
    }

    public int hashCode() {
        int result = 67;
        if (this.name != null) {
            result = 67 * result + this.name.hashCode();
        }
        if (this.applicationName != null) {
            result = 67 * result + this.applicationName.hashCode();
        }
        if (this.moduleName != null) {
            result = 67 * result + this.moduleName.hashCode();
        }
        return result;
    }
}

