/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.hibernate.validator.cfg.CascadeDef;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstraintsForType {
    private static final String EMPTY_PROPERTY = "";
    private final ConstraintMapping mapping;
    private final Class<?> beanClass;
    private String property;
    private ElementType elementType;

    public ConstraintsForType(Class<?> beanClass, ConstraintMapping mapping) {
        this(beanClass, EMPTY_PROPERTY, ElementType.TYPE, mapping);
    }

    public ConstraintsForType(Class<?> beanClass, String property, ElementType type2, ConstraintMapping mapping) {
        this.beanClass = beanClass;
        this.mapping = mapping;
        this.property = property;
        this.elementType = type2;
    }

    public <A extends Annotation, T extends ConstraintDef<A>> T constraint(Class<T> definition) {
        Constructor<T> constructor = ReflectionHelper.getConstructor(definition, Class.class, String.class, ElementType.class, ConstraintMapping.class);
        ConstraintDef constraintDefinition = (ConstraintDef)ReflectionHelper.newConstructorInstance(constructor, new Object[]{this.beanClass, this.property, this.elementType, this.mapping});
        this.mapping.addConstraintConfig(constraintDefinition);
        return (T)constraintDefinition;
    }

    public ConstraintsForType property(String property, ElementType type2) {
        return new ConstraintsForType(this.beanClass, property, type2, this.mapping);
    }

    public ConstraintsForType valid(String property, ElementType type2) {
        this.mapping.addCascadeConfig(new CascadeDef(this.beanClass, property, type2));
        return this;
    }

    public ConstraintsForType defaultGroupSequence(Class<?> ... defaultGroupSequence) {
        this.mapping.addDefaultGroupSequence(this.beanClass, Arrays.asList(defaultGroupSequence));
        return this;
    }

    public ConstraintsForType type(Class<?> type2) {
        return new ConstraintsForType(type2, this.mapping);
    }
}

