/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.engine.ConstraintViolationImpl;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree<A extends Annotation> {
    private static final Logger log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptorImpl<A> descriptor;
    private final Map<Type, Class<? extends ConstraintValidator<?, ?>>> validatorTypes;
    private final Map<ValidatorCacheKey, ConstraintValidator<A, ?>> constraintValidatorCache;

    public ConstraintTree(ConstraintDescriptorImpl<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptorImpl<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        this.constraintValidatorCache = new ConcurrentHashMap();
        HashSet<ConstraintDescriptorImpl> composingConstraints = new HashSet<ConstraintDescriptorImpl>();
        for (ConstraintDescriptor<?> composingConstraint : descriptor.getComposingConstraints()) {
            composingConstraints.add((ConstraintDescriptorImpl)composingConstraint);
        }
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptorImpl composingDescriptor : composingConstraints) {
            ConstraintTree treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
        this.validatorTypes = ValidatorTypeHelper.getValidatorsTypes(descriptor.getConstraintValidatorClasses());
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptorImpl<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public ConstraintDescriptorImpl<A> getDescriptor() {
        return this.descriptor;
    }

    public <T, U, V> void validateConstraints(Type type2, ValidationContext<T> executionContext, ValueContext<U, V> valueContext, List<ConstraintViolation<T>> constraintViolations) {
        for (ConstraintTree<?> tree : this.getChildren()) {
            ArrayList<ConstraintViolation<T>> tmpViolations = new ArrayList<ConstraintViolation<T>>();
            tree.validateConstraints(type2, executionContext, valueContext, tmpViolations);
            constraintViolations.addAll(tmpViolations);
        }
        ConstraintValidatorContextImpl constraintValidatorContext = new ConstraintValidatorContextImpl(valueContext.getPropertyPath(), this.descriptor);
        if (constraintViolations.size() > 0 && this.reportAsSingleViolation()) {
            constraintViolations.clear();
            String message = (String)this.getDescriptor().getAttributes().get("message");
            MessageAndPath messageAndPath = new MessageAndPath(message, valueContext.getPropertyPath());
            ConstraintViolationImpl<T> violation = executionContext.createConstraintViolation(valueContext, messageAndPath, this.descriptor);
            constraintViolations.add(violation);
        }
        if (!this.descriptor.getConstraintValidatorClasses().isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Validating value {} against constraint defined by {}", valueContext.getCurrentValidatedValue(), this.descriptor);
            }
            ConstraintValidator<A, V> validator = this.getInitializedValidator(type2, executionContext.getConstraintValidatorFactory());
            this.validateSingleConstraint(executionContext, valueContext, constraintViolations, constraintValidatorContext, validator);
        }
    }

    private <T, U, V> void validateSingleConstraint(ValidationContext<T> executionContext, ValueContext<U, V> valueContext, List<ConstraintViolation<T>> constraintViolations, ConstraintValidatorContextImpl constraintValidatorContext, ConstraintValidator<A, V> validator) {
        boolean isValid;
        try {
            isValid = validator.isValid(valueContext.getCurrentValidatedValue(), constraintValidatorContext);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unexpected exception during isValid call", e);
        }
        if (!isValid) {
            constraintViolations.addAll(executionContext.createConstraintViolations(valueContext, constraintValidatorContext));
        }
    }

    private boolean reportAsSingleViolation() {
        return this.getDescriptor().isReportAsSingleViolation();
    }

    private <V> ConstraintValidator<A, V> getInitializedValidator(Type type2, ConstraintValidatorFactory constraintFactory) {
        ConstraintValidator<A, Object> constraintValidator;
        Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(type2);
        if (!(constraintFactory instanceof ConstraintValidatorFactoryImpl)) {
            return this.createAndInitializeValidator(constraintFactory, validatorClass);
        }
        ValidatorCacheKey key = new ValidatorCacheKey(constraintFactory, validatorClass);
        if (!this.constraintValidatorCache.containsKey(key)) {
            constraintValidator = this.createAndInitializeValidator(constraintFactory, validatorClass);
            this.constraintValidatorCache.put(key, constraintValidator);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Constraint validator {} found in cache");
            }
            constraintValidator = this.constraintValidatorCache.get(key);
        }
        return constraintValidator;
    }

    private <V> ConstraintValidator<A, V> createAndInitializeValidator(ConstraintValidatorFactory constraintFactory, Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        ConstraintValidator<?, ?> constraintValidator = constraintFactory.getInstance(validatorClass);
        if (constraintValidator == null) {
            throw new ValidationException("Constraint factory returned null when trying to create instance of " + validatorClass.getName());
        }
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Type type2) {
        List<Type> suitableTypes = this.findSuitableValidatorTypes(type2);
        this.resolveAssignableTypes(suitableTypes);
        this.verifyResolveWasUnique(type2, suitableTypes);
        return this.validatorTypes.get(suitableTypes.get(0));
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            String className = valueClass.toString();
            if (valueClass instanceof Class) {
                Class clazz = (Class)valueClass;
                className = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
            }
            throw new UnexpectedTypeException("No validator could be found for type: " + className);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validator classes which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new UnexpectedTypeException(builder.toString());
        }
    }

    private List<Type> findSuitableValidatorTypes(Type type2) {
        ArrayList<Type> suitableTypes = new ArrayList<Type>();
        for (Type validatorType : this.validatorTypes.keySet()) {
            if (!TypeUtils.isAssignable(validatorType, type2) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
        return suitableTypes;
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type2 = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeUtils.isAssignable(type2, assignableTypes.get(i))) {
                    typesToRemove.add(type2);
                    continue;
                }
                if (!TypeUtils.isAssignable(assignableTypes.get(i), type2)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private <V> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, V> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to initialize " + constraintValidator.getClass().getName(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintTree");
        sb.append("{ descriptor=").append(this.descriptor);
        sb.append(", isRoot=").append(this.parent == null);
        sb.append(", constraintValidatorCache=").append(this.constraintValidatorCache);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidatorCacheKey {
        private ConstraintValidatorFactory constraintValidatorFactory;
        private Class<? extends ConstraintValidator<?, ?>> validatorType;

        private ValidatorCacheKey(ConstraintValidatorFactory constraintValidatorFactory, Class<? extends ConstraintValidator<?, ?>> validatorType) {
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.validatorType = validatorType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidatorCacheKey that = (ValidatorCacheKey)o;
            if (this.constraintValidatorFactory != null ? !this.constraintValidatorFactory.equals(that.constraintValidatorFactory) : that.constraintValidatorFactory != null) {
                return false;
            }
            return !(this.validatorType != null ? !this.validatorType.equals(that.validatorType) : that.validatorType != null);
        }

        public int hashCode() {
            int result = this.constraintValidatorFactory != null ? this.constraintValidatorFactory.hashCode() : 0;
            result = 31 * result + (this.validatorType != null ? this.validatorType.hashCode() : 0);
            return result;
        }
    }
}

