/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import javassist.bytecode.Bytecode;
import org.jboss.weld.util.bytecode.DescriptorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeUtils {
    public static int loadParameters(Bytecode b, String descriptor) {
        String[] params = DescriptorUtils.descriptorStringToParameterArray(descriptor);
        return BytecodeUtils.loadParameters(b, params);
    }

    public static int loadParameters(Bytecode b, String[] params) {
        int localVariableCount = params.length + 1;
        int variablePosition = 1;
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            BytecodeUtils.addLoadInstruction(b, param, variablePosition);
            if (DescriptorUtils.isWide(param)) {
                variablePosition += 2;
                ++localVariableCount;
                continue;
            }
            ++variablePosition;
        }
        return localVariableCount;
    }

    public static void addLoadInstruction(Bytecode code, String type2, int variable) {
        char tp = type2.charAt(0);
        if (tp != 'L' && tp != '[') {
            switch (tp) {
                case 'J': {
                    code.addLload(variable);
                    break;
                }
                case 'D': {
                    code.addDload(variable);
                    break;
                }
                case 'F': {
                    code.addFload(variable);
                    break;
                }
                default: {
                    code.addIload(variable);
                    break;
                }
            }
        } else {
            code.addAload(variable);
        }
    }

    public static void addReturnInstruction(Bytecode code, Class<?> type2) {
        BytecodeUtils.addReturnInstruction(code, DescriptorUtils.classToStringRepresentation(type2));
    }

    public static void addReturnInstruction(Bytecode code, String type2) {
        char tp = type2.charAt(0);
        if (tp != 'L' && tp != '[') {
            switch (tp) {
                case 'V': {
                    code.add(177);
                    break;
                }
                case 'J': {
                    code.add(173);
                    break;
                }
                case 'D': {
                    code.add(175);
                    break;
                }
                case 'F': {
                    code.add(174);
                    break;
                }
                default: {
                    code.add(172);
                    break;
                }
            }
        } else {
            code.add(176);
        }
    }

    public static void pushClassType(Bytecode b, String classType) {
        if (classType.length() != 1) {
            if (classType.startsWith("L") && classType.endsWith(";")) {
                classType = classType.substring(1, classType.length() - 1);
            }
            int cpIndex = b.getConstPool().addClassInfo(classType);
            b.addLdc(cpIndex);
        } else {
            char type2 = classType.charAt(0);
            switch (type2) {
                case 'I': {
                    b.addGetstatic(Integer.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'J': {
                    b.addGetstatic(Long.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'S': {
                    b.addGetstatic(Short.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'F': {
                    b.addGetstatic(Float.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'D': {
                    b.addGetstatic(Double.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'B': {
                    b.addGetstatic(Byte.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'C': {
                    b.addGetstatic(Character.class.getName(), "TYPE", "Ljava/lang/Class;");
                    break;
                }
                case 'Z': {
                    b.addGetstatic(Boolean.class.getName(), "TYPE", "Ljava/lang/Class;");
                }
            }
        }
    }

    public static void add16bit(Bytecode b, int value) {
        b.add((value %= 65536) >> 8);
        b.add(value % 256);
    }
}

