/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.CompanionSeed;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.FactoryCreator;
import com.sun.hk2.component.InjectInjectionResolver;
import com.sun.hk2.component.InjectionResolver;
import com.sun.hk2.component.LeadInjectionResolver;
import com.sun.hk2.component.ScopeInstance;
import java.lang.annotation.Annotation;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.FactoryFor;
import org.jvnet.hk2.component.CageBuilder;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantTracker;
import org.jvnet.hk2.component.InhabitantTrackerContext;
import org.jvnet.hk2.component.InhabitantTrackerImpl;
import org.jvnet.hk2.component.InhabitantTrackerJob;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.SameThreadExecutor;
import org.jvnet.hk2.component.internal.runlevel.DefaultRunLevelService;

public class Habitat {
    public final String DEFAULT_NAME = "_HABITAT_DEFAULT";
    private final MultiMap<String, NamedInhabitant> byContract;
    private final MultiMap<String, Inhabitant> byType;
    public final ScopeInstance singletonScope;
    static final boolean CONCURRENCY_CONTROLS_DEFAULT = Boolean.getBoolean("hk2.concurrency.controls");
    private final boolean concurrencyControls;
    static boolean ASYNC_EXECUTOR = Boolean.getBoolean("hk2.async.executor");
    final ExecutorService exec;
    private boolean initialized;

    public Habitat() {
        this(null, null);
    }

    Habitat(ExecutorService exec, Boolean concurrency_controls) {
        this.concurrencyControls = null == concurrency_controls ? CONCURRENCY_CONTROLS_DEFAULT : concurrency_controls;
        this.byContract = new MultiMap(this.concurrencyControls);
        this.byType = new MultiMap(this.concurrencyControls);
        this.singletonScope = new ScopeInstance("singleton", new HashMap());
        if (null == exec) {
            exec = ASYNC_EXECUTOR ? Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = Executors.defaultThreadFactory().newThread(runnable);
                    t.setDaemon(true);
                    return t;
                }
            }) : new SameThreadExecutor();
        }
        this.exec = exec;
        this.addHabitatListener(new SelfListener());
        this.add(new ExistingSingletonInhabitant<InjectInjectionResolver>(InjectionResolver.class, new InjectInjectionResolver(this)));
        this.add(new ExistingSingletonInhabitant<LeadInjectionResolver>(InjectionResolver.class, new LeadInjectionResolver(this)));
        this.add(new ExistingSingletonInhabitant<Habitat>(Habitat.class, this));
        this.add(new ExistingSingletonInhabitant(CompanionSeed.Registerer.class, new CompanionSeed.Registerer(this)));
        this.add(new ExistingSingletonInhabitant(CageBuilder.Registerer.class, new CageBuilder.Registerer(this)));
        DefaultRunLevelService rls = new DefaultRunLevelService(this);
        ExistingSingletonInhabitant<DefaultRunLevelService> rlsI = new ExistingSingletonInhabitant<DefaultRunLevelService>(RunLevelService.class, rls);
        this.add(rlsI);
        this.addIndex(rlsI, RunLevelService.class.getName(), "default");
    }

    public void addHabitatListener(HabitatListener listener) {
        this.addHabitatListener(listener, "_HABITAT_DEFAULT");
    }

    public void addHabitatListener(HabitatListener listener, String ... typeNames) {
        if (null == typeNames || 0 == typeNames.length) {
            throw new IllegalArgumentException();
        }
        this.addHabitatListener(listener, new HashSet<String>(Arrays.asList(typeNames)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHabitatListener(HabitatListener listener, Set<String> typeNames) {
        ExistingSingletonInhabitant<HabitatListener> inhabitant = new ExistingSingletonInhabitant<HabitatListener>(HabitatListener.class, listener, this.metaData(typeNames));
        this.add(inhabitant);
        for (String contract : typeNames) {
            ListenersByTypeInhabitant sameListeners;
            MultiMap<String, NamedInhabitant> multiMap = this.byContract;
            synchronized (multiMap) {
                sameListeners = (ListenersByTypeInhabitant)this.getInhabitantByContract(ListenersByTypeInhabitant.class.getName(), contract);
                if (null == sameListeners) {
                    sameListeners = new ListenersByTypeInhabitant(contract);
                    this.addIndex(sameListeners, ListenersByTypeInhabitant.class.getName(), contract, false);
                }
            }
            sameListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHabitatListener(HabitatListener listener) {
        List<Inhabitant> list = this.byType._get(HabitatListener.class.getName());
        ArrayList<Inhabitant> releaseList = new ArrayList<Inhabitant>();
        Iterator<Inhabitant> iter = list.iterator();
        while (iter.hasNext()) {
            Inhabitant existing = iter.next();
            if (existing.get() != listener) continue;
            releaseList.add(existing);
            if (this.concurrencyControls) {
                list.remove(existing);
                continue;
            }
            iter.remove();
        }
        for (Inhabitant released : releaseList) {
            MultiMap<String, String> metadata = released.metadata();
            if (null != metadata) {
                List<String> filters = metadata.get("objectclass");
                for (String contract : filters) {
                    ListenersByTypeInhabitant sameListeners;
                    MultiMap<String, NamedInhabitant> multiMap = this.byContract;
                    synchronized (multiMap) {
                        sameListeners = (ListenersByTypeInhabitant)this.getInhabitantByContract(ListenersByTypeInhabitant.class.getName(), contract);
                    }
                    sameListeners.remove(listener);
                }
            }
            released.release();
            this.notify(released, HabitatListener.EventType.INHABITANT_REMOVED, null, released);
        }
        return !releaseList.isEmpty();
    }

    private MultiMap<String, String> metaData(Set<String> typeNames) {
        if (null == typeNames) {
            return null;
        }
        MultiMap<String, String> metadata = new MultiMap<String, String>();
        for (String typeName : typeNames) {
            metadata.add("objectclass", typeName);
        }
        return metadata;
    }

    public InhabitantTracker track(InhabitantTrackerContext itc, InhabitantTracker.Callback callback) throws ComponentException {
        if (null == itc) {
            throw new IllegalArgumentException();
        }
        return new InhabitantTrackerImpl(this, itc, callback);
    }

    public Future<InhabitantTracker> trackFuture(InhabitantTrackerContext itc) throws ComponentException {
        if (null == itc) {
            throw new IllegalArgumentException();
        }
        return new InhabitantTrackerJob(this, itc);
    }

    public boolean removeAllByType(Class<?> type2) {
        boolean removed = false;
        String name = type2.getName();
        ArrayList<Inhabitant> list = new ArrayList<Inhabitant>(this.byType.get(name));
        for (Inhabitant existing : list) {
            removed |= this.remove(existing);
        }
        return removed;
    }

    public void add(Inhabitant<?> i) {
        Inhabitant cageBuilder;
        String name = i.typeName();
        this.byType.add(name, i);
        ArrayList companions = null;
        for (Inhabitant<?> c : this.getInhabitantsByAnnotation(CompanionSeed.class, name)) {
            if (companions == null) {
                companions = new ArrayList();
            }
            companions.add(CompanionSeed.Registerer.createCompanion(this, i, c));
        }
        i.setCompanions(companions);
        String cageBuilderName = i.metadata().getOne("cageBuilder");
        if (cageBuilderName != null && (cageBuilder = this.byType.getOne(cageBuilderName)) != null) {
            ((CageBuilder)cageBuilder.get()).onEntered(i);
        }
        this.notify(i, HabitatListener.EventType.INHABITANT_ADDED, null, null);
    }

    public void addIndex(Inhabitant<?> i, String index, String name) {
        this.addIndex(i, index, name, true);
    }

    protected void addIndex(Inhabitant<?> i, String index, String name, boolean notify) {
        this.byContract.add(index, new NamedInhabitant(name, i));
        if (notify) {
            this.notify(i, HabitatListener.EventType.INHABITANT_INDEX_ADDED, index, name, null, null);
        }
    }

    protected static Long getServiceRanking(Inhabitant<?> i, boolean wantNonNull) {
        MultiMap<String, String> meta = i.metadata();
        String sr = meta.getOne("service.ranking");
        if (null == sr) {
            return wantNonNull ? Long.valueOf(0L) : null;
        }
        return Long.valueOf(sr);
    }

    public boolean remove(Inhabitant<?> inhabitant) {
        String name = inhabitant.typeName();
        if (this.byType.remove(name, inhabitant)) {
            this.notify(inhabitant, HabitatListener.EventType.INHABITANT_REMOVED, null, null);
            inhabitant.release();
            return true;
        }
        return false;
    }

    public boolean removeIndex(String index, String name) {
        boolean removed = false;
        if (this.byContract.containsKey(index)) {
            List<NamedInhabitant> contracted = this.byContract._get(index);
            Iterator<NamedInhabitant> iter = contracted.iterator();
            while (iter.hasNext()) {
                NamedInhabitant i = iter.next();
                if ((i.name != null || name != null) && (i.name == null || !i.name.equals(name))) continue;
                if (this.concurrencyControls) {
                    removed = contracted.remove(i);
                    assert (removed);
                } else {
                    iter.remove();
                }
                removed = true;
                this.notify(i.inhabitant, HabitatListener.EventType.INHABITANT_INDEX_REMOVED, index, name, null, null);
                this.remove(i.inhabitant);
            }
        }
        return removed;
    }

    public boolean removeIndex(String index, Object serviceOrInhabitant) {
        boolean removed = false;
        if (this.byContract.containsKey(index)) {
            List<NamedInhabitant> contracted = this.byContract._get(index);
            Iterator<NamedInhabitant> iter = contracted.iterator();
            while (iter.hasNext()) {
                NamedInhabitant i = iter.next();
                if (!this.matches(i.inhabitant, serviceOrInhabitant)) continue;
                if (this.concurrencyControls) {
                    removed = contracted.remove(i);
                    assert (removed);
                } else {
                    iter.remove();
                }
                removed = true;
                this.notify(i.inhabitant, HabitatListener.EventType.INHABITANT_INDEX_REMOVED, index, null, this.service(serviceOrInhabitant), null);
                this.remove(i.inhabitant);
            }
        }
        return removed;
    }

    protected boolean matches(Inhabitant<?> inhabitant, Object serviceOrInhabitant) {
        boolean matches = serviceOrInhabitant instanceof Inhabitant ? serviceOrInhabitant == inhabitant : inhabitant.isInstantiated() && inhabitant.get() == serviceOrInhabitant;
        return matches;
    }

    protected Object service(Object serviceOrInhabitant) {
        return serviceOrInhabitant instanceof Inhabitant ? ((Inhabitant)serviceOrInhabitant).get() : serviceOrInhabitant;
    }

    public void notifyInhabitantChanged(Inhabitant<?> inhabitant, String ... contracts) {
        if (null == contracts || 0 == contracts.length) {
            this.notify(inhabitant, HabitatListener.EventType.INHABITANT_MODIFIED, null, null);
        } else {
            for (String contract : contracts) {
                this.notify(inhabitant, HabitatListener.EventType.INHABITANT_MODIFIED, contract, null);
            }
        }
    }

    public void initialized() {
        if (this.initialized) {
            throw new RuntimeException("already initialized");
        }
        this.initialized = true;
        this.notify(null, HabitatListener.EventType.HABITAT_INITIALIZED, null, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void notify(final Inhabitant<?> inhabitant, final HabitatListener.EventType event, String index, Inhabitant<HabitatListener> extraListenerToBeNotified) {
        NotifyCall innerCall = new NotifyCall(){

            @Override
            public boolean inhabitantChanged(HabitatListener listener) {
                return listener.inhabitantChanged(event, Habitat.this, inhabitant);
            }
        };
        this.notify(innerCall, inhabitant, event, index, extraListenerToBeNotified);
    }

    protected void notify(final Inhabitant<?> inhabitant, final HabitatListener.EventType event, final String index, final String name, final Object service, Inhabitant<HabitatListener> extraListenerToBeNotified) {
        NotifyCall innerCall = new NotifyCall(){

            @Override
            public boolean inhabitantChanged(HabitatListener listener) {
                return listener.inhabitantIndexChanged(event, Habitat.this, inhabitant, index, name, service);
            }
        };
        this.notify(innerCall, inhabitant, event, index, extraListenerToBeNotified);
    }

    protected void notify(NotifyCall innerCall, Inhabitant<?> inhabitant, HabitatListener.EventType event, String index, Inhabitant<HabitatListener> extraListenerToBeNotified) {
        if (null != index) {
            this.doNotify(innerCall, inhabitant, event, index, null);
        }
        this.doNotify(innerCall, inhabitant, event, "_HABITAT_DEFAULT", extraListenerToBeNotified);
    }

    private void doNotify(final NotifyCall innerCall, Inhabitant<?> inhabitant, final HabitatListener.EventType event, String index, final Inhabitant<HabitatListener> extraListenerToBeNotified) {
        final ListenersByTypeInhabitant sameListeners = (ListenersByTypeInhabitant)this.getInhabitantByContract(ListenersByTypeInhabitant.class.getName(), index);
        if (null != sameListeners && !sameListeners.listeners.isEmpty()) {
            this.exec.execute(new Runnable(){

                @Override
                public void run() {
                    for (Object entry : sameListeners.listeners) {
                        HabitatListener listener = entry instanceof HabitatListener ? (HabitatListener)entry : (HabitatListener)((Inhabitant)entry).get();
                        try {
                            boolean keepMe = innerCall.inhabitantChanged(listener);
                            if (keepMe) continue;
                            Habitat.this.removeHabitatListener(listener);
                        }
                        catch (Exception e) {
                            Logger.getLogger(Habitat.class.getName()).log(Level.WARNING, "exception caught from listener: ", e);
                        }
                    }
                    if (null != extraListenerToBeNotified) {
                        ((HabitatListener)extraListenerToBeNotified.get()).inhabitantChanged(event, Habitat.this, extraListenerToBeNotified);
                    }
                }
            });
        }
    }

    public boolean isContract(Class<?> type2) {
        return this.byContract.containsKey(type2.getName());
    }

    public boolean isContract(String fullyQualifiedClassName) {
        return this.byContract.containsKey(fullyQualifiedClassName);
    }

    public <T> Collection<T> getAllByContract(Class<T> contractType) {
        return this.getAllByContract(contractType.getName());
    }

    public <T> Collection<T> getAllByContract(String contractType) {
        final List<NamedInhabitant> l = this.byContract.get(contractType);
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ((NamedInhabitant)l.get((int)index)).inhabitant.get();
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public Collection<Inhabitant<?>> getAllInhabitantsByContract(String contractType) {
        final List<NamedInhabitant> l = this.byContract.get(contractType);
        return new AbstractList<Inhabitant<?>>(){

            @Override
            public Inhabitant<?> get(int index) {
                return ((NamedInhabitant)l.get((int)index)).inhabitant;
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> Collection<T> getAllByType(Class<T> implType) {
        final List<Inhabitant> l = this.byType.get(implType.getName());
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return ((Inhabitant)l.get(index)).get();
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> void addComponent(String name, T component) throws ComponentException {
        this.add(new ExistingSingletonInhabitant<T>(component));
    }

    public <T> T getComponent(Class<T> clazz) throws ComponentException {
        if (this.isContract(clazz)) {
            return this.getByContract(clazz);
        }
        return this.getByType(clazz);
    }

    public <T> T getComponent(Class<T> contract, String name) throws ComponentException {
        Inhabitant<T> i;
        if (name != null && name.length() == 0) {
            name = null;
        }
        if ((i = this.getInhabitant(contract, name)) != null) {
            try {
                return contract.cast(i.get());
            }
            catch (ClassCastException e) {
                Logger.getAnonymousLogger().severe("ClassCastException between contract " + contract + " and service " + i.get());
                Logger.getAnonymousLogger().severe("Contract class loader " + contract.getClassLoader());
                Logger.getAnonymousLogger().severe("Service class loader " + i.get().getClass().getClassLoader());
                throw e;
            }
        }
        return null;
    }

    public Object getComponent(String fullQualifiedName, String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        Inhabitant i = this.isContract(fullQualifiedName) ? this.getInhabitantByContract(fullQualifiedName, name) : this.getInhabitantByType(fullQualifiedName);
        return i == null ? null : i.get();
    }

    public <T> Inhabitant<T> getInhabitant(Class<T> contract, String name) throws ComponentException {
        return this.getInhabitantByContract(contract.getName(), name);
    }

    public <T> Inhabitant<T> getInhabitantByType(Class<T> implType) {
        return this.getInhabitantByType(implType.getName());
    }

    public Inhabitant<?> getInhabitantByType(String fullyQualifiedClassName) {
        List<Inhabitant> list = this.byType.get(fullyQualifiedClassName);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Inhabitant<?> getInhabitantByAnnotation(Class<? extends Annotation> contract, String name) throws ComponentException {
        return this.getInhabitantByContract(contract.getName(), name);
    }

    public <T> Collection<Inhabitant<? extends T>> getInhabitants(Class<T> contract) throws ComponentException {
        final List<NamedInhabitant> l = this.byContract.get(contract.getName());
        return new AbstractList<Inhabitant<? extends T>>(){

            @Override
            public Inhabitant<? extends T> get(int index) {
                return ((NamedInhabitant)l.get((int)index)).inhabitant;
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    public <T> Collection<Inhabitant<T>> getInhabitantsByType(Class<T> implType) throws ComponentException {
        return this.byType.get(implType.getName());
    }

    public Collection<Inhabitant<?>> getInhabitantsByType(String fullyQualifiedClassName) {
        return this.byType.get(fullyQualifiedClassName);
    }

    public Inhabitant<?> getInhabitantByContract(String typeName) {
        List<NamedInhabitant> services = this.byContract._get(typeName);
        return null == services || services.isEmpty() ? null : services.get((int)0).inhabitant;
    }

    public Collection<Inhabitant<?>> getInhabitantsByContract(String fullyQualifiedClassName) {
        final List<NamedInhabitant> services = this.byContract.get(fullyQualifiedClassName);
        return new AbstractList<Inhabitant<?>>(){

            @Override
            public Inhabitant<?> get(int index) {
                return ((NamedInhabitant)services.get((int)index)).inhabitant;
            }

            @Override
            public int size() {
                return services.size();
            }
        };
    }

    public Iterator<String> getAllContracts() {
        return new MultiMapIterator(this.byContract);
    }

    public Iterator<String> getAllTypes() {
        return new MultiMapIterator(this.byType);
    }

    public Inhabitant getInhabitantByContract(String fullyQualifiedName, String name) {
        for (NamedInhabitant i : this.byContract.get(fullyQualifiedName)) {
            if (!Habitat.eq(i.name, name)) continue;
            return i.inhabitant;
        }
        return null;
    }

    public <T> Iterable<Inhabitant<? extends T>> getInhabitants(Class<T> contract, String name) throws ComponentException {
        return this._getInhabitants(contract, name);
    }

    public Iterable<Inhabitant<?>> getInhabitantsByAnnotation(Class<? extends Annotation> contract, String name) throws ComponentException {
        return this._getInhabitants(contract, name);
    }

    private Iterable _getInhabitants(final Class contract, final String name) {
        return new Iterable<Inhabitant>(){
            private final Iterable<NamedInhabitant> base;
            {
                this.base = Habitat.this.byContract.get(contract.getName());
            }

            @Override
            public Iterator<Inhabitant> iterator() {
                return new Iterator<Inhabitant>(){
                    private Inhabitant i = null;
                    private final Iterator<NamedInhabitant> itr = 10.access$300(this).iterator();

                    @Override
                    public boolean hasNext() {
                        while (this.i == null && this.itr.hasNext()) {
                            NamedInhabitant ni = this.itr.next();
                            if (!Habitat.eq(ni.name, name)) continue;
                            this.i = ni.inhabitant;
                        }
                        return this.i != null;
                    }

                    @Override
                    public Inhabitant next() {
                        if (this.i == null) {
                            throw new NoSuchElementException();
                        }
                        Inhabitant r = this.i;
                        this.i = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            static /* synthetic */ Iterable access$300(10 x0) {
                return x0.base;
            }
        };
    }

    private static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public <T> T getByType(Class<T> implType) {
        return this.getBy(implType, this.byType);
    }

    public <T> T getByContract(Class<T> contractType) {
        List<NamedInhabitant> l = this.byContract.get(contractType.getName());
        if (l.isEmpty()) {
            return null;
        }
        return l.get((int)0).inhabitant.get();
    }

    private <T> T getBy(Class<T> implType, MultiMap<String, Inhabitant> index) {
        List<Inhabitant> l = index.get(implType.getName());
        if (l.isEmpty()) {
            return null;
        }
        return l.get(0).get();
    }

    public void release() {
        for (Map.Entry<String, List<Inhabitant>> e : this.byType.entrySet()) {
            for (Inhabitant i : e.getValue()) {
                i.release();
                this.notify(i, HabitatListener.EventType.INHABITANT_REMOVED, null, null);
            }
        }
    }

    private static final class SelfListener
    implements HabitatListener {
        private SelfListener() {
        }

        @Override
        public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
            return true;
        }

        @Override
        public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> i, String index, String name, Object service) {
            if (index.equals(FactoryFor.class.getName())) {
                FactoryFor ff = i.type().getAnnotation(FactoryFor.class);
                Class<?> targetClass = ff.value();
                FactoryCreator target = new FactoryCreator(targetClass, i, habitat, MultiMap.<String, String>emptyMap());
                habitat.add(target);
                habitat.addIndex(target, targetClass.getName(), null);
            }
            return true;
        }
    }

    final class ListenersByTypeInhabitant
    extends ExistingSingletonInhabitant {
        private final String name;
        private final CopyOnWriteArrayList<HabitatListener> listeners;
        private volatile boolean released;

        protected ListenersByTypeInhabitant(String name) {
            super(new ExistingSingletonInhabitant<Object>(ListenersByTypeInhabitant.class, null));
            this.listeners = new CopyOnWriteArrayList();
            this.name = name;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.name + ")";
        }

        public void add(HabitatListener listener) {
            this.listeners.add(0, listener);
        }

        public boolean remove(HabitatListener listener) {
            return this.listeners.remove(listener);
        }

        public int size() {
            return this.listeners.size();
        }

        @Override
        public void release() {
            if (!this.released) {
                this.released = true;
                for (HabitatListener listener : this.listeners) {
                    Habitat.this.removeHabitatListener(listener);
                }
            }
            super.release();
        }
    }

    private static final class NamedInhabitant {
        final String name;
        final Inhabitant inhabitant;

        public NamedInhabitant(String name, Inhabitant inhabitant) {
            this.name = name;
            this.inhabitant = inhabitant;
        }
    }

    private class MultiMapIterator
    implements Iterator {
        final Iterator<Map.Entry<String, List<NamedInhabitant>>> itr;

        MultiMapIterator(MultiMap map) {
            this.itr = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return this.itr.next().getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static interface NotifyCall {
        public boolean inhabitantChanged(HabitatListener var1);
    }
}

