/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import com.sun.hk2.component.InhabitantsScanner;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.classmodel.ClassPath;

public abstract class InhabitantsParsingContextGenerator
implements Closeable {
    private static final Logger logger = Logger.getLogger(InhabitantsParsingContextGenerator.class.getName());
    private final Parser parser;
    private final ParsingContext context;
    private final LinkedHashMap<String, InhabitantsScanner> metaInfScanners = new LinkedHashMap();

    public static InhabitantsParsingContextGenerator create(Habitat h) {
        return new InhabitantsParsingContextGenerator(null, null){};
    }

    public static InhabitantsParsingContextGenerator create(Habitat h, ExecutorService es, ClassPath inhabitantsClassPath) {
        return new InhabitantsParsingContextGenerator(es, inhabitantsClassPath){};
    }

    protected InhabitantsParsingContextGenerator(ExecutorService es, ClassPath inhabitantsClassPath) {
        ParsingContext.Builder builder = new ParsingContext.Builder();
        final HashSet<String> annotations = new HashSet<String>();
        annotations.add(Contract.class.getCanonicalName());
        annotations.add(Service.class.getCanonicalName());
        annotations.add("org.jvnet.hk2.config.Configured");
        builder.config(new ParsingConfig(){
            final Set<String> empty = Collections.emptySet();

            @Override
            public Set<String> getAnnotationsOfInterest() {
                return this.empty;
            }

            @Override
            public Set<String> getTypesOfInterest() {
                return annotations;
            }
        });
        builder.executorService(es);
        if (null != inhabitantsClassPath) {
            builder.locator(new Locator(inhabitantsClassPath));
        }
        this.context = builder.build();
        this.parser = new Parser(this.context);
    }

    public void parse(Collection<File> files) throws IOException {
        for (File file : files) {
            this.parse(file);
        }
    }

    public ParsingContext getContext() {
        try {
            this.parser.awaitTermination();
        }
        catch (InterruptedException e) {
            this.close();
            throw new RuntimeException(e);
        }
        return this.context;
    }

    public Collection<InhabitantsScanner> getInhabitantsScanners() {
        return Collections.unmodifiableCollection(this.metaInfScanners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInhabitantsScanner(String name, InhabitantsScanner is) {
        LinkedHashMap<String, InhabitantsScanner> linkedHashMap = this.metaInfScanners;
        synchronized (linkedHashMap) {
            if (!this.metaInfScanners.containsKey(name)) {
                this.metaInfScanners.put(name, is);
            }
        }
    }

    public void parse(File f) throws IOException {
        this.parseAlways(this.parser, f);
    }

    protected void parseAlways(Parser parser, final File f) throws IOException {
        try {
            parser.parse(f, new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.FINER, "Finished introspecting {0}", f.getName());
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.FINE, "problem during parsing - closing prematurely", e);
            this.close();
        }
    }

    @Override
    public void close() {
        if (null != this.parser) {
            this.parser.close();
        }
    }

    private static class Locator
    implements ResourceLocator {
        private final ClassLoader resourceLoader;

        public Locator(ClassPath inhabitantsClassPath) {
            try {
                this.resourceLoader = new URLClassLoader(inhabitantsClassPath.getRawURLs(), null);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINER, "resourceLoader is {0}", Arrays.asList(inhabitantsClassPath.getRawURLs()).toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public URL getResource(String name) {
            if (name.startsWith("java/")) {
                logger.log(Level.FINE, "skipping {0}", name);
                return null;
            }
            URL resource = this.resourceLoader.getResource(name);
            logger.log(Level.FINE, "resource {0} resolved to {1}", new Object[]{name, resource});
            return resource;
        }
    }
}

