/*
 * Decompiled with CFR 0.152.
 */
package pkg.sun.servicetag;

import java.io.File;
import pkg.sun.servicetag.SystemEnvironment;

class SolarisSystemEnvironment
extends SystemEnvironment {
    SolarisSystemEnvironment() {
        this.setHostId(this.getCommandOutput("/usr/bin/hostid"));
        this.setSystemModel(this.getCommandOutput("/usr/bin/uname", "-i"));
        this.setSystemManufacturer(this.getSolarisSystemManufacturer());
        this.setCpuManufacturer(this.getSolarisCpuManufacturer());
        this.setSerialNumber(this.getSolarisSN());
    }

    private String getSolarisCpuManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("4", "Manufacturer: ");
    }

    private String getSolarisSystemManufacturer() {
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("1", "Manufacturer: ");
    }

    private String getSolarisSN() {
        String string = this.getFileContent("/var/run/psn");
        if (string.length() > 0) {
            return string.trim();
        }
        String string2 = this.getSneepSN();
        if (string2.length() > 0) {
            return string2;
        }
        string2 = this.getSmbiosData("1", "Serial Number: ");
        if (string2.length() > 0) {
            return string2;
        }
        string2 = this.getSmbiosData("3", "Serial Number: ");
        if (string2.length() > 0) {
            return string2;
        }
        return "";
    }

    private String getSmbiosData(String string, String string2) {
        String string3 = this.getCommandOutput("/usr/sbin/smbios", "-t", string);
        for (String string4 : string3.split("\n")) {
            String string5;
            String string6;
            int n;
            if (!string4.contains(string2) || (n = string4.indexOf(string2) + string2.length()) >= string4.length() || (string6 = (string5 = string4.substring(n).trim()).toLowerCase()).startsWith("not available") || string6.startsWith("to be filled by o.e.m")) continue;
            return string5;
        }
        return "";
    }

    private String getSneepSN() {
        String string = this.getCommandOutput("pkgparam", "SUNWsneep", "BASEDIR");
        File file = new File(string + "/bin/sneep");
        if (file.exists()) {
            String string2 = this.getCommandOutput(string + "/bin/sneep");
            if (string2.equalsIgnoreCase("unknown")) {
                return "";
            }
            return string2;
        }
        return "";
    }
}

