/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.CompletionHandlerAdapter;

public final class UDPNIOTransportFilter
extends BaseFilter {
    private final UDPNIOTransport transport;

    UDPNIOTransportFilter(UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        ReadResult readResult;
        UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
        boolean isBlocking = ctx.getTransportContext().isBlocking();
        if (!isBlocking) {
            readResult = ReadResult.create(connection);
            this.transport.read(connection, null, readResult);
        } else {
            GrizzlyFuture<ReadResult<Buffer, SocketAddress>> future = this.transport.getTemporarySelectorIO().getReader().read(connection, null);
            try {
                readResult = (ReadResult)future.get();
                future.recycle(false);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new IOException(cause);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (readResult.getReadSize() > 0) {
            Buffer buffer = (Buffer)readResult.getMessage();
            buffer.trim();
            SocketAddress address = (SocketAddress)readResult.getSrcAddress();
            readResult.recycle();
            ctx.setMessage(buffer);
            ctx.setAddress(address);
            if (!connection.isConnected()) {
                connection.enableIOEvent(IOEvent.READ);
            }
        } else {
            readResult.recycle();
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        if (message != null) {
            boolean hasFuture;
            ctx.setMessage(null);
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            FutureImpl contextFuture = transportContext.getFuture();
            CompletionHandlerAdapter completionHandler = transportContext.getCompletionHandler();
            Object address = ctx.getAddress();
            CompletionHandlerAdapter writeCompletionHandler = null;
            boolean bl = hasFuture = contextFuture != null;
            if (hasFuture) {
                writeCompletionHandler = new CompletionHandlerAdapter(contextFuture, completionHandler);
            } else if (completionHandler != null) {
                writeCompletionHandler = completionHandler;
            }
            transportContext.setFuture(null);
            transportContext.setCompletionHandler(null);
            this.transport.getWriter(transportContext.isBlocking()).write(connection, address, (Buffer)message, writeCompletionHandler).markForRecycle(!hasFuture);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == TransportFilter.FlushEvent.TYPE) {
            Connection connection = ctx.getConnection();
            FilterChainContext.TransportContext transportContext = ctx.getTransportContext();
            if (transportContext.getFuture() != null || transportContext.getCompletionHandler() != null) {
                throw new IllegalStateException("TransportContext CompletionHandler and Future must be null");
            }
            FutureImpl contextFuture = ((TransportFilter.FlushEvent)event).getFuture();
            CompletionHandlerAdapter completionHandler = ((TransportFilter.FlushEvent)event).getCompletionHandler();
            boolean hasFuture = contextFuture != null;
            CompletionHandlerAdapter writeCompletionHandler = hasFuture ? new CompletionHandlerAdapter(contextFuture, completionHandler) : completionHandler;
            this.transport.getWriter(transportContext.isBlocking()).write(connection, Buffers.EMPTY_BUFFER, writeCompletionHandler).markForRecycle(false);
            transportContext.setFuture(null);
            transportContext.setCompletionHandler(null);
        }
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close().markForRecycle(true);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }
}

