/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.utilities.reflection.Pretty;

public class InjecteeImpl
implements Injectee {
    private final Type requiredType;
    private final Set<Annotation> qualifiers;
    private final int position;
    private final Class<?> pClass;
    private final AnnotatedElement parent;
    private final boolean isOptional;
    private final boolean isSelf;
    private final Unqualified unqualified;

    InjecteeImpl(Type requiredType, Set<Annotation> qualifiers, int position, AnnotatedElement parent, boolean isOptional, boolean isSelf, Unqualified unqualified) {
        this.requiredType = requiredType;
        this.position = position;
        this.parent = parent;
        this.qualifiers = Collections.unmodifiableSet(qualifiers);
        this.isOptional = isOptional;
        this.isSelf = isSelf;
        this.unqualified = unqualified;
        this.pClass = parent instanceof Field ? ((Field)parent).getDeclaringClass() : (parent instanceof Constructor ? ((Constructor)parent).getDeclaringClass() : ((Method)parent).getDeclaringClass());
    }

    public Type getRequiredType() {
        return this.requiredType;
    }

    public Set<Annotation> getRequiredQualifiers() {
        return this.qualifiers;
    }

    public int getPosition() {
        return this.position;
    }

    public Class<?> getInjecteeClass() {
        return this.pClass;
    }

    public AnnotatedElement getParent() {
        return this.parent;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public Unqualified getUnqualified() {
        return this.unqualified;
    }

    public String toString() {
        return "Injectee(requiredType=" + Pretty.type((Type)this.requiredType) + ",parent=" + Pretty.clazz(this.pClass) + ",qualifiers=" + Pretty.collection(this.qualifiers) + ",position=" + this.position + ",optional=" + this.isOptional + ",self=" + this.isSelf + ",unqualified=" + this.unqualified + "," + System.identityHashCode(this) + ")";
    }
}

