/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.cdi.CdiBehavior;
import com.sun.faces.cdi.CdiConverter;
import com.sun.faces.cdi.CdiValidator;
import com.sun.faces.cdi.FacesBehaviorAnnotationLiteral;
import com.sun.faces.cdi.FacesConverterAnnotationLiteral;
import com.sun.faces.cdi.FacesDataModelAnnotationLiteral;
import com.sun.faces.cdi.FacesValidatorAnnotationLiteral;
import com.sun.faces.cdi.InjectionPointGenerator;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.DataModel;
import javax.faces.validator.Validator;

public final class CdiUtils {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static final Type CONVERTER_TYPE = new TypeLiteral<Converter<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private static final Type VALIDATOR_TYPE = new TypeLiteral<Validator<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();

    private CdiUtils() {
    }

    public static Converter<?> createConverter(BeanManager beanManager, String value) {
        Converter<?> managedConverter = CdiUtils.createConverter(beanManager, new FacesConverterAnnotationLiteral(value, Object.class));
        if (managedConverter != null) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), managedConverter);
            return new CdiConverter(value, Object.class, managedConverter);
        }
        return null;
    }

    public static Converter<?> createConverter(BeanManager beanManager, Class<?> forClass) {
        Converter<?> managedConverter = null;
        for (Class<?> forClassOrSuperclass = forClass; managedConverter == null && forClassOrSuperclass != null && forClassOrSuperclass != Object.class; forClassOrSuperclass = forClassOrSuperclass.getSuperclass()) {
            managedConverter = CdiUtils.createConverter(beanManager, new FacesConverterAnnotationLiteral("", forClassOrSuperclass));
        }
        if (managedConverter != null) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            associate.getAnnotationManager().applyConverterAnnotations(FacesContext.getCurrentInstance(), managedConverter);
            return new CdiConverter("", forClass, managedConverter);
        }
        return null;
    }

    private static Converter<?> createConverter(BeanManager beanManager, Annotation qualifier) {
        Converter managedConverter = (Converter)CdiUtils.getBeanReferenceByType(beanManager, CONVERTER_TYPE, qualifier);
        if (managedConverter == null) {
            managedConverter = CdiUtils.getBeanReference(beanManager, Converter.class, qualifier);
        }
        return managedConverter;
    }

    public static Behavior createBehavior(BeanManager beanManager, String value) {
        CdiBehavior delegatingBehavior = null;
        Behavior managedBehavior = CdiUtils.getBeanReference(beanManager, Behavior.class, new FacesBehaviorAnnotationLiteral(value));
        if (managedBehavior != null) {
            delegatingBehavior = new CdiBehavior(value, managedBehavior);
        }
        return delegatingBehavior;
    }

    public static Validator<?> createValidator(BeanManager beanManager, String value) {
        FacesValidatorAnnotationLiteral qualifier = new FacesValidatorAnnotationLiteral(value);
        Validator managedValidator = (Validator)CdiUtils.getBeanReferenceByType(beanManager, VALIDATOR_TYPE, qualifier);
        if (managedValidator == null) {
            managedValidator = CdiUtils.getBeanReference(beanManager, Validator.class, qualifier);
        }
        if (managedValidator != null) {
            return new CdiValidator(value, managedValidator);
        }
        return null;
    }

    public static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager beanManager, Class<?> ... types) {
        for (Class<?> type : types) {
            beforeBean.addAnnotatedType(beanManager.createAnnotatedType(type), "Mojarra " + type.getName());
        }
    }

    public static <T> T getBeanReference(Class<T> type, Annotation ... qualifiers) {
        return type.cast(CdiUtils.getBeanReferenceByType(Util.getCdiBeanManager(FacesContext.getCurrentInstance()), type, qualifiers));
    }

    public static <T> T getBeanReference(BeanManager beanManager, Class<T> type, Annotation ... qualifiers) {
        return type.cast(CdiUtils.getBeanReferenceByType(beanManager, type, qualifiers));
    }

    public static Object getBeanReferenceByType(BeanManager beanManager, Type type, Annotation ... qualifiers) {
        Object beanReference = null;
        Bean bean = beanManager.resolve(beanManager.getBeans(type, qualifiers));
        if (bean != null) {
            beanReference = beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean));
        }
        return beanReference;
    }

    public static <T> T getBeanInstance(Class<T> type, boolean create) {
        BeanManager beanManager = Util.getCdiBeanManager(FacesContext.getCurrentInstance());
        Bean bean = beanManager.resolve(beanManager.getBeans(type, new Annotation[0]));
        if (bean != null) {
            Context context = beanManager.getContext(bean.getScope());
            if (create) {
                return (T)context.get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
            }
            return (T)context.get((Contextual)bean);
        }
        return null;
    }

    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        annotated.getAnnotation(annotationType);
        if (annotated.getAnnotations().isEmpty()) {
            return Optional.empty();
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return Optional.of(annotated.getAnnotation(annotationType));
        }
        LinkedList annotations = new LinkedList(annotated.getAnnotations());
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of(annotationType.cast(annotation));
            }
            try {
                if (!beanManager.isStereotype(annotation.annotationType())) continue;
                annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning("Exception happened when finding an annotation: " + e);
            }
        }
        return Optional.empty();
    }

    public static DataModel<?> createDataModel(Class<?> forClass) {
        ArrayList dataModel = new ArrayList(1);
        CDI cdi = CDI.current();
        CdiUtils.getDataModelClassesMap((CDI<Object>)cdi).entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(forClass)).findFirst().ifPresent(e -> dataModel.add(cdi.select((Class)e.getValue(), new Annotation[]{new FacesDataModelAnnotationLiteral((Class)e.getKey())}).get()));
        return dataModel.isEmpty() ? null : (DataModel)dataModel.get(0);
    }

    public static Map<Class<?>, Class<? extends DataModel<?>>> getDataModelClassesMap(CDI<Object> cdi) {
        BeanManager beanManager = cdi.getBeanManager();
        Bean bean = beanManager.resolve(beanManager.getBeans("comSunFacesDataModelClassesMap"));
        Object beanReference = beanManager.getReference(bean, Map.class, beanManager.createCreationalContext((Contextual)bean));
        return (Map)beanReference;
    }

    public static InjectionPoint getCurrentInjectionPoint(BeanManager beanManager, CreationalContext<?> creationalContext) {
        Bean bean = beanManager.resolve(beanManager.getBeans(InjectionPoint.class, new Annotation[0]));
        InjectionPoint injectionPoint = (InjectionPoint)beanManager.getReference(bean, InjectionPoint.class, creationalContext);
        if (injectionPoint == null) {
            bean = beanManager.resolve(beanManager.getBeans(InjectionPointGenerator.class, new Annotation[0]));
            injectionPoint = (InjectionPoint)beanManager.getInjectableReference((InjectionPoint)bean.getInjectionPoints().iterator().next(), creationalContext);
        }
        return injectionPoint;
    }

    public static <A extends Annotation> A getQualifier(InjectionPoint injectionPoint, Class<A> qualifierClass) {
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (!qualifierClass.isAssignableFrom(annotation.getClass())) continue;
            return (A)((Annotation)qualifierClass.cast(annotation));
        }
        return null;
    }

    public static <S extends Annotation> boolean isScopeActive(Class<S> scope) {
        BeanManager beanManager = Util.getCdiBeanManager(FacesContext.getCurrentInstance());
        try {
            Context context = beanManager.getContext(scope);
            return context.isActive();
        }
        catch (ContextNotActiveException ignore) {
            return false;
        }
    }
}

