/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.cdi.CdiExtension;
import com.sun.faces.config.ConfigureListener;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.util.Util;
import jakarta.annotation.Resource;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.annotation.FacesConfig;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.bean.ManagedBean;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.ListenersFor;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.facelets.FaceletsResourceResolver;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@HandlesTypes(value={Converter.class, Endpoint.class, FaceletsResourceResolver.class, FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConverter.class, FacesConfig.class, FacesValidator.class, ListenerFor.class, ListenersFor.class, ManagedBean.class, NamedEvent.class, PhaseListener.class, Renderer.class, Resource.class, ResourceDependencies.class, ResourceDependency.class, ServerApplicationConfig.class, ServerEndpoint.class, UIComponent.class, Validator.class})
public class FacesInitializer
implements ServletContainerInitializer {
    private static final String FACES_SERVLET_CLASS = FacesServlet.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        boolean appHasFacesServlet;
        HashSet annotatedClasses = new HashSet();
        if (classes != null) {
            annotatedClasses.addAll(classes);
        }
        servletContext.setAttribute("com.sun.faces.AnnotatedClasses", annotatedClasses);
        boolean appHasSomeJsfContent = this.appMayHaveSomeJsfContent(classes, servletContext);
        boolean bl = appHasFacesServlet = this.getExistingFacesServletRegistration(servletContext) != null;
        if (appHasSomeJsfContent || appHasFacesServlet) {
            InitFacesContext initFacesContext = new InitFacesContext(servletContext);
            try {
                if (appHasSomeJsfContent) {
                    this.handleMappingConcerns(servletContext);
                }
                this.handleWebSocketConcerns(servletContext);
            }
            finally {
                initFacesContext.releaseCurrentInstance();
                initFacesContext.release();
            }
        }
    }

    private boolean appMayHaveSomeJsfContent(Set<Class<?>> classes, ServletContext context) {
        if (!Util.isEmpty(classes)) {
            return true;
        }
        try {
            if (context.getResource("/WEB-INF/faces-config.xml") != null) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            CDI cdi = null;
            try {
                Instance extension;
                cdi = CDI.current();
                if (cdi != null && !(extension = cdi.select(CdiExtension.class, new Annotation[0])).isAmbiguous() && !extension.isUnsatisfied()) {
                    return ((CdiExtension)extension.get()).isAddBeansForJSFImplicitObjects();
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void handleMappingConcerns(ServletContext servletContext) throws ServletException {
        ServletRegistration existingFacesServletRegistration = this.getExistingFacesServletRegistration(servletContext);
        if (existingFacesServletRegistration != null) {
            if (this.isADFApplication()) {
                existingFacesServletRegistration.addMapping(new String[]{"*.xhtml", "*.jsf"});
            }
            servletContext.setAttribute("com.sun.faces.FacesServletMappings", (Object)existingFacesServletRegistration.getMappings());
            return;
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet("FacesServlet", "jakarta.faces.webapp.FacesServlet");
        if ("true".equalsIgnoreCase(servletContext.getInitParameter("jakarta.faces.DISABLE_FACESSERVLET_TO_XHTML"))) {
            reg.addMapping(new String[]{"/faces/*", "*.jsf", "*.faces"});
        } else {
            reg.addMapping(new String[]{"/faces/*", "*.jsf", "*.faces", "*.xhtml"});
        }
        servletContext.setAttribute("com.sun.faces.facesInitializerMappingsAdded", (Object)Boolean.TRUE);
        servletContext.setAttribute("com.sun.faces.FacesServletMappings", (Object)reg.getMappings());
        servletContext.addListener(ConfigureListener.class);
    }

    private ServletRegistration getExistingFacesServletRegistration(ServletContext servletContext) {
        Map existing = servletContext.getServletRegistrations();
        for (ServletRegistration registration : existing.values()) {
            if (!FACES_SERVLET_CLASS.equals(registration.getClassName())) continue;
            return registration;
        }
        return null;
    }

    private void handleWebSocketConcerns(ServletContext ctx) throws ServletException {
        Class<?> tyrusInitializerClass;
        if (ctx.getAttribute(ServerContainer.class.getName()) != null) {
            return;
        }
        if (!Boolean.valueOf(ctx.getInitParameter("jakarta.faces.ENABLE_WEBSOCKET_ENDPOINT")).booleanValue()) {
            return;
        }
        ClassLoader cl = ctx.getClassLoader();
        try {
            tyrusInitializerClass = cl.loadClass("org.glassfish.tyrus.servlet.TyrusServletContainerInitializer");
        }
        catch (ClassNotFoundException cnfe) {
            return;
        }
        try {
            ServletContainerInitializer tyrusInitializer = (ServletContainerInitializer)tyrusInitializerClass.newInstance();
            Class<?> configClass = cl.loadClass("org.glassfish.tyrus.server.TyrusServerConfiguration");
            HashSet filteredClasses = new HashSet();
            filteredClasses.add(configClass);
            tyrusInitializer.onStartup(filteredClasses, ctx);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private boolean isADFApplication() {
        boolean hasResource = false;
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                hasResource = contextClassLoader.getResource("oracle/adf/view/rich/context/AdfFacesContext.class") != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasResource;
    }
}

