/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.glassfish.jersey.jdk.connector.internal.AsynchronousBodyInputStream;
import org.glassfish.jersey.jdk.connector.internal.HttpParser;
import org.glassfish.jersey.jdk.connector.internal.HttpParserUtils;
import org.glassfish.jersey.jdk.connector.internal.LocalizationMessages;
import org.glassfish.jersey.jdk.connector.internal.ParseException;
import org.glassfish.jersey.jdk.connector.internal.Utils;

abstract class TransferEncodingParser {
    TransferEncodingParser() {
    }

    abstract boolean parse(ByteBuffer var1) throws ParseException;

    static TransferEncodingParser createFixedLengthParser(AsynchronousBodyInputStream responseBody, long expectedLength) {
        return new FixedLengthEncodingParser(responseBody, expectedLength);
    }

    static TransferEncodingParser createChunkParser(AsynchronousBodyInputStream responseBody, HttpParser httpParser, int maxHeadersSize) {
        return new ChunkedEncodingParser(responseBody, httpParser, maxHeadersSize);
    }

    private static class ChunkedEncodingParser
    extends TransferEncodingParser {
        private static final int MAX_HTTP_CHUNK_SIZE_LENGTH = 16;
        private static final long CHUNK_SIZE_OVERFLOW = 0x7FFFFFFFFFFFFFFL;
        private static final int CHUNK_LENGTH_PARSED_STATE = 3;
        private static final int[] DEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private final HttpParserUtils.ContentParsingState contentParsingState = new HttpParserUtils.ContentParsingState();
        private final HttpParserUtils.HeaderParsingState headerParsingState;
        private final AsynchronousBodyInputStream responseBody;
        private final HttpParser httpParser;
        private final int maxHeadersSize;

        ChunkedEncodingParser(AsynchronousBodyInputStream responseBody, HttpParser httpParser, int maxHeadersSize) {
            this.responseBody = responseBody;
            this.httpParser = httpParser;
            this.headerParsingState = httpParser.getHeaderParsingState();
            this.maxHeadersSize = maxHeadersSize;
        }

        @Override
        boolean parse(ByteBuffer input) throws ParseException {
            while (input.hasRemaining()) {
                boolean isLastChunk = this.contentParsingState.isLastChunk;
                if (!isLastChunk && this.contentParsingState.chunkRemainder <= 0L) {
                    if (!this.parseTrailerCRLF(input)) {
                        return false;
                    }
                    if (!this.parseHttpChunkLength(input)) {
                        return false;
                    }
                } else {
                    this.contentParsingState.chunkContentStart = input.position();
                }
                int chunkContentStart = this.contentParsingState.chunkContentStart;
                if (this.contentParsingState.chunkLength == 0L) {
                    if (!isLastChunk) {
                        this.contentParsingState.isLastChunk = true;
                        isLastChunk = true;
                        this.initTrailerParsing();
                    }
                    if (!this.parseLastChunkTrailer(input)) {
                        return false;
                    }
                    chunkContentStart = this.headerParsingState.offset;
                }
                if (isLastChunk) {
                    ((Buffer)input).position(chunkContentStart);
                    return true;
                }
                long thisPacketRemaining = this.contentParsingState.chunkRemainder;
                int contentAvailable = input.limit() - chunkContentStart;
                ((Buffer)input).position(chunkContentStart);
                ByteBuffer data = (long)contentAvailable > thisPacketRemaining ? Utils.split(input, (int)((long)chunkContentStart + thisPacketRemaining)) : Utils.split(input, chunkContentStart + input.remaining());
                this.contentParsingState.chunkRemainder -= (long)data.remaining();
                this.responseBody.notifyDataAvailable(data);
            }
            return false;
        }

        private boolean parseHttpChunkLength(ByteBuffer input) throws ParseException {
            while (true) {
                switch (this.headerParsingState.state) {
                    case 0: {
                        int pos;
                        this.headerParsingState.start = pos = input.position();
                        this.headerParsingState.offset = pos;
                        this.headerParsingState.packetLimit = pos + 16;
                        this.headerParsingState.state = 1;
                        break;
                    }
                    case 1: {
                        int nonSpaceIdx = HttpParserUtils.skipSpaces(input, this.headerParsingState.offset, this.headerParsingState.packetLimit);
                        if (nonSpaceIdx == -1) {
                            this.headerParsingState.offset = input.limit();
                            this.headerParsingState.state = 1;
                            this.headerParsingState.checkOverflow(LocalizationMessages.HTTP_CHUNK_ENCODING_PREFIX_OVERFLOW());
                            return false;
                        }
                        this.headerParsingState.offset = nonSpaceIdx;
                        this.headerParsingState.state = 2;
                        break;
                    }
                    case 2: {
                        int offset;
                        int limit = Math.min(this.headerParsingState.packetLimit, input.limit());
                        long value = this.headerParsingState.parsingNumericValue;
                        for (offset = this.headerParsingState.offset; offset < limit; ++offset) {
                            byte b = input.get(offset);
                            if (HttpParserUtils.isSpaceOrTab(b) || b == 13 || b == 59) {
                                this.headerParsingState.checkpoint = offset;
                                continue;
                            }
                            if (b == 10) {
                                this.contentParsingState.chunkContentStart = offset + 1;
                                this.contentParsingState.chunkLength = value;
                                this.contentParsingState.chunkRemainder = value;
                                this.headerParsingState.state = 3;
                                return true;
                            }
                            if (this.headerParsingState.checkpoint == -1) {
                                if (DEC[b & 0xFF] != -1 && this.checkOverflow(value)) {
                                    value = (value << 4) + (long)DEC[b & 0xFF];
                                    continue;
                                }
                                throw new ParseException(LocalizationMessages.HTTP_INVALID_CHUNK_SIZE_HEX_VALUE(b));
                            }
                            throw new ParseException(LocalizationMessages.HTTP_UNEXPECTED_CHUNK_HEADER());
                        }
                        this.headerParsingState.parsingNumericValue = value;
                        this.headerParsingState.offset = offset;
                        this.headerParsingState.checkOverflow(LocalizationMessages.HTTP_CHUNK_ENCODING_PREFIX_OVERFLOW());
                        return false;
                    }
                }
            }
        }

        private boolean parseTrailerCRLF(ByteBuffer input) {
            if (this.headerParsingState.state == 3) {
                while (input.hasRemaining()) {
                    if (input.get() != 10) continue;
                    this.headerParsingState.recycle();
                    return input.hasRemaining();
                }
                return false;
            }
            return true;
        }

        private boolean checkOverflow(long chunkLength) {
            return chunkLength <= 0x7FFFFFFFFFFFFFFL;
        }

        private void initTrailerParsing() {
            int start;
            this.headerParsingState.subState = 0;
            this.headerParsingState.start = start = this.contentParsingState.chunkContentStart;
            this.headerParsingState.offset = start;
            this.headerParsingState.packetLimit = start + this.maxHeadersSize;
        }

        private boolean parseLastChunkTrailer(ByteBuffer input) throws ParseException {
            boolean result = this.httpParser.parseHeadersFromBuffer(input, true);
            if (!result) {
                this.headerParsingState.checkOverflow(LocalizationMessages.HTTP_TRAILER_HEADER_OVERFLOW());
            }
            return result;
        }
    }

    private static class FixedLengthEncodingParser
    extends TransferEncodingParser {
        private final long expectedLength;
        private final AsynchronousBodyInputStream responseBody;
        private volatile long consumedLength = 0L;

        FixedLengthEncodingParser(AsynchronousBodyInputStream responseBody, long expectedLength) {
            this.expectedLength = expectedLength;
            this.responseBody = responseBody;
        }

        @Override
        boolean parse(ByteBuffer input) throws ParseException {
            if ((long)input.remaining() + this.consumedLength > this.expectedLength) {
                throw new ParseException(LocalizationMessages.HTTP_BODY_SIZE_OVERFLOW());
            }
            byte[] data = new byte[input.remaining()];
            input.get(data);
            ByteBuffer parsed = ByteBuffer.wrap(data);
            this.responseBody.notifyDataAvailable(parsed);
            this.consumedLength += (long)data.length;
            return this.consumedLength == this.expectedLength || this.expectedLength == Long.MAX_VALUE;
        }
    }
}

