/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.LocalizationMessages;
import org.glassfish.jersey.media.sse.SseFeature;

public class EventSource
implements EventListener {
    public static final long RECONNECT_DEFAULT = 500L;
    private static final Level CONNECTION_ERROR_LEVEL = Level.FINE;
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(EventSource.class.getName()), Level.FINEST);
    private final WebTarget target;
    private final long reconnectDelay;
    private final boolean disableKeepAlive;
    private final ScheduledExecutorService executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final List<EventListener> unboundListeners = new CopyOnWriteArrayList<EventListener>();
    private final ConcurrentMap<String, List<EventListener>> boundListeners = new ConcurrentHashMap<String, List<EventListener>>();

    public static Builder target(WebTarget endpoint) {
        return new Builder(endpoint);
    }

    public EventSource(WebTarget endpoint) {
        this(endpoint, true);
    }

    public EventSource(WebTarget endpoint, boolean open) {
        this(endpoint, null, 500L, true, open);
    }

    private EventSource(WebTarget target, String name, long reconnectDelay, boolean disableKeepAlive, boolean open) {
        if (target == null) {
            throw new NullPointerException("Web target is 'null'.");
        }
        this.target = SseFeature.register(target);
        this.reconnectDelay = reconnectDelay;
        this.disableKeepAlive = disableKeepAlive;
        String esName = name == null ? EventSource.createDefaultName(target) : name;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(esName + "-%d").setDaemon(true).build());
        if (open) {
            this.open();
        }
    }

    private static String createDefaultName(WebTarget target) {
        return String.format("jersey-sse-event-source-[%s]", target.getUri().toASCIIString());
    }

    public void open() {
        if (!this.state.compareAndSet(State.READY, State.OPEN)) {
            switch (this.state.get()) {
                case OPEN: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CONNECTED());
                }
                case CLOSED: {
                    throw new IllegalStateException(LocalizationMessages.EVENT_SOURCE_ALREADY_CLOSED());
                }
            }
        }
        EventProcessor processor = new EventProcessor(this.reconnectDelay, null);
        this.executor.submit(processor);
        processor.awaitFirstContact();
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public void register(EventListener listener) {
        this.register(listener, null, new String[0]);
    }

    public void register(EventListener listener, String eventName, String ... eventNames) {
        if (eventName == null) {
            this.unboundListeners.add(listener);
        } else {
            this.addBoundListener(eventName, listener);
            if (eventNames != null) {
                for (String name : eventNames) {
                    this.addBoundListener(name, listener);
                }
            }
        }
    }

    private void addBoundListener(String name, EventListener listener) {
        List listeners = this.boundListeners.putIfAbsent(name, new CopyOnWriteArrayList<EventListener>(Collections.singleton(listener)));
        if (listeners != null) {
            listeners.add(listener);
        }
    }

    @Override
    public void onEvent(InboundEvent inboundEvent) {
    }

    public void close() {
        this.close(5L, TimeUnit.SECONDS);
    }

    public boolean close(long timeout, TimeUnit unit) {
        this.shutdown();
        try {
            if (!this.executor.awaitTermination(timeout, unit)) {
                LOGGER.log(CONNECTION_ERROR_LEVEL, LocalizationMessages.EVENT_SOURCE_SHUTDOWN_TIMEOUT(this.target.getUri().toString()));
                return false;
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(CONNECTION_ERROR_LEVEL, LocalizationMessages.EVENT_SOURCE_SHUTDOWN_INTERRUPTED(this.target.getUri().toString()));
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private void shutdown() {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            LOGGER.debugLog("Shutting down event processing.");
            this.executor.shutdownNow();
        }
    }

    private class EventProcessor
    implements Runnable,
    EventListener {
        private final CountDownLatch firstContactSignal;
        private String lastEventId;
        private long reconnectDelay;

        public EventProcessor(long reconnectDelay, String lastEventId) {
            this.firstContactSignal = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.lastEventId = lastEventId;
        }

        private EventProcessor(EventProcessor that) {
            this.firstContactSignal = null;
            this.reconnectDelay = that.reconnectDelay;
            this.lastEventId = that.lastEventId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.debugLog("Listener task started.");
            EventInput eventInput = null;
            try {
                try {
                    Invocation.Builder request = this.prepareHandshakeRequest();
                    if (EventSource.this.state.get() == State.OPEN) {
                        LOGGER.debugLog("Connecting...");
                        eventInput = (EventInput)((Object)request.get(EventInput.class));
                        LOGGER.debugLog("Connected!");
                    }
                }
                finally {
                    if (this.firstContactSignal != null) {
                        this.firstContactSignal.countDown();
                    }
                }
                Thread execThread = Thread.currentThread();
                while (EventSource.this.state.get() == State.OPEN && !execThread.isInterrupted()) {
                    if (eventInput == null || eventInput.isClosed()) {
                        LOGGER.debugLog("Connection lost - scheduling reconnect in {0} ms", new Object[]{this.reconnectDelay});
                        this.scheduleReconnect(this.reconnectDelay);
                        break;
                    }
                    this.onEvent((InboundEvent)eventInput.read());
                }
            }
            catch (ServiceUnavailableException ex) {
                LOGGER.debugLog("Received HTTP 503");
                long delay = this.reconnectDelay;
                if (ex.hasRetryAfter()) {
                    LOGGER.debugLog("Recovering from HTTP 503 using HTTP Retry-After header value as a reconnect delay");
                    Date requestTime = new Date();
                    delay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                    delay = delay > 0L ? delay : 0L;
                }
                LOGGER.debugLog("Recovering from HTTP 503 - scheduling to reconnect in {0} ms", new Object[]{delay});
                this.scheduleReconnect(delay);
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(CONNECTION_ERROR_LEVEL)) {
                    LOGGER.log(CONNECTION_ERROR_LEVEL, String.format("Unable to connect - closing the event source to %s.", EventSource.this.target.getUri().toASCIIString()), (Throwable)ex);
                }
                EventSource.this.shutdown();
            }
            finally {
                if (eventInput != null && !eventInput.isClosed()) {
                    eventInput.close();
                }
                LOGGER.debugLog("Listener task finished.");
            }
        }

        @Override
        public void onEvent(InboundEvent event) {
            List eventListeners;
            if (event == null) {
                return;
            }
            LOGGER.debugLog("New event received.");
            if (event.getId() != null) {
                this.lastEventId = event.getId();
            }
            if (event.isReconnectDelaySet()) {
                this.reconnectDelay = event.getReconnectDelay();
            }
            this.notify(EventSource.this, event);
            this.notify(EventSource.this.unboundListeners, event);
            String eventName = event.getName();
            if (eventName != null && (eventListeners = (List)EventSource.this.boundListeners.get(eventName)) != null) {
                this.notify(eventListeners, event);
            }
        }

        private void notify(Collection<EventListener> listeners, InboundEvent event) {
            for (EventListener listener : listeners) {
                this.notify(listener, event);
            }
        }

        private void notify(EventListener listener, InboundEvent event) {
            block2: {
                try {
                    listener.onEvent(event);
                }
                catch (Exception ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block2;
                    LOGGER.log(Level.FINE, String.format("Event notification in a listener of %s class failed.", listener.getClass().getName()), (Throwable)ex);
                }
            }
        }

        private void scheduleReconnect(long delay) {
            State s = (State)((Object)EventSource.this.state.get());
            if (s != State.OPEN) {
                LOGGER.debugLog("Aborting reconnect of event source in {0} state", new Object[]{EventSource.this.state});
                return;
            }
            EventProcessor processor = new EventProcessor(this);
            if (delay > 0L) {
                EventSource.this.executor.schedule(processor, delay, TimeUnit.MILLISECONDS);
            } else {
                EventSource.this.executor.submit(processor);
            }
        }

        private Invocation.Builder prepareHandshakeRequest() {
            Invocation.Builder request = EventSource.this.target.request(new MediaType[]{SseFeature.SERVER_SENT_EVENTS_TYPE});
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header("Last-Event-ID", (Object)this.lastEventId);
            }
            if (EventSource.this.disableKeepAlive) {
                request.header("Connection", (Object)"close");
            }
            return request;
        }

        public void awaitFirstContact() {
            LOGGER.debugLog("Awaiting first contact signal.");
            try {
                if (this.firstContactSignal == null) {
                    return;
                }
                try {
                    this.firstContactSignal.await();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(CONNECTION_ERROR_LEVEL, LocalizationMessages.EVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED(), (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                LOGGER.debugLog("First contact signal released.");
            }
        }
    }

    public static class Builder {
        private final WebTarget endpoint;
        private long reconnect = 500L;
        private String name = null;
        private boolean disableKeepAlive = true;

        private Builder(WebTarget endpoint) {
            this.endpoint = endpoint;
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder usePersistentConnections() {
            this.disableKeepAlive = false;
            return this;
        }

        public Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnect = unit.toMillis(delay);
            return this;
        }

        public EventSource build() {
            return new EventSource(this.endpoint, this.name, this.reconnect, this.disableKeepAlive, false);
        }

        public EventSource open() {
            EventSource source = new EventSource(this.endpoint, this.name, this.reconnect, this.disableKeepAlive, false);
            source.open();
            return source;
        }
    }

    private static enum State {
        READY,
        OPEN,
        CLOSED;

    }
}

