/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Scanner;
import org.glassfish.pfl.tf.spi.Util;
import org.glassfish.pfl.tf.spi.annotation.MethodMonitorGroup;
import org.glassfish.pfl.tf.timer.spi.TimingInfoProcessor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AnnotationScannerAction
implements Scanner.Action {
    private static Class<MethodMonitorGroup> MMG_CLASS = MethodMonitorGroup.class;
    private static String MMG_DESCRIPTOR = Type.getType(MMG_CLASS).getDescriptor();
    private final Util util;
    private final TimingInfoProcessor tip;
    private Set<String> annotationNames = new HashSet<String>();
    private String currentClass;

    AnnotationScannerAction(Util util, TimingInfoProcessor tip) {
        this.util = util;
        this.tip = tip;
    }

    public Set<String> getAnnotationNames() {
        return this.annotationNames;
    }

    @Override
    public boolean evaluate(FileWrapper fw) {
        try {
            byte[] inputData = fw.readAll();
            ClassReader cr = new ClassReader(inputData);
            ClassScanner as = new ClassScanner();
            cr.accept((ClassVisitor)as, 0);
        }
        catch (IOException ex) {
            return true;
        }
        return true;
    }

    private class ClassScanner
    extends ClassVisitor {
        private boolean visitingAnnotation;
        private String timerGroupDescription;
        private String timerGroupName;
        private List<Type> timerGroupMembers;

        private ClassScanner() {
            super(458752);
            this.visitingAnnotation = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            AnnotationScannerAction.this.util.info(3, "Visiting class " + name);
            if ((access & 0x2000) == 8192) {
                AnnotationScannerAction.this.util.info(2, "\t(Annotation)");
                AnnotationScannerAction.this.currentClass = name;
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationScannerAction.this.util.info(3, "\tVisiting annotation " + desc);
            if (desc.equals(MMG_DESCRIPTOR)) {
                AnnotationScannerAction.this.annotationNames.add(AnnotationScannerAction.this.currentClass);
                this.visitingAnnotation = true;
                this.timerGroupName = this.getGroupName(AnnotationScannerAction.this.currentClass);
                this.timerGroupDescription = "TimerGroup for Annotation " + this.timerGroupName;
                this.timerGroupMembers = new ArrayList<Type>();
                return new AnnoScanner(this.timerGroupDescription, this.timerGroupName, this.timerGroupMembers);
            }
            return null;
        }

        private String getGroupName(String desc) {
            String result = desc;
            int index = desc.lastIndexOf(47);
            if (index >= 0) {
                result = desc.substring(index + 1);
            }
            return result;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }
    }

    private class AnnoScanner
    extends AnnotationVisitor {
        private boolean visitingAnnotation;
        private String annotationValueName;
        private String timerGroupDescription;
        private final String timerGroupName;
        private List<Type> timerGroupMembers;

        private AnnoScanner(String timerGroupDesc, String timeGroupName, List<Type> timerGroupMembers) {
            super(458752);
            this.annotationValueName = null;
            this.visitingAnnotation = true;
            this.timerGroupDescription = timerGroupDesc;
            this.timerGroupName = timeGroupName;
            this.timerGroupMembers = timerGroupMembers;
        }

        public void visit(String name, Object value) {
            if (name == null) {
                if (this.annotationValueName.equals("value")) {
                    this.timerGroupMembers.add((Type)value);
                }
            } else if (name.equals("description")) {
                if (value instanceof String) {
                    this.timerGroupDescription = (String)value;
                }
            } else if (name.equals("value") && value instanceof Type[]) {
                this.timerGroupMembers = Arrays.asList((Type[])value);
            }
        }

        public AnnotationVisitor visitArray(String name) {
            this.annotationValueName = name;
            return this;
        }

        public void visitEnd() {
            if (this.visitingAnnotation) {
                this.visitingAnnotation = false;
                AnnotationScannerAction.this.tip.addTimerGroup(this.timerGroupName, this.timerGroupDescription);
                for (Type type : this.timerGroupMembers) {
                    String name = type.getClassName();
                    int index = name.lastIndexOf(46);
                    if (index >= 0) {
                        name = name.substring(index + 1);
                    }
                    AnnotationScannerAction.this.tip.contains(name);
                }
            }
        }
    }
}

