/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RollingFileOutputStream
extends OutputStream {
    long file_size = 0L;
    File outfile;
    long rollover_bytes = 0L;
    long rollover_ms = 0L;
    long file_creation_time = 0L;
    private int num_files = 9;
    private FileOutputStream out;
    private static SharedResources rb = SharedResources.getResources();
    private RandomAccessFile raf = null;

    public RollingFileOutputStream(File outfile, long rollover_bytes, long rollover_secs) throws IOException {
        this.outfile = outfile;
        this.setRolloverBytes(rollover_bytes);
        this.setRolloverSecs(rollover_secs);
        if (outfile.exists()) {
            if (!outfile.canWrite()) {
                throw new FileNotFoundException(rb.getString("S4001", outfile));
            }
            if (outfile.isDirectory()) {
                throw new FileNotFoundException(rb.getString("S4002", outfile));
            }
        }
        this.file_size = outfile.length();
        this.raf = null;
        this.raf = new RandomAccessFile(outfile, "rw");
        if (this.file_size == 0L) {
            this.out = new FileOutputStream(this.raf.getFD());
            this.file_creation_time = System.currentTimeMillis();
            try {
                this.writeCreationTime(this.out, this.file_creation_time);
            }
            catch (IOException e) {
                throw new IOException(rb.getString("S4003", outfile));
            }
        }
        try {
            this.file_creation_time = this.readCreationTime(this.raf);
        }
        catch (IOException e) {
            throw new IOException(rb.getString("S4004", outfile));
        }
        this.raf.seek(this.raf.length());
        this.out = new FileOutputStream(this.raf.getFD());
        if (this.doRollover()) {
            this.rolloverFile();
        }
    }

    private void writeCreationTime(OutputStream os, long time) throws IOException {
        String s = "# " + time + " Do not modify this line" + SharedResources.NL;
        os.write(s.getBytes("us-ascii"));
    }

    private long readCreationTime(RandomAccessFile raf) throws IOException, EOFException {
        byte digit;
        int n;
        raf.seek(0L);
        if (raf.skipBytes(2) != 2) {
            throw new IOException("Could not skip bytes");
        }
        byte[] timeBytes = new byte[128];
        long time = 0L;
        for (n = 0; n < 128 && (digit = raf.readByte()) >= 48 && digit <= 57; ++n) {
            timeBytes[n] = digit;
        }
        int base = 0;
        --n;
        while (n >= 0) {
            time = (long)((double)time + (double)(timeBytes[n] - 48) * Math.pow(10.0, base));
            ++base;
            --n;
        }
        raf.seek(raf.length());
        return time;
    }

    public RollingFileOutputStream(File outfile, long rollover_bytes) throws IOException {
        this(outfile, 1024L, 0L);
    }

    public RollingFileOutputStream(File outfile) throws IOException {
        this(outfile, 1024L);
    }

    public void setNumFiles(int n) {
        this.num_files = n;
    }

    public int getNumFiles() {
        return this.num_files;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        ++this.file_size;
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.doRollover()) {
            this.rolloverFile();
        }
        this.file_size += (long)len;
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    void rolloverFile() throws IOException {
        File newfile;
        String s;
        File testfile;
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if ((testfile = new File(RollingFileOutputStream.generateFilename(s = this.outfile.getAbsolutePath(), this.num_files))).exists()) {
            testfile.delete();
        }
        for (int i = this.num_files - 1; i > 0; --i) {
            testfile = new File(RollingFileOutputStream.generateFilename(s, i));
            if (!testfile.exists()) continue;
            newfile = new File(RollingFileOutputStream.generateFilename(s, i + 1));
            testfile.renameTo(newfile);
        }
        newfile = new File(RollingFileOutputStream.generateFilename(s, 1));
        this.outfile.renameTo(newfile);
        this.out = new FileOutputStream(this.outfile);
        this.file_creation_time = System.currentTimeMillis();
        try {
            this.writeCreationTime(this.out, this.file_creation_time);
        }
        catch (Exception e) {
            System.out.println("Got exception" + e);
        }
        this.file_size = this.outfile.length();
    }

    public static String generateFilename(String name, int i) {
        int n = name.lastIndexOf(46);
        if (n == -1) {
            return name + "_" + i;
        }
        return name.substring(0, n) + "_" + i + name.substring(n);
    }

    boolean doRollover() {
        return this.rollover_bytes != 0L && this.file_size >= this.rollover_bytes || this.rollover_ms != 0L && System.currentTimeMillis() - this.file_creation_time > this.rollover_ms;
    }

    public void setRolloverSecs(long seconds) {
        this.rollover_ms = seconds * 1000L;
    }

    public long getRolloverSecs() {
        return this.rollover_ms / 1000L;
    }

    public void setRolloverBytes(long bytes) {
        this.rollover_bytes = bytes;
    }

    public long getRolloverBytes() {
        return this.rollover_bytes;
    }
}

